/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.pickablepets.utils;

import com.shiftthedev.pickablepets.PickablePets;
import com.shiftthedev.pickablepets.client.ScreenHelper;
import com.shiftthedev.pickablepets.compat.DawnEraHelper;
import com.shiftthedev.pickablepets.compat.DoggyHelper;
import com.shiftthedev.pickablepets.compat.GoetyHelper;
import com.shiftthedev.pickablepets.network.ConvertPacket;
import com.shiftthedev.pickablepets.network.ManagePetsPacket;
import com.shiftthedev.pickablepets.utils.PetInfo;
import com.shiftthedev.pickablepets.utils.PlayerPets;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class CachedPets {
    private static TreeMap<UUID, PetInfo> pets = new TreeMap();
    private static Level overworldLevel;

    public static boolean isValidPet(String uuid) {
        return pets.containsKey(UUID.fromString(uuid));
    }

    public static LivingEntity getPet(UUID uuid) {
        if (pets.containsKey(uuid)) {
            return pets.get(uuid).getPetEntity();
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static LivingEntity getRender(UUID uuid) {
        if (pets.containsKey(uuid)) {
            return pets.get(uuid).getRender();
        }
        ManagePetsPacket.sendToServer(uuid);
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static LivingEntity getItemRender(ItemStack petStack) {
        CompoundTag tag = petStack.m_41698_("pet_info");
        if (!tag.m_128441_("VERSION")) {
            ConvertPacket.sendToServer(petStack);
            tag.m_128405_("VERSION", 2);
        }
        if (tag.m_128451_("VERSION") != 2) {
            ConvertPacket.sendToServer(petStack);
            tag.m_128405_("VERSION", 2);
        }
        if (tag.m_128441_("UUID")) {
            return CachedPets.getRender(tag.m_128342_("UUID"));
        }
        return null;
    }

    public static String getOwner(UUID uuid) {
        if (pets.containsKey(uuid)) {
            return pets.get(uuid).getOwner();
        }
        return "";
    }

    public static ListTag getPetAttributes(UUID petUUID) {
        if (pets.containsKey(petUUID)) {
            return pets.get(petUUID).getAttributes();
        }
        return new ListTag();
    }

    public static void addOldPet(@Nullable CompoundTag oldTag) {
        if (overworldLevel == null) {
            return;
        }
        Optional entityType = EntityType.m_20632_((String)oldTag.m_128461_("pet_type"));
        if (entityType.isEmpty()) {
            return;
        }
        LivingEntity entity = (LivingEntity)((EntityType)entityType.get()).m_20615_(overworldLevel);
        if (entity == null) {
            return;
        }
        if (!(entity instanceof OwnableEntity)) {
            return;
        }
        entity.m_20258_(oldTag);
        if (pets.containsKey(entity.m_20148_())) {
            if (oldTag.m_128451_("VERSION") == 1) {
                pets.get(entity.m_20148_()).updateAttributes(entity);
            }
            pets.get(entity.m_20148_()).updateEntity(entity);
        } else {
            pets.put(entity.m_20148_(), new PetInfo(entity, oldTag.m_128461_("owner_name")));
        }
        oldTag.m_128405_("VERSION", 2);
        pets.get(entity.m_20148_()).setInItem(true);
        CachedPets.sendPetsToPlayers(overworldLevel, entity.m_20148_());
    }

    public static void addPet(LivingEntity entity) {
        if (pets.containsKey(entity.m_20148_())) {
            pets.get(entity.m_20148_()).updateEntity(entity);
        } else {
            pets.put(entity.m_20148_(), new PetInfo(entity));
        }
    }

    public static void replaceWolf(ServerPlayer player, UUID oldID, TamableAnimal dog) {
        if (dog.m_20148_().equals(oldID) && pets.containsKey(dog.m_20148_())) {
            pets.get(dog.m_20148_()).updateEntity((LivingEntity)dog);
            return;
        }
        pets.remove(oldID);
        Level level = dog.m_9236_();
        if (level == null) {
            if (overworldLevel == null) {
                return;
            }
            level = overworldLevel;
        }
        if (dog.m_21805_() == null) {
            return;
        }
        pets.put(dog.m_20148_(), new PetInfo((LivingEntity)dog));
        PlayerPets.replacePetAsync((ServerLevel)level, dog.m_21805_(), oldID, dog.m_20148_());
        CachedPets.sendRemovePet(level, oldID);
        CachedPets.sendPetsToPlayer(player, dog.m_20148_());
    }

    public static void removePet(UUID uuid, @Nullable Level level) {
        if (!pets.containsKey(uuid)) {
            return;
        }
        if (level == null) {
            if (overworldLevel == null) {
                return;
            }
            level = overworldLevel;
        }
        LivingEntity pet = pets.get(uuid).getPetEntity();
        if (!level.f_46443_) {
            UUID ownerID;
            if (PickablePets.FoundDawnEra && DawnEraHelper.isFromMod(pet)) {
                PlayerPets.removePetAsync((ServerLevel)level, DawnEraHelper.getOwnerUUID(pet), uuid);
            } else if (PickablePets.FoundGoety && GoetyHelper.isFromMod(pet)) {
                PlayerPets.removePetAsync((ServerLevel)level, GoetyHelper.getOwnerUUID(pet), uuid);
            } else if (PickablePets.FoundDoggy && DoggyHelper.isFromMod(pet)) {
                PlayerPets.removePetAsync((ServerLevel)level, DoggyHelper.getOwnerUUID(pet), uuid);
            } else if (pet instanceof OwnableEntity && (ownerID = ((OwnableEntity)pet).m_21805_()) != null) {
                PlayerPets.removePetAsync((ServerLevel)level, ownerID, uuid);
            }
        }
        pets.remove(uuid);
        CachedPets.sendRemovePet(level, uuid);
    }

    public static void setPetItem(UUID uuid, boolean flag) {
        if (!pets.containsKey(uuid)) {
            return;
        }
        pets.get(uuid).setInItem(flag);
    }

    public static boolean isInItem(UUID uuid) {
        if (!pets.containsKey(uuid)) {
            return false;
        }
        return pets.get(uuid).isInItem();
    }

    public static void killPet(UUID uuid) {
        if (!pets.containsKey(uuid)) {
            return;
        }
        pets.get(uuid).markDead();
    }

    public static void revivePet(UUID uuid) {
        if (!pets.containsKey(uuid)) {
            return;
        }
        pets.get(uuid).revive();
    }

    public static boolean isPetAlive(UUID uuid) {
        if (!pets.containsKey(uuid)) {
            return false;
        }
        return pets.get(uuid).isAlive();
    }

    public static Component getPetName(UUID uuid) {
        if (pets.containsKey(uuid)) {
            return pets.get(uuid).getName();
        }
        ManagePetsPacket.sendToServer(uuid);
        return Component.m_237119_();
    }

    public static void setUpdated(UUID uuid) {
        if (!pets.containsKey(uuid)) {
            return;
        }
        pets.get(uuid).setUpdated();
    }

    public static boolean isPetUpdated(UUID uuid) {
        if (!pets.containsKey(uuid)) {
            return false;
        }
        return pets.get(uuid).isUpdated();
    }

    public static boolean wasPetRevived(UUID uuid) {
        if (!pets.containsKey(uuid)) {
            return false;
        }
        return pets.get(uuid).wasRevived();
    }

    public static void save(Path path) {
        ListTag listTag = new ListTag();
        TreeMap<UUID, PetInfo> tempMap = new TreeMap<UUID, PetInfo>();
        for (Map.Entry<UUID, PetInfo> petEntry : pets.entrySet()) {
            CompoundTag entryTag = new CompoundTag();
            entryTag.m_128362_("Key", petEntry.getKey());
            entryTag.m_128365_("Value", (Tag)petEntry.getValue().save(new CompoundTag()));
            listTag.add((Object)entryTag);
            tempMap.put(petEntry.getKey(), petEntry.getValue());
        }
        pets.clear();
        pets = new TreeMap();
        pets.putAll(tempMap);
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("pets", (Tag)listTag);
        if (!path.toFile().exists()) {
            path.toFile().mkdirs();
        }
        File file = new File(path.toFile(), "pets.dat");
        try {
            NbtIo.m_128944_((CompoundTag)tag, (File)file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void load(Path path, MinecraftServer server) {
        CompoundTag tag;
        overworldLevel = server.m_129783_();
        pets = new TreeMap();
        File file = new File(path.toFile(), "pets.dat");
        if (!file.exists()) {
            return;
        }
        try {
            tag = NbtIo.m_128937_((File)file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (tag == null) {
            return;
        }
        if (!tag.m_128441_("pets")) {
            return;
        }
        pets.clear();
        ListTag listTag = tag.m_128437_("pets", 10);
        for (Tag entry : listTag) {
            if (!(entry instanceof CompoundTag)) continue;
            CompoundTag entryTag = (CompoundTag)entry;
            CompoundTag value = entryTag.m_128469_("Value");
            UUID petId = entryTag.m_128342_("Key");
            PetInfo petEntry = new PetInfo();
            petEntry.load(petId, value, overworldLevel);
            pets.put(petId, petEntry);
        }
    }

    public static void clearData() {
        if (pets != null) {
            pets.clear();
        }
        pets = new TreeMap();
        overworldLevel = null;
    }

    public static void sendPetsToPlayers(Level level, UUID petUUID) {
        if (level == null) {
            if (overworldLevel == null) {
                return;
            }
            level = overworldLevel;
        }
        if (level.f_46443_) {
            return;
        }
        level.m_6907_().forEach(player -> CachedPets.sendPetsToPlayer((ServerPlayer)player, petUUID));
    }

    public static void sendPetsToPlayer(ServerPlayer player, UUID requestedUUID) {
        if (!pets.containsKey(requestedUUID)) {
            return;
        }
        ManagePetsPacket.sendToPlayer(requestedUUID, pets.get(requestedUUID).save(new CompoundTag()), player);
    }

    public static void sendRemovePet(Level level, UUID uuid) {
        if (level.f_46443_) {
            return;
        }
        level.m_6907_().forEach(player -> CachedPets.sendPetsToPlayer((ServerPlayer)player, uuid));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void getPetFromServer(UUID petUUID, CompoundTag petTag, Level level) {
        PetInfo serverPet = new PetInfo();
        serverPet.load(petUUID, petTag, level);
        ScreenHelper.tryUpdateScreen(true);
        pets.remove(petUUID);
        pets.put(petUUID, serverPet);
    }
}

