/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.pickablepets.utils;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.shiftthedev.pickablepets.PPRegistry;
import com.shiftthedev.pickablepets.PickablePets;
import com.shiftthedev.pickablepets.compat.DawnEraHelper;
import com.shiftthedev.pickablepets.compat.DomesticationHelper;
import com.shiftthedev.pickablepets.compat.GoetyHelper;
import com.shiftthedev.pickablepets.network.ConvertPacket;
import com.shiftthedev.pickablepets.utils.CachedPets;
import dev.architectury.platform.Platform;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class Helper {
    public static boolean Pickup(LivingEntity livingEntity, LivingEntity playerEntity) {
        if (!(playerEntity instanceof ServerPlayer)) {
            return false;
        }
        ServerPlayer player = (ServerPlayer)playerEntity;
        boolean isException = false;
        if (Platform.isForge()) {
            if (PickablePets.FoundDawnEra && DawnEraHelper.isFromMod(livingEntity)) {
                isException = true;
                if (!DawnEraHelper.isOwner(livingEntity, (LivingEntity)player)) {
                    return false;
                }
            }
            if (PickablePets.FoundDomestication && DomesticationHelper.isFromMod(livingEntity)) {
                isException = true;
                if (!DomesticationHelper.isOwner(livingEntity, player)) {
                    return false;
                }
            }
            if (PickablePets.FoundGoety && GoetyHelper.isFromMod(livingEntity)) {
                isException = true;
                if (!GoetyHelper.isOwner(livingEntity, (LivingEntity)player)) {
                    return false;
                }
            }
        }
        if (!isException) {
            if (!(livingEntity instanceof OwnableEntity)) {
                return false;
            }
            OwnableEntity ownableEntity = (OwnableEntity)livingEntity;
            if (livingEntity instanceof AbstractHorse) {
                Helper.fixHorse((AbstractHorse)livingEntity, player);
            }
            if (ownableEntity.m_269323_() == null) {
                return false;
            }
            if (!ownableEntity.m_21805_().equals(player.m_20148_())) {
                return false;
            }
        }
        if (!Helper.isPickable(livingEntity, (Player)player)) {
            return false;
        }
        ItemStack itemStack = new ItemStack((ItemLike)PPRegistry.PET_ITEM.get());
        CompoundTag tag = itemStack.m_41698_("pet_info");
        tag = livingEntity.m_20240_(tag);
        tag.m_128359_("pet_type", EntityType.m_20613_((EntityType)livingEntity.m_6095_()).toString());
        if (livingEntity.m_8077_()) {
            itemStack.m_41714_(livingEntity.m_5446_());
        } else {
            tag.m_128359_("pet_default_name", "entity." + tag.m_128461_("pet_type").replace(':', '.'));
        }
        tag.m_128405_("VERSION", 2);
        if (!player.m_36356_(itemStack)) {
            player.m_5661_((Component)Component.m_237115_((String)"message.pickablepets.inventory_nospace"), true);
            return false;
        }
        player.m_9236_().m_7654_().execute(() -> {
            CachedPets.addPet(livingEntity);
            CachedPets.setPetItem(livingEntity.m_20148_(), true);
            CachedPets.sendPetsToPlayers(playerEntity.m_9236_(), livingEntity.m_20148_());
            CachedPets.setUpdated(livingEntity.m_20148_());
            livingEntity.m_142687_(Entity.RemovalReason.DISCARDED);
            player.m_6749_(-PickablePets.CONFIG.PickupCost);
            player.m_5496_(SoundEvents.f_12509_, 1.0f, player.m_6100_());
        });
        return true;
    }

    public static void fixHorse(AbstractHorse horse, ServerPlayer player) {
        if (horse.m_21805_() != null) {
            return;
        }
        if (!horse.m_30614_()) {
            return;
        }
        horse.m_30586_(player.m_20148_());
    }

    private static boolean isPickable(LivingEntity livingEntity, Player playerEntity) {
        if (PickablePets.CONFIG.MaxPetsInInventory > 0 && Helper.countSlotMatchingItem(playerEntity) >= PickablePets.CONFIG.MaxPetsInInventory) {
            playerEntity.m_5661_((Component)Component.m_237115_((String)"message.pickablepets.inventory_full"), true);
            return false;
        }
        if (!livingEntity.m_6084_()) {
            playerEntity.m_5661_((Component)Component.m_237115_((String)"message.pickablepets.dead"), true);
            return false;
        }
        if (livingEntity.m_6162_() && PickablePets.CONFIG.OnlyAdults) {
            playerEntity.m_5661_((Component)Component.m_237115_((String)"message.pickablepets.baby"), true);
            return false;
        }
        if (livingEntity.m_5803_()) {
            playerEntity.m_5661_((Component)Component.m_237115_((String)"message.pickablepets.sleep"), true);
            return false;
        }
        double distance = playerEntity.m_20270_((Entity)livingEntity);
        if (distance > (double)PickablePets.CONFIG.PickupDistance) {
            playerEntity.m_5661_((Component)Component.m_237115_((String)"message.pickablepets.far"), true);
            return false;
        }
        if (!playerEntity.m_7500_() && playerEntity.f_36078_ < PickablePets.CONFIG.PickupCost) {
            playerEntity.m_5661_((Component)Component.m_237115_((String)"message.pickablepets.noxp"), true);
            return false;
        }
        return true;
    }

    private static int countSlotMatchingItem(Player player) {
        Inventory inventory = player.m_150109_();
        int count = 0;
        for (int i = 0; i < inventory.f_35974_.size(); ++i) {
            if (((ItemStack)inventory.f_35974_.get(i)).m_41619_() || !((Item)PPRegistry.PET_ITEM.get()).equals(((ItemStack)inventory.f_35974_.get(i)).m_41720_())) continue;
            ++count;
        }
        return count;
    }

    public static void renderPet(LivingEntity entity, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, EntityRenderDispatcher entityRenderer, float rotation, float scale) {
        if (entity != null) {
            poseStack.m_85836_();
            float s = scale / entity.m_20206_();
            poseStack.m_85837_(0.5, 0.125, 0.5);
            poseStack.m_252781_(Axis.f_252392_.m_252977_(rotation));
            if (entity.f_20919_ == 20) {
                poseStack.m_252781_(Axis.f_252393_.m_252977_(-90.0f));
            }
            poseStack.m_85836_();
            poseStack.m_85841_(s, s, s);
            entityRenderer.m_114468_(false);
            entityRenderer.m_114384_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 0.0f, poseStack, multiBufferSource, i);
            entityRenderer.m_114468_(true);
            poseStack.m_85849_();
            poseStack.m_85849_();
        }
    }

    public static void convertOldPet(ItemStack oldStack) {
        CompoundTag tag = oldStack.m_41698_("pet_info");
        if (tag.m_128441_("VERSION") && tag.m_128451_("VERSION") == 2) {
            return;
        }
        ConvertPacket.sendToServer(oldStack);
        tag.m_128405_("VERSION", 2);
    }
}

