/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.pickablepets.utils;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.storage.LevelResource;

public class PlayerPets {
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newFixedThreadPool(20);

    public static CompletableFuture<Void> addPetAsync(Path path, UUID pet) {
        return PlayerPets.loadPetAsync(path).thenCompose(pets -> {
            pets.add(pet.toString());
            return PlayerPets.savePetAsync(path, pets);
        });
    }

    public static CompletableFuture<Void> replacePetAsync(ServerLevel level, UUID owner, UUID oldPet, UUID newPet) {
        Path path = level.m_7654_().m_129843_(new LevelResource("data/pets"));
        Path finalPath = path = path.resolve(owner.toString() + ".pets");
        return PlayerPets.loadPetAsync(path).thenCompose(pets -> {
            pets.remove(oldPet.toString());
            pets.add(newPet.toString());
            return PlayerPets.savePetAsync(finalPath, pets);
        });
    }

    public static CompletableFuture<Void> removePetAsync(ServerLevel level, UUID owner, UUID pet) {
        Path path = level.m_7654_().m_129843_(new LevelResource("data/pets"));
        Path finalPath = path = path.resolve(owner.toString() + ".pets");
        return PlayerPets.loadPetAsync(path).thenCompose(pets -> {
            pets.remove(pet.toString());
            return PlayerPets.savePetAsync(finalPath, pets);
        });
    }

    public static CompletableFuture<Void> removeBrokenPetsAsync(Path path, List<String> broken) {
        return PlayerPets.loadPetAsync(path).thenCompose(pets -> {
            pets.removeAll(broken);
            return PlayerPets.savePetAsync(path, pets);
        });
    }

    private static CompletableFuture<Void> savePetAsync(Path file, List<String> pets) {
        return CompletableFuture.runAsync(() -> {
            try {
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
                if (file.toFile().exists()) {
                    Files.delete(file);
                }
                Files.write(file, (Iterable<? extends CharSequence>)pets, StandardOpenOption.CREATE);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }, EXECUTOR_SERVICE);
    }

    public static void saveOldPet(String petId, String ownerId, ServerLevel level) {
        try {
            List<String> pets;
            Path file = level.m_7654_().m_129843_(new LevelResource("data/pets"));
            file = file.resolve(ownerId + ".pets");
            if (Files.exists(file, new LinkOption[0])) {
                pets = Files.readAllLines(file);
            } else {
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
                pets = new ArrayList<String>();
            }
            if (pets.contains(petId)) {
                return;
            }
            pets.add(petId);
            Files.write(file, pets, StandardOpenOption.CREATE);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static CompletableFuture<List<String>> loadPetAsync(Path file) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                if (Files.exists(file, new LinkOption[0])) {
                    return Files.readAllLines(file);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return new ArrayList();
        }, EXECUTOR_SERVICE);
    }
}

