/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.pickablepets.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.shiftthedev.pickablepets.PickablePets;
import com.shiftthedev.pickablepets.client.gui.AltarButton;
import com.shiftthedev.pickablepets.client.gui.PetButton;
import com.shiftthedev.pickablepets.containers.ReviveAltarContainer;
import com.shiftthedev.pickablepets.network.AltarRequestPacket;
import com.shiftthedev.pickablepets.network.RevivePacket;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_465;
import net.minecraft.class_490;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import net.minecraft.class_757;
import net.minecraft.class_7919;

@Environment(value=EnvType.CLIENT)
public class ReviveAltarScreen
extends class_465<ReviveAltarContainer> {
    private static final class_2960 TEXTURE = class_2960.method_60655((String)"pickablepets", (String)"textures/gui/altar.png");
    private int petItem;
    private int scrollOff;
    private boolean isDragging;
    private boolean isLoading;
    private List<UUID> petIDS;
    private PetButton[] petButtons;
    private AltarButton selectButton;
    private AltarButton reviveButton;

    public ReviveAltarScreen(ReviveAltarContainer reviveAltarContainer, class_1661 inventory, class_2561 component) {
        super((class_1703)reviveAltarContainer, inventory, component);
        this.field_2792 = 276;
        this.field_25269 = 107;
    }

    protected void method_25426() {
        super.method_25426();
        this.selectButton = (AltarButton)this.method_37063((class_364)new AltarButton(193 + this.field_2776, 51 + this.field_2800, true, (class_2561)class_2561.method_43471((String)"gui.pickablepets.select"), button -> {}));
        this.selectButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.pickablepets.select.tooltip")));
        this.reviveButton = (AltarButton)this.method_37063((class_364)new AltarButton(193 + this.field_2776, 51 + this.field_2800, false, (class_2561)class_2561.method_43471((String)"gui.pickablepets.revive"), button -> this.reviveButtonClick()));
        this.reviveButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.pickablepets.revive.tooltip")));
        this.isLoading = true;
        this.petItem = -1;
        AltarRequestPacket.Client.sendToServer();
    }

    public void populatePetList(List<UUID> newPetList) {
        if (!newPetList.isEmpty()) {
            this.petIDS = newPetList;
            int i = (this.field_22789 - this.field_2792) / 2;
            int j = (this.field_22790 - this.field_2779) / 2;
            int k = j + 16;
            int limit = Math.min(newPetList.size(), 7);
            this.petButtons = new PetButton[limit];
            for (int index = 0; index < limit; ++index) {
                this.petButtons[index] = (PetButton)this.method_37063((class_364)new PetButton(i + 5, k, index, newPetList.get(index), this::petButtonClick));
                k += 20;
            }
        }
        this.isLoading = false;
    }

    private void petButtonClick(class_4185 button) {
        if (button instanceof PetButton) {
            PetButton petButton = (PetButton)button;
            this.petItem = petButton.getIndex() + this.scrollOff;
            if (this.petItem != -1) {
                this.selectButton.field_22763 = false;
                this.selectButton.field_22764 = false;
                this.reviveButton.field_22764 = true;
                this.reviveButton.field_22763 = !PickablePets.CACHE.isPetAlive(petButton.getPetID()) && ((ReviveAltarContainer)this.field_2797).hasReviveCurrency() && class_310.method_1551().field_1724 != null;
            }
        }
    }

    private void reviveButtonClick() {
        if (this.petItem == -1 || !((ReviveAltarContainer)this.field_2797).hasReviveCurrency()) {
            return;
        }
        RevivePacket.Client.sendToServer(this.petIDS.get(this.petItem), ((ReviveAltarContainer)this.field_2797).getBlockPosition());
    }

    public void updateButtons(boolean fullRefresh) {
        boolean alive;
        UUID id;
        class_1309 pet;
        if (fullRefresh) {
            AltarRequestPacket.Client.sendToServer();
        }
        this.reviveButton.field_22763 = this.petItem != -1 && ((ReviveAltarContainer)this.field_2797).hasReviveCurrency() ? ((pet = PickablePets.CACHE.getPet(id = this.petIDS.get(this.petItem))) != null && class_310.method_1551().field_1724 != null ? !(alive = PickablePets.CACHE.isPetAlive(id)) : false) : false;
    }

    public void method_25394(class_332 guiGraphics, int i, int j, float f) {
        class_1309 pet;
        this.method_25420(guiGraphics, i, j, f);
        super.method_25394(guiGraphics, i, j, f);
        if (this.petIDS != null && !this.petIDS.isEmpty() && this.petButtons != null) {
            int k = (this.field_22789 - this.field_2792) / 2;
            int l = (this.field_22790 - this.field_2779) / 2;
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
            this.renderScroller(guiGraphics, k, l);
            int start = this.scrollOff;
            for (PetButton button : this.petButtons) {
                button.updateButton(this.petIDS.get(start), start);
                button.field_22764 = button.getIndex() < this.petIDS.size();
                ++start;
            }
            RenderSystem.enableDepthTest();
        }
        if (this.petItem != -1 && (pet = PickablePets.CACHE.getRender(this.petIDS.get(this.petItem))) != null) {
            class_490.method_2486((class_332)guiGraphics, (int)(this.field_2776 + 113), (int)(this.field_2800 + 17), (int)(this.field_2776 + 162), (int)(this.field_2800 + 66), (int)30, (float)0.0625f, (float)i, (float)j, (class_1309)pet);
        }
        this.method_2380(guiGraphics, i, j);
    }

    protected void method_2388(class_332 guiGraphics, int i, int j) {
        class_1309 pet;
        super.method_2388(guiGraphics, i, j);
        if (this.isLoading) {
            class_5250 text = class_2561.method_43471((String)"gui.pickablepets.loading");
            class_5481 formattedCharSequence = text.method_30937();
            guiGraphics.method_51439(this.field_22793, (class_2561)text, 220 - this.field_22793.method_30880(formattedCharSequence) / 2, 25, 0xFFFFFF, false);
        } else if (this.petIDS == null || this.petIDS.isEmpty()) {
            class_5250 text = class_2561.method_43471((String)"gui.pickablepets.nopets");
            class_5481 formattedCharSequence = text.method_30937();
            guiGraphics.method_51439(this.field_22793, (class_2561)text, 220 - this.field_22793.method_30880(formattedCharSequence) / 2, 25, 0x404040, false);
        } else if (this.petItem != -1 && (pet = PickablePets.CACHE.getPet(this.petIDS.get(this.petItem))) != null) {
            int textY = 6;
            class_5250 text = class_2561.method_43471((String)"gui.pickablepets.dim").method_27692(class_124.field_1073);
            class_5481 formattedCharSequence = text.method_30937();
            guiGraphics.method_51439(this.field_22793, (class_2561)text, 220 - this.field_22793.method_30880(formattedCharSequence) / 2, textY, 0xFFFFFF, false);
            text = class_2561.method_43471((String)pet.method_37908().method_27983().method_29177().toString());
            formattedCharSequence = text.method_30937();
            Objects.requireNonNull(this.field_22793);
            guiGraphics.method_51439(this.field_22793, (class_2561)text, 220 - this.field_22793.method_30880(formattedCharSequence) / 2, textY += 9 + 2, 15767114, false);
            text = class_2561.method_43471((String)"gui.pickablepets.pos").method_27692(class_124.field_1073);
            formattedCharSequence = text.method_30937();
            Objects.requireNonNull(this.field_22793);
            guiGraphics.method_51439(this.field_22793, (class_2561)text, 220 - this.field_22793.method_30880(formattedCharSequence) / 2, textY += 9 + 3, 0xFFFFFF, false);
            text = PickablePets.CACHE.isInItem(this.petIDS.get(this.petItem)) ? class_2561.method_43471((String)"gui.pickablepets.pos.item") : class_2561.method_43470((String)pet.method_24515().method_23854());
            formattedCharSequence = text.method_30937();
            Objects.requireNonNull(this.field_22793);
            guiGraphics.method_51439(this.field_22793, (class_2561)text, 220 - this.field_22793.method_30880(formattedCharSequence) / 2, textY += 9 + 2, 15767114, false);
        }
    }

    protected void method_2389(class_332 guiGraphics, float f, int i, int j) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int k = (this.field_22789 - this.field_2792) / 2;
        int l = (this.field_22790 - this.field_2779) / 2;
        guiGraphics.method_25291(TEXTURE, k, l, 0, 0.0f, 0.0f, this.field_2792, this.field_2779, 512, 256);
    }

    private void renderScroller(class_332 guiGraphics, int i, int j) {
        int k = this.petIDS.size() + 1 - 7;
        if (k > 1) {
            int l = 139 - (27 + (k - 1) * 139 / k);
            int m = 1 + l / k + 139 / k;
            int o = Math.min(123, this.scrollOff * m);
            if (this.scrollOff == k - 1) {
                o = 123;
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            guiGraphics.method_25290(TEXTURE, i + 94, j + 17 + o, 288.0f, 0.0f, 6, 16, 512, 256);
        } else {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            guiGraphics.method_25290(TEXTURE, i + 94, j + 17, 294.0f, 0.0f, 6, 16, 512, 256);
        }
    }

    private boolean canScroll(int i) {
        return i > 7;
    }

    public boolean method_25401(double d, double e, double f, double g) {
        if (this.petIDS == null || this.petIDS.isEmpty()) {
            return super.method_25401(d, e, f, g);
        }
        int i = this.petIDS.size();
        if (this.canScroll(i)) {
            int j = i - 7;
            this.scrollOff = class_3532.method_15340((int)((int)((double)this.scrollOff - g)), (int)0, (int)j);
        }
        return true;
    }

    public boolean method_25403(double d, double e, int i, double f, double g) {
        if (this.petIDS == null || this.petIDS.isEmpty()) {
            return super.method_25403(d, e, i, f, g);
        }
        int j = this.petIDS.size();
        if (this.isDragging) {
            int k = this.field_2800 + 18;
            int l = k + 139;
            int m = j - 7;
            float h = ((float)e - (float)k - 13.5f) / ((float)(l - k) - 27.0f);
            h = h * (float)m + 0.5f;
            this.scrollOff = class_3532.method_15340((int)((int)h), (int)0, (int)m);
            return true;
        }
        return super.method_25403(d, e, i, f, g);
    }

    public boolean method_25402(double d, double e, int i) {
        if (this.petIDS == null || this.petIDS.isEmpty()) {
            return super.method_25402(d, e, i);
        }
        this.isDragging = false;
        int j = (this.field_22789 - this.field_2792) / 2;
        int k = (this.field_22790 - this.field_2779) / 2;
        if (this.canScroll(this.petIDS.size()) && d > (double)(j + 94) && d < (double)(j + 94 + 6) && e > (double)(k + 18) && e <= (double)(k + 18 + 139 + 1)) {
            this.isDragging = true;
        }
        return super.method_25402(d, e, i);
    }

    public boolean method_25421() {
        return false;
    }
}

