/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.pickablepets.data;

import com.shiftthedev.alexandria.Alexandria;
import com.shiftthedev.alexandria.data.CachedEntities;
import com.shiftthedev.alexandria.data.EntityDataComponent;
import com.shiftthedev.alexandria.network.RequestUpdatePacket;
import com.shiftthedev.alexandria.registry.CommonRegistry;
import com.shiftthedev.pickablepets.PPRegistry;
import com.shiftthedev.pickablepets.data.ItemTagFixer;
import com.shiftthedev.pickablepets.data.PetDataComponent;
import com.shiftthedev.pickablepets.data.PetInfo;
import com.shiftthedev.pickablepets.data.PlayerPets;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.class_6025;
import net.minecraft.class_9279;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class CachedPets
extends CachedEntities<class_1309, PetInfo> {
    public CachedPets() {
        super(PetInfo::new);
    }

    public String getKey() {
        return "pets";
    }

    protected class_1799 fixIfNeeded(class_1799 stack, class_1937 level) {
        if (stack.method_57826((class_9331)PPRegistry.PET_DATA_COMPONENT.get())) {
            PetDataComponent oldData = (PetDataComponent)stack.method_57824((class_9331)PPRegistry.PET_DATA_COMPONENT.get());
            stack.method_57379((class_9331)CommonRegistry.ENTITY_DATA_COMPONENT.get(), (Object)new EntityDataComponent(oldData.tag, oldData.version));
            stack.method_57381((class_9331)PPRegistry.PET_DATA_COMPONENT.get());
        }
        return stack;
    }

    public void uncache(UUID entityID, @Nullable class_1937 level) {
    }

    protected boolean extraChecks(class_1309 entity) {
        return entity instanceof class_6025;
    }

    public boolean isValidPet(UUID petID) {
        return this.cachedEntities.containsKey(petID);
    }

    public class_1309 getPet(UUID petID) {
        if (this.cachedEntities.containsKey(petID)) {
            return ((PetInfo)((Object)this.cachedEntities.get(petID))).getEntity();
        }
        return null;
    }

    public List<UUID> getPetsFrom(UUID ownerID) {
        ArrayList<UUID> pets = new ArrayList<UUID>();
        this.cachedEntities.forEach((uuid, petInfo) -> {
            if (ownerID.equals(((class_6025)petInfo.getEntity()).method_6139())) {
                pets.add((UUID)uuid);
            }
        });
        return pets;
    }

    @Environment(value=EnvType.CLIENT)
    public class_1309 getRender(UUID entityID) {
        if (this.cachedEntities.containsKey(entityID)) {
            return ((PetInfo)((Object)this.cachedEntities.get(entityID))).getEntity();
        }
        RequestUpdatePacket.sendToServer((UUID)entityID, (String)"pets");
        return null;
    }

    public void updateOldStack(class_1799 itemStack, class_1937 level) {
        Optional entityType;
        if (level == null) {
            if (overworldLevel == null) {
                return;
            }
            level = overworldLevel;
        }
        if (level.field_9236) {
            return;
        }
        class_9279 customData = (class_9279)itemStack.method_57824(class_9334.field_49628);
        if (customData == null) {
            return;
        }
        class_2487 customTag = customData.method_57461();
        if (!customTag.method_10573("pet_info", 10)) {
            return;
        }
        class_2487 oldTag = customTag.method_10562("pet_info");
        customTag.method_10551("pet_info");
        if (customTag.method_33133()) {
            itemStack.method_57381(class_9334.field_49628);
        } else {
            itemStack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)customTag));
        }
        if (oldTag.method_10545("pp_type")) {
            oldTag.method_10582("entity_type", oldTag.method_10558("pp_type"));
            oldTag.method_10551("pp_type");
        }
        if ((entityType = class_1299.method_5898((String)(oldTag = ItemTagFixer.fixItemTag(oldTag)).method_10558("pet_type"))).isEmpty()) {
            return;
        }
        class_1309 entity = (class_1309)((class_1299)entityType.get()).method_5883(overworldLevel);
        if (entity == null) {
            return;
        }
        if (!(entity instanceof class_6025)) {
            return;
        }
        entity.method_5651(oldTag);
        if (this.cachedEntities.containsKey(entity.method_5667()) && oldTag.method_10550("VERSION") == 1) {
            ((PetInfo)((Object)this.cachedEntities.get(entity.method_5667()))).updateAttributes(entity);
        }
        class_2487 newTag = new class_2487();
        entity.method_5662(newTag);
        EntityDataComponent dataComponent = EntityDataComponent.fromTag((class_2487)newTag);
        itemStack.method_57379((class_9331)CommonRegistry.ENTITY_DATA_COMPONENT.get(), (Object)dataComponent);
        if (newTag.method_10545("custom_name")) {
            itemStack.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)newTag.method_10558("custom_name")));
        } else if (itemStack.method_57826(class_9334.field_49631)) {
            itemStack.method_57381(class_9334.field_49631);
        }
        this.cache(entity);
        ((PetInfo)((Object)this.cachedEntities.get(entity.method_5667()))).setInItem(true);
    }

    public String getOwner(UUID uuid) {
        if (this.cachedEntities.containsKey(uuid)) {
            return ((PetInfo)((Object)this.cachedEntities.get(uuid))).getOwner();
        }
        return "";
    }

    public class_2499 getPetAttributes(UUID petUUID) {
        if (this.cachedEntities.containsKey(petUUID)) {
            return ((PetInfo)((Object)this.cachedEntities.get(petUUID))).getAttributes();
        }
        return new class_2499();
    }

    public void setPetItem(UUID uuid, boolean flag) {
        if (!this.cachedEntities.containsKey(uuid)) {
            return;
        }
        ((PetInfo)((Object)this.cachedEntities.get(uuid))).setInItem(flag);
    }

    public boolean isInItem(UUID uuid) {
        if (!this.cachedEntities.containsKey(uuid)) {
            return false;
        }
        return ((PetInfo)((Object)this.cachedEntities.get(uuid))).isInItem();
    }

    public void killPet(UUID uuid) {
        if (!this.cachedEntities.containsKey(uuid)) {
            return;
        }
        ((PetInfo)((Object)this.cachedEntities.get(uuid))).markDead();
    }

    public void revivePet(UUID uuid) {
        if (!this.cachedEntities.containsKey(uuid)) {
            return;
        }
        ((PetInfo)((Object)this.cachedEntities.get(uuid))).revive();
    }

    public void replaceWolf(class_3222 player, UUID oldID, class_1321 dog) {
        if (dog.method_5667().equals(oldID) && this.cachedEntities.containsKey(dog.method_5667())) {
            ((PetInfo)((Object)this.cachedEntities.get(dog.method_5667()))).updateEntity((class_1309)dog);
            return;
        }
        this.cachedEntities.remove(oldID);
        class_1937 level = dog.method_37908();
        if (level == null) {
            if (overworldLevel == null) {
                return;
            }
            level = overworldLevel;
        }
        if (dog.method_6139() == null) {
            return;
        }
        this.cachedEntities.put(dog.method_5667(), new PetInfo((class_1309)dog));
        Path path = level.method_8503().method_27050(new class_5218("data/pets"));
        path = path.resolve(dog.method_6139().toString() + ".pets");
        PlayerPets.replacePetAsync(path, oldID.toString(), dog.method_5667().toString());
        this.sendRemoveEntity(level, oldID);
        this.sendCachedEntity(player, dog.method_5667());
    }

    public boolean isPetAlive(UUID uuid) {
        if (!this.cachedEntities.containsKey(uuid)) {
            return false;
        }
        return ((PetInfo)((Object)this.cachedEntities.get(uuid))).isAlive();
    }

    public void setUpdated(UUID uuid) {
        if (!this.cachedEntities.containsKey(uuid)) {
            return;
        }
        ((PetInfo)((Object)this.cachedEntities.get(uuid))).setUpdated();
    }

    public boolean isPetUpdated(UUID uuid) {
        if (!this.cachedEntities.containsKey(uuid)) {
            return false;
        }
        return ((PetInfo)((Object)this.cachedEntities.get(uuid))).isUpdated();
    }

    public boolean wasPetRevived(UUID uuid) {
        if (!this.cachedEntities.containsKey(uuid)) {
            return false;
        }
        return ((PetInfo)((Object)this.cachedEntities.get(uuid))).wasRevived();
    }

    @Environment(value=EnvType.CLIENT)
    public void receiveRemoveEntity(UUID entityID) {
    }

    public void save(Path path) {
        class_2499 listTag = new class_2499();
        TreeMap<UUID, PetInfo> tempMap = new TreeMap<UUID, PetInfo>();
        for (Map.Entry petEntry : this.cachedEntities.entrySet()) {
            class_2487 entryTag = new class_2487();
            entryTag.method_25927("Key", (UUID)petEntry.getKey());
            entryTag.method_10566("Value", (class_2520)((PetInfo)((Object)petEntry.getValue())).save(new class_2487()));
            listTag.add((Object)entryTag);
            tempMap.put((UUID)petEntry.getKey(), (PetInfo)((Object)petEntry.getValue()));
        }
        this.cachedEntities.clear();
        this.cachedEntities = new TreeMap();
        this.cachedEntities.putAll(tempMap);
        class_2487 tagToSave = new class_2487();
        tagToSave.method_10566("pets", (class_2520)listTag);
        tagToSave.method_10569("version", Alexandria.VERSION);
        if (!path.toFile().exists()) {
            path.toFile().mkdirs();
        }
        Path file = path.resolve("pets.shift");
        try {
            class_2507.method_30614((class_2487)tagToSave, (Path)file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void load(Path path, MinecraftServer server) {
        class_2487 tag;
        this.cachedEntities = new TreeMap();
        boolean old = false;
        Path file = path.resolve("pets.shift");
        Path oldFile = path.resolve("pets.dat");
        if (!file.toFile().exists()) {
            if (!oldFile.toFile().exists()) {
                return;
            }
            file = oldFile;
            old = true;
        }
        try {
            tag = class_2507.method_30613((Path)file, (class_2505)class_2505.method_53898());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (tag == null) {
            return;
        }
        if (!tag.method_10545("pets")) {
            return;
        }
        this.cachedEntities.clear();
        class_2499 listTag = tag.method_10554("pets", 10);
        for (class_2520 entry : listTag) {
            if (!(entry instanceof class_2487)) continue;
            class_2487 entryTag = (class_2487)entry;
            class_2487 value = entryTag.method_10562("Value");
            UUID petId = entryTag.method_25926("Key");
            PetInfo petEntry = (PetInfo)this.createEntityInfo(null);
            petEntry.load(petId, value, overworldLevel);
            this.cachedEntities.put(petId, petEntry);
        }
        if (old) {
            oldFile.toFile().delete();
            this.save(path);
        }
    }
}

