/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.pickablepets.data;

import com.shiftthedev.alexandria.data.EntityInfo;
import com.shiftthedev.pickablepets.data.ItemTagFixer;
import java.util.UUID;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_5131;
import net.minecraft.class_6025;

public class PetInfo
extends EntityInfo<class_1309> {
    private boolean inItem;
    private boolean isAlive;
    private boolean wasRevived;
    private String ownerName;
    private class_5131 attributeMap;
    private boolean updated;

    public PetInfo(class_1309 entity) {
        super(entity);
        if (entity != null) {
            this.inItem = false;
            this.isAlive = true;
            this.wasRevived = false;
            this.trySetOwner();
            this.attributeMap = entity.method_6127();
        }
    }

    public void setInItem(boolean flag) {
        this.inItem = flag;
    }

    public boolean isInItem() {
        return this.inItem;
    }

    public class_2499 getAttributes() {
        if (this.attributeMap != null) {
            return this.attributeMap.method_26855();
        }
        return new class_2499();
    }

    public String getOwner() {
        if (this.ownerName == null || this.ownerName.isEmpty()) {
            this.trySetOwner();
        }
        return this.ownerName;
    }

    private void trySetOwner() {
        class_2561 name;
        if (this.entity == null) {
            this.ownerName = "";
            return;
        }
        class_1309 ownerEntity = ((class_6025)this.entity).method_35057();
        this.ownerName = ownerEntity != null ? ((name = ownerEntity.method_5476()) != null ? name.getString() : "") : "";
    }

    public void updateAttributes(class_1309 entity) {
        this.attributeMap = entity.method_6127();
    }

    public void markDead() {
        this.isAlive = false;
    }

    public void revive() {
        this.entity.field_6017 = 0.0f;
        this.entity.method_6125(0.0f);
        this.isAlive = true;
        this.wasRevived = true;
    }

    public boolean isAlive() {
        return this.isAlive;
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public void setUpdated() {
        this.updated = true;
    }

    public boolean wasRevived() {
        return this.wasRevived;
    }

    public class_2487 save(class_2487 tag) {
        super.save(tag);
        if (this.entity == null) {
            return tag;
        }
        tag.method_10556("pp_item", this.inItem);
        tag.method_10556("pp_alive", this.isAlive);
        tag.method_10556("pp_revived", this.wasRevived);
        tag.method_10582("pp_owner", this.ownerName);
        if (this.attributeMap != null) {
            tag.method_10566("pp_attr", (class_2520)this.attributeMap.method_26855());
        }
        tag.method_10556("pp_updated", this.updated);
        return tag;
    }

    public void load(UUID entityID, class_2487 tag, class_1937 level) {
        if (tag.method_10545("pp_type")) {
            tag.method_10582("entity_type", tag.method_10558("pp_type"));
            tag.method_10551("pp_type");
        }
        tag = ItemTagFixer.fixItemTag(tag);
        super.load(entityID, tag, level);
        this.inItem = tag.method_10545("pp_item") && tag.method_10577("pp_item");
        this.isAlive = tag.method_10545("pp_alive") && tag.method_10577("pp_alive");
        this.wasRevived = tag.method_10545("pp_revived") && tag.method_10577("pp_revived");
        String string = this.ownerName = tag.method_10545("pp_owner") ? tag.method_10558("pp_owner") : "";
        if (tag.method_10545("pp_attr")) {
            this.attributeMap = this.entity.method_6127();
            this.attributeMap.method_26850(tag.method_10554("pp_attr", 10));
        }
        if (tag.method_10545("pp_updated")) {
            this.updated = tag.method_10577("pp_updated");
        }
        level.method_16107().method_15407();
    }
}

