/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.pickablepets.network;

import com.shiftthedev.pickablepets.PickablePets;
import com.shiftthedev.pickablepets.data.PlayerPets;
import com.shiftthedev.pickablepets.network.AltarUpdatePacket;
import dev.architectury.networking.NetworkManager;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.class_8710;
import net.minecraft.class_9139;

public class AltarRequestPacket {
    private static final class_2960 PACKET_ID = class_2960.method_60655((String)"pickablepets", (String)"altar_request");
    private static final class_8710.class_9154<AltarRequestPayload> TYPE = new class_8710.class_9154(PACKET_ID);
    private static final class_9139<class_2540, AltarRequestPayload> CODEC = class_9139.method_56438(AltarRequestPayload::write, AltarRequestPayload::read);

    public static void register() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), TYPE, CODEC, AltarRequestPacket::receive);
    }

    public static void receive(AltarRequestPayload payload, NetworkManager.PacketContext context) {
        if (context.getPlayer().method_7340()) {
            return;
        }
        UUID playerID = payload.uuid();
        Path path = context.getPlayer().method_5682().method_27050(new class_5218("data/pets"));
        path = path.resolve(playerID.toString() + ".pets");
        ArrayList<String> broken = new ArrayList<String>();
        PlayerPets.loadPetAsync(path).thenCompose(list -> {
            ArrayList<String> fixed = new ArrayList<String>();
            list.forEach(uuid -> {
                if (PickablePets.CACHE.isValidPet(UUID.fromString(uuid))) {
                    fixed.add((String)uuid);
                } else {
                    broken.add((String)uuid);
                }
            });
            AltarUpdatePacket.sendToPlayer((class_3222)context.getPlayer(), fixed);
            return null;
        });
        PlayerPets.removeBrokenPetsAsync(path, broken);
    }

    private record AltarRequestPayload(UUID uuid) implements class_8710
    {
        public void write(class_2540 buf) {
            buf.method_10797(this.uuid);
        }

        public static AltarRequestPayload read(class_2540 buf) {
            return new AltarRequestPayload(buf.method_10790());
        }

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return TYPE;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class Client {
        public static void sendToServer() {
            NetworkManager.sendToServer((class_8710)new AltarRequestPayload(class_310.method_1551().field_1724.method_5667()));
        }
    }
}

