/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.pickablepets.network;

import com.shiftthedev.alexandria.mixins.EntityAccessor;
import com.shiftthedev.alexandria.network.ClientUpdatePacket;
import com.shiftthedev.pickablepets.PickablePets;
import com.shiftthedev.pickablepets.blocks.ReviveAltarBlockEntity;
import com.shiftthedev.pickablepets.compat.DoggyHelper;
import com.shiftthedev.pickablepets.data.PetInfo;
import com.shiftthedev.pickablepets.network.ChatPacket;
import dev.architectury.networking.NetworkManager;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9139;

public class RevivePacket {
    private static final class_2960 PACKET_ID = class_2960.method_60655((String)"pickablepets", (String)"revive");
    private static final class_8710.class_9154<RevivePayload> TYPE = new class_8710.class_9154(PACKET_ID);
    private static final class_9139<class_2540, RevivePayload> CODEC = class_9139.method_56438(RevivePayload::write, RevivePayload::read);

    public static void register() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), TYPE, CODEC, RevivePacket::receive);
    }

    public static void receive(RevivePayload payload, NetworkManager.PacketContext context) {
        if (context.getPlayer().method_7340()) {
            return;
        }
        UUID petID = payload.petId;
        class_2338 revivePos = payload.revivePos;
        class_1937 level = context.getPlayer().method_37908();
        class_1309 cachedPet = PickablePets.CACHE.getPet(petID);
        if (cachedPet == null || PickablePets.CACHE.isPetAlive(petID)) {
            return;
        }
        class_2338 spanwPos = null;
        for (int xOffset = -2; xOffset <= 2; ++xOffset) {
            for (int zOffeset = -2; zOffeset <= 2; ++zOffeset) {
                if (!level.method_18026(cachedPet.method_5864().method_58629((double)(revivePos.method_10263() + xOffset), (double)revivePos.method_10264(), (double)(revivePos.method_10260() + zOffeset)))) continue;
                spanwPos = new class_2338(revivePos.method_10263() + xOffset, revivePos.method_10264(), revivePos.method_10260() + zOffeset);
                break;
            }
            if (spanwPos != null) break;
        }
        if (spanwPos == null) {
            ChatPacket.sendToPlayer((class_3222)context.getPlayer(), "spawn");
            return;
        }
        class_2338 finalSpanwPos = spanwPos;
        level.method_8503().execute(() -> {
            class_2586 be;
            if (PickablePets.FoundDoggy && DoggyHelper.isFromMod(cachedPet)) {
                class_1309 pet = DoggyHelper.reviveDog(cachedPet, petID, context.getPlayer(), (class_3218)level, finalSpanwPos);
                if (pet == null) {
                    return;
                }
            } else {
                class_1309 pet = (class_1309)cachedPet.method_5864().method_5883(level);
                if (pet == null) {
                    return;
                }
                ((EntityAccessor)cachedPet).setRemovalReason(null);
                ((EntityAccessor)cachedPet).invokeSetLevel(level);
                class_2487 tag = cachedPet.method_5647(new class_2487());
                tag.method_10556("Sitting", false);
                tag.method_10575("DeathTime", (short)0);
                cachedPet.method_5651(tag);
                pet.method_5878((class_1297)cachedPet);
                pet.method_6127().method_26850(PickablePets.CACHE.getPetAttributes(cachedPet.method_5667()));
                pet.method_33574(class_243.method_24953((class_2382)finalSpanwPos));
                pet.method_6033(cachedPet.method_6063());
                if (!level.method_8649((class_1297)pet)) {
                    return;
                }
                PickablePets.CACHE.revivePet(petID);
                PickablePets.CACHE.cache(pet);
            }
            if ((be = level.method_8500(revivePos).method_12201(revivePos, class_2818.class_2819.field_12860)) instanceof ReviveAltarBlockEntity) {
                ReviveAltarBlockEntity rbe = (ReviveAltarBlockEntity)be;
                class_1799 stack = rbe.method_5438(0).method_7972();
                stack.method_7934(1);
                rbe.method_5447(0, stack);
            }
            level.method_18456().forEach(p -> ClientUpdatePacket.sendToPlayer((UUID)petID, (class_2487)((PetInfo)PickablePets.CACHE.getEntityInfo(petID)).save(new class_2487()), (String)"pets", (class_3222)((class_3222)p)));
            level.method_16107().method_15407();
        });
    }

    private record RevivePayload(UUID petId, class_2338 revivePos) implements class_8710
    {
        public void write(class_2540 buf) {
            buf.method_10797(this.petId);
            buf.method_10807(this.revivePos);
        }

        public static RevivePayload read(class_2540 buf) {
            return new RevivePayload(buf.method_10790(), buf.method_10811());
        }

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return TYPE;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class Client {
        public static void sendToServer(UUID petID, class_2338 revivePos) {
            NetworkManager.sendToServer((class_8710)new RevivePayload(petID, revivePos));
        }
    }
}

