/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.wariumextras.procedures;

import net.mcreator.crustychunks.init.CrustyChunksModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.RegistryObject;

public class FuelStorageProcedure {
    private static final int MAX_FUEL = 10;

    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity, ItemStack itemstack) {
        if (entity == null) {
            return;
        }
        BlockPos pos = BlockPos.m_274561_((double)x, (double)y, (double)z);
        for (FuelType fuelType : FuelType.values()) {
            if (itemstack.m_41720_() != fuelType.bucketItem || !FuelStorageProcedure.canAddFuel(world, pos, fuelType)) continue;
            FuelStorageProcedure.addFuel(world, pos, fuelType);
            FuelStorageProcedure.removeItemFromPlayer(entity, itemstack);
            FuelStorageProcedure.giveItemToPlayer(entity, new ItemStack((ItemLike)Items.f_42446_));
            FuelStorageProcedure.displayFuelLevels(world, pos, (Player)entity);
            return;
        }
        if (itemstack.m_41720_() == Items.f_42446_) {
            for (FuelType fuelType : FuelType.values()) {
                if (!FuelStorageProcedure.canExtractFuel(world, pos, fuelType)) continue;
                FuelStorageProcedure.removeFuel(world, pos, fuelType);
                FuelStorageProcedure.removeItemFromPlayer(entity, itemstack);
                FuelStorageProcedure.giveItemToPlayer(entity, new ItemStack((ItemLike)fuelType.bucketItem));
                FuelStorageProcedure.displayFuelLevels(world, pos, (Player)entity);
                return;
            }
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            FuelStorageProcedure.displayFuelLevels(world, pos, player);
        }
    }

    private static double getFuelLevel(LevelAccessor world, BlockPos pos, String tag) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity != null) {
            return blockEntity.getPersistentData().m_128459_(tag);
        }
        return -1.0;
    }

    private static void setFuelLevel(LevelAccessor world, BlockPos pos, String tag, double value) {
        if (!world.m_5776_()) {
            BlockEntity blockEntity = world.m_7702_(pos);
            BlockState blockState = world.m_8055_(pos);
            if (blockEntity != null) {
                blockEntity.getPersistentData().m_128347_(tag, value);
                if (world instanceof Level) {
                    Level level = (Level)world;
                    level.m_7260_(pos, blockState, blockState, 3);
                }
            }
        }
    }

    private static boolean canAddFuel(LevelAccessor world, BlockPos pos, FuelType addType) {
        for (FuelType fuelType : FuelType.values()) {
            double level = FuelStorageProcedure.getFuelLevel(world, pos, fuelType.nbtTag);
            if (!(fuelType == addType ? level >= 10.0 : level != 0.0)) continue;
            return false;
        }
        return true;
    }

    private static boolean canExtractFuel(LevelAccessor world, BlockPos pos, FuelType extractType) {
        for (FuelType fuelType : FuelType.values()) {
            double level = FuelStorageProcedure.getFuelLevel(world, pos, fuelType.nbtTag);
            if (!(fuelType == extractType ? level <= 0.0 : level != 0.0)) continue;
            return false;
        }
        return true;
    }

    private static void addFuel(LevelAccessor world, BlockPos pos, FuelType fuelType) {
        double currentLevel = FuelStorageProcedure.getFuelLevel(world, pos, fuelType.nbtTag);
        FuelStorageProcedure.setFuelLevel(world, pos, fuelType.nbtTag, currentLevel + 1.0);
    }

    private static void removeFuel(LevelAccessor world, BlockPos pos, FuelType fuelType) {
        double currentLevel = FuelStorageProcedure.getFuelLevel(world, pos, fuelType.nbtTag);
        FuelStorageProcedure.setFuelLevel(world, pos, fuelType.nbtTag, currentLevel - 1.0);
    }

    private static void removeItemFromPlayer(Entity entity, ItemStack itemstack) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.m_150109_().m_36022_(p -> itemstack.m_41720_() == p.m_41720_(), 1, (Container)player.f_36095_.m_39730_());
        }
    }

    private static void giveItemToPlayer(Entity entity, ItemStack itemstack) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ItemStack stack = itemstack.m_41777_();
            stack.m_41764_(1);
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack);
        }
    }

    private static void displayFuelLevels(LevelAccessor world, BlockPos pos, Player player) {
        if (world.m_5776_()) {
            return;
        }
        double diesel = FuelStorageProcedure.getFuelLevel(world, pos, "diesel");
        double kerosene = FuelStorageProcedure.getFuelLevel(world, pos, "kerosene");
        double petrol = FuelStorageProcedure.getFuelLevel(world, pos, "petrol");
        double oil = FuelStorageProcedure.getFuelLevel(world, pos, "oil");
        double crude = FuelStorageProcedure.getFuelLevel(world, pos, "crude");
        String message = "Fuel Storage: Empty";
        if (diesel > 0.0) {
            message = String.format("Diesel: %.0f/10", diesel);
        } else if (kerosene > 0.0) {
            message = String.format("Kerosene: %.0f/10", kerosene);
        } else if (petrol > 0.0) {
            message = String.format("Petrol: %.0f/10", petrol);
        } else if (oil > 0.0) {
            message = String.format("Oil: %.0f/10", oil);
        } else if (crude > 0.0) {
            message = String.format("Crude Oil: %.0f/10", crude);
        }
        player.m_5661_((Component)Component.m_237113_((String)message), true);
    }

    private static enum FuelType {
        DIESEL((RegistryObject<Item>)CrustyChunksModItems.DIESEL_BUCKET, "diesel"),
        KEROSENE((RegistryObject<Item>)CrustyChunksModItems.KEROSENE_BUCKET, "kerosene"),
        PETROL((RegistryObject<Item>)CrustyChunksModItems.PETROLIUM_BUCKET, "petrol"),
        OIL((RegistryObject<Item>)CrustyChunksModItems.OIL_BUCKET, "oil"),
        CRUDE((RegistryObject<Item>)CrustyChunksModItems.CRUDE_OIL_BUCKET, "crude");

        final Item bucketItem;
        final String nbtTag;

        private FuelType(RegistryObject<Item> bucket, String tag) {
            this.bucketItem = (Item)bucket.get();
            this.nbtTag = tag;
        }
    }
}

