#version 150

#moj_import <fog.glsl>

uniform sampler2D Sampler0;

uniform vec4 ColorModulator;
uniform float FogStart;
uniform float FogEnd;
uniform vec4 FogColor;

in float vertexDistance;
in vec4 vertexColor;
in vec4 lightMapColor;
in vec4 overlayColor;
in vec2 texCoord0;

out vec4 fragColor;

#moj_import <minecraft:utils.glsl>

void main() {
    vec4 color = texture(Sampler0, texCoord0) * vertexColor * ColorModulator;
	
	editColors(); // Add this to whatever after color is declared
	color = preColor * vertexColor * ColorModulator;
	
    color.rgb = mix(overlayColor.rgb, color.rgb, overlayColor.a);
    if (!shouldBeEmissive()) {
		color *= lightMapColor;
	}
    fragColor = linear_fog(color, vertexDistance, FogStart, FogEnd, FogColor);
}
