#version 150

vec2 texSize = textureSize(Sampler0,0);
vec4 preColor = texture(Sampler0, texCoord0);

uniform float GameTime;

// Helper Methods

vec3 color(int r, int g, int b) {
	return vec3(r,g,b)/255.;
}

vec4 color(int r, int g, int b, int a) {
	return vec4(r,g,b,a)/255.;
}

vec4 coordColor(int x, int y) {
	return texture(Sampler0, vec2(x/texSize.x, y/texSize.y));
}

bool coordIs(int x, int y) {
	return (texCoord0.x > (x)/texSize.x && texCoord0.y > (y)/texSize.y) && (texCoord0.x < (x+1)/texSize.x && texCoord0.y < (y+1)/texSize.y);
}

bool colorIs(int r, int g, int b) {
	return preColor.rgb == color(r,g,b);
}

bool coordColorIs(int x, int y, int r, int g, int b) {
	return coordColor(x,y).rgb == color(r,g,b);
}

bool coordColorIs(int x, int y, vec3 color) {
	return coordColor(x,y).rgb == color;
}

bool betweenCoords(int x1, int y1, int x2, int y2) {
	if (x1>x2) {
		int temp = x1;
		x1 = x2;
		x2 = temp;
	}
	if (y1>y2){
		int temp = y1;
		y1 = y2;
		y2 = temp;
	}

	return texCoord0.x > x1/texSize.x && texCoord0.x < x2/texSize.x && texCoord0.y > y1/texSize.y && texCoord0.y < y2/texSize.y;
}

bool isCape() {
	/*
	// Using code for detecting capes from https://github.com/McTsts/mc-core-shaders
	return ( && texture(Sampler0, vec2(0.0, 1.0/32.0)).a == 1.0 && texture(Sampler0, vec2(12.0/64.0, 16.0/32.0)).a == 1.0 && // check if skin transparent pixels have color
			(	// support both types of cape texture
				(texture(Sampler0, vec2(0.0, 18.0/32.0)) == vec4(1.0) && texture(Sampler0, vec2(0.99, 0.99)) == vec4(1.0) && texture(Sampler0, vec2(0.99, 0.0)) == vec4(1.0)) // for capes filled with white, check for white pixels
				|| (texture(Sampler0, vec2(25.0/64.0, 25.0/32.0)).a == 0.0 || texture(Sampler0, vec2(30.0/64.0, 10.0/32.0)).a == 0.0 || texture(Sampler0, vec2(9.0/64.0, 25.0/32.0)).a == 0.0)  // otherwise check of transparent pixels
			));
			
	*/
	
	return (texSize.x == 64 && texSize.y == 32 && coordColor(0,0).a == 0.0);
}

bool isTwitchCape() {
	return isCape() && coordColorIs(0,1,112,45,224) && (
	(betweenCoords(38, 14, 45, 5) && !coordIs(39, 13) && (colorIs(145, 70, 255) || colorIs(93, 22, 197) || colorIs(126, 59, 240) || colorIs(113, 46, 224))) ||
	(betweenCoords(2,5,10,12) && !coordIs(2, 5) && !coordIs(5, 5) && !coordIs(6, 5) && !coordIs(9, 5) && !coordIs(2, 9) && !coordIs(2, 10) && !coordIs(2, 11) && !coordIs(3, 10) && !coordIs(3, 11) && !coordIs(4, 11) && !coordIs(7, 11) && !coordIs(8, 10) && !coordIs(8, 11) && !coordIs(9, 9) && !coordIs(9, 10) && !coordIs(9, 11))
	);
}

// Main
bool shouldBeEmissive() {
	return isTwitchCape();
}

void editColors() {

}