/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.update.fluid;

import net.mcreator.update.init.UpdateModBlocks;
import net.mcreator.update.init.UpdateModFluidTypes;
import net.mcreator.update.init.UpdateModFluids;
import net.mcreator.update.init.UpdateModItems;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;

public abstract class RustWaterFluid
extends BaseFlowingFluid {
    public static final BaseFlowingFluid.Properties PROPERTIES = new BaseFlowingFluid.Properties(() -> (FluidType)UpdateModFluidTypes.RUST_WATER_TYPE.get(), () -> (Fluid)UpdateModFluids.RUST_WATER.get(), () -> (Fluid)UpdateModFluids.FLOWING_RUST_WATER.get()).explosionResistance(100.0f).bucket(() -> (Item)UpdateModItems.RUST_WATER_BUCKET.get()).block(() -> (LiquidBlock)UpdateModBlocks.RUST_WATER.get());

    private RustWaterFluid() {
        super(PROPERTIES);
    }

    public static class Flowing
    extends RustWaterFluid {
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState state) {
            return false;
        }
    }

    public static class Source
    extends RustWaterFluid {
        public int getAmount(FluidState state) {
            return 8;
        }

        public boolean isSource(FluidState state) {
            return true;
        }
    }
}

