/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.update.init;

import net.mcreator.update.entity.ChaossEntity;
import net.mcreator.update.entity.PoisonedEntity;
import net.mcreator.update.entity.RustBlobEntity;
import net.mcreator.update.entity.RustOnlyEntity;
import net.mcreator.update.entity.RusterEntity;
import net.mcreator.update.entity.TheToxicOneEntity;
import net.mcreator.update.entity.ToxicChickenEntity;
import net.mcreator.update.entity.TrustEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber
public class UpdateModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"update");
    public static final DeferredHolder<EntityType<?>, EntityType<RustOnlyEntity>> RUST_ONLY = UpdateModEntities.register("rust_only", EntityType.Builder.of(RustOnlyEntity::new, (MobCategory)MobCategory.AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(1.0f, 1.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<PoisonedEntity>> POISONED = UpdateModEntities.register("poisoned", EntityType.Builder.of(PoisonedEntity::new, (MobCategory)MobCategory.AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.4f, 0.3f));
    public static final DeferredHolder<EntityType<?>, EntityType<RusterEntity>> RUSTER = UpdateModEntities.register("ruster", EntityType.Builder.of(RusterEntity::new, (MobCategory)MobCategory.AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(1.4f, 0.9f));
    public static final DeferredHolder<EntityType<?>, EntityType<ToxicChickenEntity>> TOXIC_CHICKEN = UpdateModEntities.register("toxic_chicken", EntityType.Builder.of(ToxicChickenEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.4f, 0.7f));
    public static final DeferredHolder<EntityType<?>, EntityType<TheToxicOneEntity>> THE_TOXIC_ONE = UpdateModEntities.register("the_toxic_one", EntityType.Builder.of(TheToxicOneEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().ridingOffset(-0.6f).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<TrustEntity>> TRUST = UpdateModEntities.register("trust", EntityType.Builder.of(TrustEntity::new, (MobCategory)MobCategory.AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<ChaossEntity>> CHAOSS = UpdateModEntities.register("chaoss", EntityType.Builder.of(ChaossEntity::new, (MobCategory)MobCategory.AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<RustBlobEntity>> RUST_BLOB = UpdateModEntities.register("rust_blob", EntityType.Builder.of(RustBlobEntity::new, (MobCategory)MobCategory.AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.6f, 1.8f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"update", (String)registryname))));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        RustOnlyEntity.init(event);
        PoisonedEntity.init(event);
        RusterEntity.init(event);
        ToxicChickenEntity.init(event);
        TheToxicOneEntity.init(event);
        TrustEntity.init(event);
        ChaossEntity.init(event);
        RustBlobEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)RUST_ONLY.get(), RustOnlyEntity.createAttributes().build());
        event.put((EntityType)POISONED.get(), PoisonedEntity.createAttributes().build());
        event.put((EntityType)RUSTER.get(), RusterEntity.createAttributes().build());
        event.put((EntityType)TOXIC_CHICKEN.get(), ToxicChickenEntity.createAttributes().build());
        event.put((EntityType)THE_TOXIC_ONE.get(), TheToxicOneEntity.createAttributes().build());
        event.put((EntityType)TRUST.get(), TrustEntity.createAttributes().build());
        event.put((EntityType)CHAOSS.get(), ChaossEntity.createAttributes().build());
        event.put((EntityType)RUST_BLOB.get(), RustBlobEntity.createAttributes().build());
    }
}

