/*
 * Decompiled with CFR 0.152.
 */
package com.mialliance.block;

import com.mialliance.MiCon;
import com.mialliance.block.ModBlocks;
import com.mialliance.block.ModTileEntities;
import com.mialliance.entities.EntityLegacian;
import com.mialliance.entities.EntityMi;
import com.mialliance.entities.EntityRelicoid;
import com.mialliance.entities.ModEntities;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;

public class TileEntityLastAltar
extends BlockEntity {
    public int Tech = 0;
    private boolean spawnChurch = true;

    public TileEntityLastAltar(BlockPos p_155397_, BlockState p_155398_) {
        super((BlockEntityType)ModTileEntities.LAST_ALTAR.get(), p_155397_, p_155398_);
    }

    public void m_142466_(CompoundTag nb) {
        this.Tech = nb.m_128451_("Tech");
        this.spawnChurch = nb.m_128471_("spawnChurch");
        super.m_142466_(nb);
    }

    protected void m_183515_(CompoundTag nb) {
        super.m_183515_(nb);
        nb.m_128405_("Tech", this.Tech);
        nb.m_128379_("spawnChurch", this.spawnChurch);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public static void serverTick(Level lev, BlockPos pos, BlockState p_155406_, TileEntityLastAltar dis) {
        if (dis.spawnChurch) {
            dis.spawnChurch = false;
            dis.Spawn();
        }
    }

    public void Spawn() {
        int XSize = 7;
        int ZSize = 11;
        Level lev = this.m_58904_();
        BlockPos here = this.m_58899_();
        RandomSource rr = lev.m_213780_();
        for (int dx = -XSize; dx <= XSize; ++dx) {
            for (int dz = -ZSize; dz <= ZSize; ++dz) {
                if (dx == 0 && dz == 0) continue;
                int Max = 0;
                Max = Math.abs(dx) == XSize || Math.abs(dz) == ZSize ? rr.m_188503_(9) : 0;
                for (int dy = -3; dy <= 7; ++dy) {
                    BlockPos min = here.m_7918_(dx, dy, dz);
                    lev.m_7731_(min, Blocks.f_50016_.m_49966_(), 3);
                    if (dy > Max) continue;
                    if (Math.abs(dx) == XSize || Math.abs(dz) == ZSize) {
                        this.wallBlock(min);
                        continue;
                    }
                    if (dy == 0) {
                        this.scatterBlock(min);
                        continue;
                    }
                    this.floorBlock(min);
                }
            }
        }
    }

    private void wallBlock(BlockPos min) {
        Level lev = this.m_58904_();
        RandomSource rr = lev.m_213780_();
        BlockState stat = ((Block)ModBlocks.FORGOTTEN_BRICKS.get()).m_49966_();
        if (rr.m_188503_(2) == 0) {
            stat = ((Block)ModBlocks.FORGOTTEN_PILLAR.get()).m_49966_();
        } else if (rr.m_188503_(2) == 0) {
            stat = ((Block)ModBlocks.FORGOTTEN_BRICKS_CRACKED.get()).m_49966_();
        }
        lev.m_7731_(min, stat, 3);
    }

    private void floorBlock(BlockPos min) {
        Level lev = this.m_58904_();
        RandomSource rr = lev.m_213780_();
        BlockState stat = ((Block)ModBlocks.FORGOTTEN_BRICKS.get()).m_49966_();
        if (rr.m_188503_(2) == 0) {
            stat = ((Block)ModBlocks.FORGOTTEN_BRICKS_CRACKED.get()).m_49966_();
        } else if (rr.m_188503_(3) == 0) {
            stat = ((Block)ModBlocks.TUBIAN_WARDBRICK.get()).m_49966_();
        }
        lev.m_7731_(min, stat, 3);
    }

    private void scatterBlock(BlockPos min) {
        Level lev = this.m_58904_();
        RandomSource rr = lev.m_213780_();
        if (rr.m_188503_(5) == 0) {
            lev.m_7731_(min, ((Block)ModBlocks.FAMILIAR_LEAVES.get()).m_49966_(), 3);
            return;
        }
        if (rr.m_188503_(6) > 0) {
            return;
        }
        BlockState stat = Blocks.f_50081_.m_49966_();
        switch (rr.m_188503_(6)) {
            case 0: {
                stat = ((Block)ModBlocks.FORGOTTEN_SUPPLIES.get()).m_49966_();
                break;
            }
            case 1: {
                stat = ((Block)ModBlocks.FORGOTTEN_LANTERN.get()).m_49966_();
            }
        }
        lev.m_7731_(min, stat, 3);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void ActivatePhaseThree() {
        this.Tech = 1;
        if (!this.m_58904_().m_5776_()) {
            this.spawnExpeditionArmy();
        }
    }

    public int getTech() {
        return this.Tech;
    }

    public void spawnExpeditionArmy() {
        int i;
        RandomSource r = this.f_58857_.f_46441_;
        int ixo = r.m_188499_() ? 30 + r.m_188503_(10) : -30 - r.m_188503_(10);
        int izo = r.m_188499_() ? 30 + r.m_188503_(10) : -30 - r.m_188503_(10);
        BlockPos post = this.m_58899_().m_7918_(ixo, 0, izo);
        int pts = 1000;
        float diff = 0.8f;
        if (this.f_58857_.m_46791_() == Difficulty.NORMAL) {
            diff = 1.0f;
        } else if (this.f_58857_.m_46791_() == Difficulty.HARD) {
            diff = 1.2f;
        }
        for (Player pl : this.nearbyPlayers()) {
            pl.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 120, 3, false, false));
        }
        diff = this.nearbyPlayers().size() > 3 ? (float)((double)diff * 2.0) : (diff *= 0.7f + (float)this.nearbyPlayers().size() * 0.3f);
        pts = (int)Math.round((double)(diff * (float)pts) * (Double)MiCon.MI_SPAWNSIZE.get());
        int summon = 0;
        BlockPos h = this.f_58857_.m_5452_(Heightmap.Types.MOTION_BLOCKING, post);
        int numbos = 0;
        for (i = 0; i < 5; ++i) {
            this.spawnLegacian((EntityType)ModEntities.LEGACIAN.get());
        }
        if (this.nearbyRelicoid().size() < 2) {
            for (i = 0; i < 3; ++i) {
                this.spawnRelicoid((EntityType)ModEntities.RELICOID.get());
            }
        }
        while (pts > 15) {
            summon = r.m_188503_(38);
            if (++numbos < 3) {
                this.spawnMiExpedition((EntityType)ModEntities.MI.get(), "Leader", h);
                continue;
            }
            if (numbos < 5) {
                this.spawnMiExpedition((EntityType)ModEntities.GOOB.get(), "Spear", h);
                continue;
            }
            if (summon < 20) {
                if (summon > 14) {
                    this.spawnMiExpedition((EntityType)ModEntities.MI.get(), "SpearMiridium", h);
                } else if (summon > 8) {
                    this.spawnMiExpedition((EntityType)ModEntities.MI.get(), "Sword", h);
                } else {
                    this.spawnMiExpedition((EntityType)ModEntities.MI.get(), "Spear", h);
                }
                pts -= 15;
                continue;
            }
            if (summon < 27) {
                this.spawnMiExpedition((EntityType)ModEntities.MI.get(), "Bow", h);
                pts -= 15;
                continue;
            }
            if (summon < 30) {
                this.spawnMiExpedition((EntityType)ModEntities.MI.get(), "Rider", h);
                pts -= 18;
                continue;
            }
            if (summon < 32) {
                this.spawnMiExpedition((EntityType)ModEntities.TONK.get(), "", h);
                pts -= 50;
                continue;
            }
            if (summon < 35) {
                this.spawnMiExpedition((EntityType)ModEntities.GOOB.get(), "Spear", h);
                pts -= 35;
                continue;
            }
            this.spawnMiExpedition((EntityType)ModEntities.MI.get(), "RiderBow", h);
            pts -= 22;
        }
    }

    private boolean spawnLegacian(EntityType<?> newmi) {
        EntityLegacian mi = (EntityLegacian)newmi.m_20615_(this.f_58857_);
        RandomSource r = this.f_58857_.f_46441_;
        BlockPos spo = this.f_58857_.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, this.m_58899_().m_7918_(r.m_188503_(17) - 8, r.m_188503_(4), r.m_188503_(17) - 8));
        while (this.f_58857_.m_8055_(spo).m_60767_().m_76337_()) {
            spo = this.m_58899_().m_7918_(r.m_188503_(17) - 8, r.m_188503_(4), r.m_188503_(17) - 8);
        }
        mi.m_7678_((double)spo.m_123341_() + 0.5, spo.m_123342_(), (double)spo.m_123343_() + 0.5, 0.0f, 0.0f);
        this.f_58857_.m_7967_((Entity)mi);
        mi.m_6518_((ServerLevelAccessor)((ServerLevel)this.f_58857_), this.f_58857_.m_6436_(this.m_58899_()), MobSpawnType.STRUCTURE, null, null);
        mi.mission = 0;
        mi.fade = 12000;
        mi.m_21373_();
        return true;
    }

    private boolean spawnRelicoid(EntityType<?> newmi) {
        EntityRelicoid mi = (EntityRelicoid)newmi.m_20615_(this.f_58857_);
        RandomSource r = this.f_58857_.f_46441_;
        BlockPos spo = this.m_58899_().m_7918_(r.m_188503_(17) - 8, r.m_188503_(4), r.m_188503_(17) - 8);
        while (this.f_58857_.m_8055_(spo).m_60767_().m_76337_()) {
            spo = this.m_58899_().m_7918_(r.m_188503_(17) - 8, r.m_188503_(4), r.m_188503_(17) - 8);
        }
        mi.m_7678_((double)spo.m_123341_() + 0.5, spo.m_123342_(), (double)spo.m_123343_() + 0.5, 0.0f, 0.0f);
        mi.setGuardian(spo);
        this.f_58857_.m_7967_((Entity)mi);
        mi.m_6518_((ServerLevelAccessor)((ServerLevel)this.f_58857_), this.f_58857_.m_6436_(this.m_58899_()), MobSpawnType.STRUCTURE, null, null);
        mi.setGuardian(spo);
        mi.m_21373_();
        return true;
    }

    private List<Player> nearbyPlayers() {
        int k = this.m_58899_().m_123341_();
        int l = this.m_58899_().m_123342_();
        int i1 = this.m_58899_().m_123343_();
        AABB AABB2 = new AABB((double)k, (double)l, (double)i1, (double)(k + 1), (double)(l + 1), (double)(i1 + 1)).m_82377_(128.0, 64.0, 128.0);
        List list = this.f_58857_.m_45976_(Player.class, AABB2);
        return list;
    }

    private List<EntityRelicoid> nearbyRelicoid() {
        int k = this.m_58899_().m_123341_();
        int l = this.m_58899_().m_123342_();
        int i1 = this.m_58899_().m_123343_();
        AABB AABB2 = new AABB((double)k, (double)l, (double)i1, (double)(k + 1), (double)(l + 1), (double)(i1 + 1)).m_82377_(128.0, 64.0, 128.0);
        List list = this.f_58857_.m_45976_(EntityRelicoid.class, AABB2);
        return list;
    }

    private EntityMi spawnMiExpedition(EntityType<?> newmi, String wp, BlockPos pio) {
        EntityMi mi = (EntityMi)newmi.m_20615_(this.f_58857_);
        RandomSource r = this.f_58857_.f_46441_;
        BlockPos spo = pio.m_7918_(r.m_188503_(17) - 8, 0, r.m_188503_(17) - 8);
        while (this.f_58857_.m_8055_(spo).m_60767_().m_76337_()) {
            spo = spo.m_7494_();
        }
        mi.m_7678_((double)spo.m_123341_() + 0.5, spo.m_123342_(), (double)spo.m_123343_() + 0.5, 0.0f, 0.0f);
        if (wp == "Leader") {
            mi.Weapon = "SpearMiridium";
            mi.setPatrolLeader(true);
            mi.Greeting = true;
        } else {
            mi.Weapon = wp;
        }
        mi.MissionType = "Explore";
        mi.Ammo = 10;
        mi.setPatrolTarget(this.m_58899_().m_7494_());
        mi.PowerLevel = 5;
        mi.m_6518_((ServerLevelAccessor)((ServerLevel)this.f_58857_), this.f_58857_.m_6436_(this.m_58899_()), MobSpawnType.PATROL, null, null);
        ((ServerLevel)this.f_58857_).m_47205_((Entity)mi);
        mi.m_21373_();
        return mi;
    }
}

