/*
 * Decompiled with CFR 0.152.
 */
package com.mialliance.entities;

import com.mialliance.entities.EntityMi;
import com.mialliance.entities.EntityTonkTurret;
import com.mialliance.entities.EntityTrain;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;

public class MiRangedGoal<T extends Mob>
extends Goal {
    private final T mob;
    private final double speedModifier;
    private int attackIntervalMin;
    private float attackRadiusSqr;
    private int attackTime = -1;
    private int seeTime;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;

    public MiRangedGoal(T p_i47515_1_, double p_i47515_2_, int p_i47515_4_, float p_i47515_5_) {
        this.mob = p_i47515_1_;
        this.speedModifier = p_i47515_2_;
        this.attackIntervalMin = p_i47515_4_;
        this.attackRadiusSqr = p_i47515_5_ * p_i47515_5_;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public void setMinAttackInterval(int p_189428_1_) {
        this.attackIntervalMin = p_189428_1_;
    }

    public boolean m_8036_() {
        if (!((EntityTrain)((Object)this.mob)).canAttack) {
            return false;
        }
        return this.mob.m_5448_() == null ? false : this.isHoldingBow();
    }

    protected boolean isHoldingBow() {
        return this.mob.m_21093_(is -> is.m_41720_() instanceof BowItem) || this.mob instanceof EntityTonkTurret;
    }

    public boolean m_8045_() {
        if (this.mob.m_5448_() == null) {
            if (this.mob.m_6117_()) {
                this.mob.m_5810_();
            }
            return false;
        }
        if (!this.mob.m_5448_().m_6084_()) {
            if (this.mob.m_6117_()) {
                this.mob.m_5810_();
            }
            return false;
        }
        return this.m_8036_();
    }

    public void m_8056_() {
        super.m_8056_();
        this.mob.m_21561_(true);
    }

    public void m_8041_() {
        super.m_8041_();
        this.mob.m_21561_(false);
        this.seeTime = 0;
        this.attackTime = -1;
        if (this.mob.m_6117_()) {
            this.mob.m_5810_();
        }
    }

    public void m_8037_() {
        LivingEntity livingentity = this.mob.m_5448_();
        if (livingentity != null) {
            boolean flag1;
            this.mob.m_21391_((Entity)livingentity, 90.0f, 1.0f);
            double d0 = this.mob.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
            boolean flag = this.mob.m_21574_().m_148306_((Entity)livingentity);
            boolean bl = flag1 = this.seeTime > 0;
            if (flag != flag1) {
                this.seeTime = 0;
            }
            this.seeTime = flag ? ++this.seeTime : --this.seeTime;
            if (this.seeTime < -80) {
                this.seeTime = 0;
                this.mob.m_6710_(null);
                return;
            }
            if (!(d0 > (double)this.attackRadiusSqr) && this.seeTime >= 20) {
                this.mob.m_21573_().m_26573_();
                ++this.strafingTime;
            } else if (((EntityMi)((Object)this.mob)).allowMove) {
                this.mob.m_21573_().m_5624_((Entity)livingentity, this.speedModifier);
                this.strafingTime = -1;
            }
            if (this.strafingTime >= 50) {
                if ((double)this.mob.m_217043_().m_188501_() < 0.3) {
                    boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
                }
                if ((double)this.mob.m_217043_().m_188501_() < 0.3) {
                    this.strafingBackwards = !this.strafingBackwards;
                }
                this.strafingTime = 0;
            }
            if (this.strafingTime > -1) {
                if (d0 > (double)(this.attackRadiusSqr * 0.7f)) {
                    this.strafingBackwards = false;
                } else if (d0 < (double)(this.attackRadiusSqr * 0.3f)) {
                    this.strafingBackwards = true;
                }
                if (((EntityMi)((Object)this.mob)).allowMove) {
                    this.mob.m_21566_().m_24988_(this.strafingBackwards ? -0.7f : 0.7f, this.strafingClockwise ? 0.7f : -0.7f);
                }
            }
            if (this.mob.m_6117_()) {
                if (this.seeTime < -60) {
                    this.mob.m_5810_();
                } else if (flag) {
                    int i = this.mob.m_21252_();
                    if (i == 15) {
                        this.mob.m_21569_().m_24901_();
                    }
                    if (i >= 20) {
                        this.mob.m_5810_();
                        ((RangedAttackMob)this.mob).m_6504_(livingentity, BowItem.m_40661_((int)i));
                        this.attackTime = this.attackIntervalMin;
                    }
                }
            } else if (--this.attackTime <= 0 && this.seeTime >= -60) {
                this.mob.m_6672_(ProjectileUtil.getWeaponHoldingHand(this.mob, item -> item instanceof BowItem));
            }
        }
    }
}

