/*
 * Decompiled with CFR 0.152.
 */
package com.mialliance.utils;

import com.mialliance.entities.EntityMi;
import java.util.Arrays;
import java.util.HashMap;
import net.minecraft.resources.ResourceLocation;

public class TextureHelper {
    public static HashMap<Integer, ResourceLocation> getColorTextures(String entityName) {
        HashMap<Integer, ResourceLocation> locations = new HashMap<Integer, ResourceLocation>();
        Arrays.stream(COLORS.values()).toList().forEach(color -> locations.put(color.ordinal(), new ResourceLocation("mialliance", "textures/entity/" + entityName.toLowerCase() + "/" + color.name().toLowerCase() + ".png")));
        return locations;
    }

    public static HashMap<Integer, ResourceLocation> getAllegianceTextures(String entityName) {
        HashMap<Integer, ResourceLocation> locations = new HashMap<Integer, ResourceLocation>();
        locations.put(COLORS.ALLIANCE.ordinal(), new ResourceLocation("mialliance", "textures/entity/" + entityName.toLowerCase() + "/alliance.png"));
        locations.put(COLORS.FRIENDLY.ordinal(), new ResourceLocation("mialliance", "textures/entity/" + entityName.toLowerCase() + "/friendly.png"));
        return locations;
    }

    public static ResourceLocation checkColorTexture(EntityMi ent, HashMap<Integer, ResourceLocation> map) {
        if (ent.isTame()) {
            if (ent.getColor() != 0) {
                return map.get(ent.getColor() + 1);
            }
            return map.get(1);
        }
        return map.get(0);
    }

    public static ResourceLocation checkAllegianceTexture(EntityMi ent, HashMap<Integer, ResourceLocation> map) {
        return map.get(ent.isTame() ? 1 : 0);
    }

    public static enum COLORS {
        ALLIANCE,
        FRIENDLY,
        FRIENDLY_BLUE,
        FRIENDLY_GREEN,
        FRIENDLY_YELLOW,
        FRIENDLY_RED,
        FRIENDLY_BLACK;

    }
}

