/*
 * Decompiled with CFR 0.152.
 */
package com.mialliance;

import com.mialliance.MiCon;
import com.mialliance.ModGameRules;
import com.mialliance.entities.EntityLegacian;
import com.mialliance.entities.ModEntities;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.Heightmap;
import org.slf4j.Logger;

public class TubianSpawner {
    private static final TagKey<Biome> TUBIAN_TAG = TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation("mialliance", "tubian_biome"));
    private static final Logger LOGGER = LogUtils.getLogger();
    private int tick = 0;
    private int tries = 0;
    private boolean hasInit = false;
    private boolean executeTicks;

    private void init(ServerLevel lev) {
        this.hasInit = true;
        this.setTick(3000 + lev.m_213780_().m_188503_(3000));
        LOGGER.info("Initializing Tubian spawn...");
    }

    public void tick(ServerLevel lev) {
        if (!this.hasInit) {
            this.init(lev);
            return;
        }
        if (this.tick < 1) {
            this.tick = 200;
            this.executeTicks = true;
        }
        if (this.executeTicks) {
            this.mi(lev);
        }
    }

    public void time() {
        --this.tick;
        this.executeTicks = false;
    }

    public void mi(ServerLevel lev) {
        RandomSource r = lev.m_213780_();
        if (!lev.m_46461_()) {
            return;
        }
        ArrayList Plays = new ArrayList(lev.m_6907_());
        ArrayList<Player> Targets = new ArrayList<Player>();
        ArrayList<Integer> PlaysInArea = new ArrayList<Integer>();
        for (Player pe : lev.m_6907_()) {
            if (pe == null || !Plays.contains(pe) || !lev.m_204166_(pe.m_20183_()).m_203656_(TUBIAN_TAG)) continue;
            int io = 1;
            for (Player pe2 : lev.m_6907_()) {
                if (!(pe2.m_20270_((Entity)pe) < 100.0f)) continue;
                ++io;
                Plays.remove(pe2);
            }
            Targets.add(pe);
            Plays.remove(pe);
            PlaysInArea.add(io);
        }
        ++this.tries;
        if (Targets.isEmpty()) {
            return;
        }
        if (r.m_188499_() && this.tries < 3) {
            this.setTick(13000 + r.m_188503_(13000));
            LOGGER.info("Delaying Tubian spawn...");
            return;
        }
        this.setTick(50000 + r.m_188503_(14000));
        this.tries = 0;
        LOGGER.info("Attempting Tubian spawn...");
        for (Player pe : Targets) {
            this.spawnWave(pe, lev);
        }
    }

    private void spawnWave(Player pe, ServerLevel lev) {
        if (!lev.m_46469_().m_46207_(ModGameRules.TUBIAN_SPAWNING)) {
            return;
        }
        BlockPos spawnpoint = this.findSpawn(lev, pe.m_20183_(), 20, 40);
        this.spawnMi(lev, spawnpoint);
    }

    private BlockPos findSpawn(ServerLevel lev, BlockPos center, int radMin, int radMax) {
        RandomSource r = lev.m_213780_();
        int rad = radMin + r.m_188503_(radMax - radMin);
        double ang = r.m_188500_() * Math.PI * 2.0;
        int dx = (int)Math.ceil(Math.cos(ang) * (double)rad);
        int dz = (int)Math.ceil(Math.sin(ang) * (double)rad);
        BlockPos there = new BlockPos(center.m_123341_() + dx, center.m_123342_(), center.m_123343_() + dz);
        there = lev.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, there);
        return there;
    }

    private void setTick(int i) {
        this.tick = Mth.m_14165_((double)((double)i / (Double)MiCon.TUBIAN_SPAWNRATE.get()));
    }

    private void spawnMi(ServerLevel lev, BlockPos here) {
        EntityLegacian mi = (EntityLegacian)((EntityType)ModEntities.LEGACIAN.get()).m_20615_((Level)lev);
        LOGGER.info("Spawning Tubian!");
        mi.mission = 1;
        mi.fade = 3600;
        mi.m_6034_(here.m_123341_(), here.m_123342_(), here.m_123343_());
        mi.m_6518_((ServerLevelAccessor)lev, lev.m_6436_(here), MobSpawnType.PATROL, null, null);
        lev.m_7967_((Entity)mi);
    }
}

