/*
 * Decompiled with CFR 0.152.
 */
package com.mialliance.block;

import com.mialliance.MiCon;
import com.mialliance.block.ModBlocks;
import com.mialliance.block.ModTileEntities;
import com.mialliance.block.TileEntityEmbassy;
import com.mialliance.entities.EntityCarrymi;
import com.mialliance.entities.EntityGoob;
import com.mialliance.entities.EntityMi;
import com.mialliance.entities.EntityTonkTurret;
import com.mialliance.entities.ModEntities;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.Tags;
import org.slf4j.Logger;

public class TileEntityCore
extends BlockEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private int Count = 0;
    private List<LocationTypes> LocationID = new ArrayList<LocationTypes>();
    public boolean Done = false;
    public int Resources;
    public int ResourceGain;
    public int Type;
    public int StructureAdds;
    public int VarType;
    public int Tier;
    public int Phase = 1;
    private int Goal;
    private int readyParty = 3;
    public int giveColor = 0;
    public int CoreLevel = 0;
    public int BaseType = 0;
    public int bridgeBlocks;
    public int miniStructures;
    public int defenseTurrets;
    public int defenseBlocks;
    public int turretMax;
    private boolean findDocks;
    private int[] recents = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public boolean Center;
    private BlockPos Docks = null;
    public boolean DocksDone = false;
    public List<BlockPos> mines = new ArrayList<BlockPos>();
    public List<BlockPos> outposts = new ArrayList<BlockPos>();
    public List<BlockPos> outpost_candidates = new ArrayList<BlockPos>();
    public List<BlockPos> build_candidates = new ArrayList<BlockPos>();
    private List<EntityMi> friends = new ArrayList<EntityMi>();
    private UUID owner;
    private List<Integer> Mi_ID = new ArrayList<Integer>();
    private int Mi_Weights = 0;
    private List<Integer> Mi_WeightMin = new ArrayList<Integer>();
    private int Mi_WeightTotal = 0;
    private boolean isTubian;
    private int Terraform = 0;
    public boolean TubianTunnels = true;
    public List<BlockPos> SecurityPoints = new ArrayList<BlockPos>();
    private boolean initLocation = false;
    private int ConvertCooldown = 0;

    public TileEntityCore(BlockPos p_155397_, BlockState p_155398_) {
        super((BlockEntityType)ModTileEntities.CORE.get(), p_155397_, p_155398_);
    }

    private void checkLocation() {
        if (this.initLocation) {
            return;
        }
        this.initLocation = true;
        Level lev = this.m_58904_();
        BlockPos spawnpoint = this.m_58899_();
        this.LocationID = new ArrayList<LocationTypes>();
        if (lev.m_204166_(spawnpoint).m_203656_(BiomeTags.f_215818_)) {
            this.LocationID.add(LocationTypes.END);
        } else if (lev.m_204166_(spawnpoint).m_203656_(BiomeTags.f_207611_) || lev.m_204166_(spawnpoint).m_203656_(BiomeTags.f_207610_)) {
            this.LocationID.add(LocationTypes.FOREST);
        } else if (lev.m_204166_(spawnpoint).m_203656_(Tags.Biomes.IS_DESERT)) {
            this.LocationID.add(LocationTypes.DESERT);
        } else if (lev.m_204166_(spawnpoint).m_203656_(Tags.Biomes.IS_MOUNTAIN) || lev.m_204166_(spawnpoint).m_203656_(BiomeTags.f_207608_)) {
            this.LocationID.add(LocationTypes.MOUNTAIN);
        } else if (lev.m_204166_(spawnpoint).m_203656_(Tags.Biomes.IS_SNOWY)) {
            this.LocationID.add(LocationTypes.SNOWY);
        }
    }

    public void setCore(int Level2, int Power) {
        this.Center = true;
        if (this.CoreLevel < Level2) {
            this.CoreLevel = Level2;
            this.VarType = this.f_58857_.m_213780_().m_188503_(6);
        }
        this.Resources = Level2 == 2 ? (this.BaseType == 2 ? (this.Resources += 50 + Power * 40) : (this.f_58857_.m_46791_() == Difficulty.EASY || this.f_58857_.m_46791_() == Difficulty.PEACEFUL ? (this.Resources += 150 + Power * 80) : (this.Resources += 200 + Power * 150))) : (this.f_58857_.m_46791_() == Difficulty.EASY || this.f_58857_.m_46791_() == Difficulty.PEACEFUL ? (this.Resources += 50 + Power * 40) : (this.Resources += 100 + Power * 50));
        this.BaseType = 0;
        if (this.f_58857_.m_6042_().f_63856_()) {
            this.BaseType = 2;
        } else if (this.m_58899_().m_123342_() < 60) {
            this.BaseType = 1;
        }
    }

    private void findDocksPosition() {
        Level lev = this.f_58857_;
        TileEntityCore dis = this;
        dis.findDocks = true;
        BlockPos hi = null;
        for (int ix = -100; ix < 100; ix += 5) {
            for (int iz = -100; iz < 100; iz += 5) {
                hi = dis.m_58899_().m_7918_(ix, 0, iz);
                if (!lev.m_204166_(dis.f_58858_).m_203656_(BiomeTags.f_207603_) || Math.abs(ix) + Math.abs(iz) <= 30 || !lev.m_204166_(dis.f_58858_).m_203656_(BiomeTags.f_207603_)) continue;
                ix = 100;
                dis.Docks = lev.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, hi).m_6630_(3);
                dis.outposts.add(dis.Docks);
            }
        }
    }

    private float getBaseSizeWorth(List<TileEntityCore> base) {
        if (base.size() > 14) {
            return 14.0f + (float)(base.size() - 14) * 0.35f;
        }
        return base.size();
    }

    public static void serverTick(Level lev, BlockPos p, BlockState p_155406_, TileEntityCore dis) {
        block171: {
            block172: {
                dis.terraformingPulse();
                if (dis.Count++ <= 99) break block171;
                dis.Count = 0;
                dis.construction();
                dis.checkLocation();
                if (!dis.Center) break block171;
                if (dis.ResourceGain > 0) {
                    if (dis.ResourceGain > 12) {
                        dis.ResourceGain = 12;
                    }
                    dis.Resources += dis.ResourceGain + 3;
                    dis.ResourceGain = 0;
                }
                Level w = dis.f_58857_;
                RandomSource r = dis.f_58857_.m_213780_();
                if (!dis.findDocks && dis.Docks == null) {
                    dis.findDocksPosition();
                }
                List<TileEntityCore> base = dis.nearbyColony();
                dis.checkFriends();
                base.add(dis);
                if (dis.CoreLevel == 1 && dis.friends.size() > 24) {
                    dis.CoreLevel = 2;
                    dis.Resources = 0;
                    dis.Goal = 1;
                }
                dis.Reconvert();
                if (dis.readyParty-- < 1) {
                    dis.readyParty = 1;
                    List<EntityMi> employees = dis.nearbyUnemployed();
                    List<EntityMi> employeesCopy = dis.nearbyUnemployed();
                    ArrayList<EntityMi> priorities = new ArrayList<EntityMi>();
                    int Party = 0;
                    dis.turretMax = base.size() / 2;
                    if (!dis.isDaytime() && dis.BaseType == 0) {
                        Party = 20;
                    } else {
                        dis.clearWeightMi();
                        if (dis.BaseType == 2) {
                            dis.addWeightMiRecents(6, 15);
                            if ((float)dis.bridgeBlocks < dis.getBaseSizeWorth(base) * 100.0f && (!dis.isTubian() || dis.TubianTunnels)) {
                                dis.addWeightMiRecents(4, 20);
                            }
                            if ((float)dis.bridgeBlocks < dis.getBaseSizeWorth(base) * 100.0f && (!dis.isTubian() || dis.TubianTunnels)) {
                                dis.addWeightMiRecents(9, 10);
                            }
                            if (!dis.isTubian() && dis.outpost_candidates.size() > 0 && (float)dis.outposts.size() < dis.getBaseSizeWorth(base) / 3.0f) {
                                dis.addWeightMiRecents(10, 20);
                            }
                        } else {
                            if (dis.mines.isEmpty()) {
                                dis.addWeightMiRecents(1, 25);
                            } else {
                                dis.addWeightMiRecents(1, 15);
                            }
                            if (lev.m_204166_(dis.f_58858_).m_203656_(BiomeTags.f_207611_)) {
                                dis.addWeightMiRecents(2, 25);
                            } else {
                                dis.addWeightMiRecents(2, 15);
                            }
                            if (dis.BaseType == 1 && (float)dis.bridgeBlocks < 60.0f + dis.getBaseSizeWorth(base) * 90.0f && (!dis.isTubian() || dis.TubianTunnels)) {
                                dis.addWeightMiRecents(4, 10);
                                dis.addWeightMiRecents(9, 10);
                            } else {
                                dis.addWeightMiRecents(3, 15);
                            }
                            if (dis.CoreLevel > 0) {
                                dis.addWeightMiRecents(5, 15);
                                if ((float)dis.bridgeBlocks < dis.getBaseSizeWorth(base) * 80.0f && (!dis.isTubian() || dis.TubianTunnels)) {
                                    dis.addWeightMiRecents(4, 15);
                                }
                            }
                            if (dis.CoreLevel > 1) {
                                dis.addWeightMiRecents(6, 20);
                                if ((float)dis.bridgeBlocks < dis.getBaseSizeWorth(base) * 80.0f && (!dis.isTubian() || dis.TubianTunnels)) {
                                    dis.addWeightMiRecents(9, 10);
                                }
                                if (dis.haveTechSpecific(base, 8) && dis.defenseTurrets < dis.turretMax) {
                                    dis.addWeightMiRecents(22, 30);
                                }
                                if (dis.haveTechSpecific(base, 12) && !dis.hasDocks()) {
                                    dis.addWeightMiRecents(23, 60);
                                }
                                if ((float)dis.defenseBlocks < dis.getBaseSizeWorth(base) * 45.0f) {
                                    dis.addWeightMiRecents(7, 20);
                                } else {
                                    dis.addWeightMiRecents(7, 10);
                                }
                                if ((float)dis.miniStructures < dis.getBaseSizeWorth(base) / 2.0f && !dis.isTubian()) {
                                    dis.addWeightMiRecents(8, 15);
                                }
                                if (!dis.isTubian() && dis.outpost_candidates.size() > 0 && (float)dis.outposts.size() < dis.getBaseSizeWorth(base) / 5.0f) {
                                    dis.addWeightMiRecents(10, 10);
                                }
                            }
                        }
                        Party = dis.getMi(r);
                        dis.recents[Party] = -8;
                    }
                    int PartyMax = 4;
                    switch (Party) {
                        case 3: {
                            PartyMax = 1;
                            break;
                        }
                        case 4: {
                            if (dis.BaseType == 2) break;
                            PartyMax = 2;
                            break;
                        }
                        case 5: {
                            PartyMax = 2;
                            break;
                        }
                        case 7: {
                            PartyMax = 2;
                            break;
                        }
                        case 8: {
                            PartyMax = 1;
                            break;
                        }
                        case 9: {
                            PartyMax = 2;
                        }
                    }
                    if (employees.size() > PartyMax && employees.size() > base.size()) {
                        boolean pass = false;
                        BlockPos gi = dis.m_58899_();
                        int gox = 0;
                        int goz = 0;
                        int ito1 = 0;
                        switch (Party) {
                            case 1: {
                                if (dis.mines.isEmpty() || r.m_188503_(3) == 0 && dis.mines.size() < 4) {
                                    while (!pass) {
                                        pass = true;
                                        ++ito1;
                                        gox = 45 + r.m_188503_(20);
                                        if (r.m_188499_()) {
                                            gox *= -1;
                                        }
                                        goz = r.m_188503_(21) - 10;
                                        gi = r.m_188499_() ? w.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, dis.m_58899_().m_7918_(goz, 5, gox)) : w.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, dis.m_58899_().m_7918_(gox, 5, goz));
                                        if (gi.m_123342_() < 10) {
                                            pass = false;
                                        } else if (w.m_6425_(gi.m_7495_()).m_76178_()) {
                                            pass = false;
                                        }
                                        if (ito1 <= 20) continue;
                                        dis.recents[Party] = -16;
                                        return;
                                    }
                                    dis.mines.add(gi);
                                } else {
                                    gi = dis.mines.get(r.m_188503_(dis.mines.size()));
                                }
                                for (EntityMi mi : employeesCopy) {
                                    if (mi.m_6095_() != ModEntities.MI.get()) {
                                        employees.remove((Object)mi);
                                        continue;
                                    }
                                    if (mi.Weapon != "" && mi.Weapon != "Pickaxe") continue;
                                    priorities.add(mi);
                                }
                                break;
                            }
                            case 2: {
                                while (!pass) {
                                    ++ito1;
                                    pass = true;
                                    gox = 20 + r.m_188503_(40);
                                    if (r.m_188499_()) {
                                        gox *= -1;
                                    }
                                    goz = r.m_188503_(41) - 20;
                                    gi = r.m_188499_() ? w.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, dis.m_58899_().m_7918_(goz, 5, gox)) : w.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, dis.m_58899_().m_7918_(gox, 5, goz));
                                    if (gi.m_123342_() < 10) {
                                        pass = false;
                                    }
                                    if (ito1 <= 20) continue;
                                    dis.recents[Party] = -16;
                                    return;
                                }
                                break;
                            }
                            case 3: {
                                while (!pass) {
                                    ++ito1;
                                    pass = true;
                                    gox = 45 + r.m_188503_(40);
                                    if (r.m_188499_()) {
                                        gox *= -1;
                                    }
                                    goz = r.m_188503_(41) - 20;
                                    gi = r.m_188499_() ? w.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, dis.m_58899_().m_7918_(goz, 5, gox)) : w.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, dis.m_58899_().m_7918_(gox, 5, goz));
                                    if (gi.m_123342_() < 10) {
                                        pass = false;
                                    }
                                    if (ito1 <= 20) continue;
                                    dis.recents[Party] = -16;
                                    return;
                                }
                                for (EntityMi mi : employeesCopy) {
                                    if (mi.Weapon != "Bow" && mi.Weapon != "Gem") continue;
                                    priorities.add(mi);
                                }
                                break;
                            }
                            case 4: {
                                if (dis.BaseType != 2) {
                                    while (!pass) {
                                        ++ito1;
                                        pass = true;
                                        gox = 25 + r.m_188503_(40);
                                        if (r.m_188499_()) {
                                            gox *= -1;
                                        }
                                        goz = r.m_188503_(41) - 20;
                                        gi = r.m_188499_() ? w.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, dis.m_58899_().m_7918_(goz, 5, gox)) : w.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, dis.m_58899_().m_7918_(gox, 5, goz));
                                        if (gi.m_123342_() < 10) {
                                            pass = false;
                                        }
                                        if (ito1 <= 20) continue;
                                        dis.recents[Party] = -16;
                                        return;
                                    }
                                }
                                for (EntityMi mi : employeesCopy) {
                                    if (mi.m_6095_() != ModEntities.MI.get()) {
                                        employees.remove((Object)mi);
                                        continue;
                                    }
                                    if (mi.Weapon != "") continue;
                                    priorities.add(mi);
                                }
                                break;
                            }
                            case 5: {
                                while (!pass) {
                                    ++ito1;
                                    pass = true;
                                    gox = 45 + r.m_188503_(40);
                                    if (r.m_188499_()) {
                                        gox *= -1;
                                    }
                                    goz = r.m_188503_(41) - 20;
                                    gi = r.m_188499_() ? w.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, dis.m_58899_().m_7918_(goz, 5, gox)) : w.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, dis.m_58899_().m_7918_(gox, 5, goz));
                                    if (gi.m_123342_() < 10) {
                                        pass = false;
                                    }
                                    if (ito1 <= 20) continue;
                                    dis.recents[Party] = -16;
                                    return;
                                }
                                for (EntityMi mi : employeesCopy) {
                                    if (mi.Weapon != "" || mi.m_6095_() == ModEntities.GOOB.get()) continue;
                                    priorities.add(mi);
                                }
                                break;
                            }
                            case 6: {
                                for (EntityMi mi : employeesCopy) {
                                    if (mi.Weapon == "" && mi.m_6095_() == ModEntities.MI.get() || mi.Weapon == "Pickaxe") continue;
                                    priorities.add(mi);
                                }
                                break;
                            }
                            case 7: {
                                while (!pass) {
                                    ++ito1;
                                    pass = true;
                                    gox = 45 + r.m_188503_(30);
                                    if (r.m_188499_()) {
                                        gox *= -1;
                                    }
                                    goz = r.m_188503_(41) - 20;
                                    gi = r.m_188499_() ? w.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, dis.m_58899_().m_7918_(goz, 5, gox)) : w.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, dis.m_58899_().m_7918_(gox, 5, goz));
                                    if (gi.m_123342_() < 10) {
                                        pass = false;
                                    }
                                    if (ito1 <= 20) continue;
                                    dis.recents[Party] = -16;
                                    return;
                                }
                                for (EntityMi mi : employeesCopy) {
                                    if (mi.Weapon != "") continue;
                                    priorities.add(mi);
                                }
                                break;
                            }
                            case 8: {
                                while (!pass) {
                                    ++ito1;
                                    pass = true;
                                    gox = 35 + r.m_188503_(30);
                                    if (r.m_188499_()) {
                                        gox *= -1;
                                    }
                                    goz = r.m_188503_(41) - 20;
                                    gi = r.m_188499_() ? w.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, dis.m_58899_().m_7918_(goz, 5, gox)) : w.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, dis.m_58899_().m_7918_(gox, 5, goz));
                                    if (gi.m_123342_() < 10) {
                                        pass = false;
                                    }
                                    if (ito1 <= 20) continue;
                                    dis.recents[Party] = -16;
                                    return;
                                }
                                for (EntityMi mi : employeesCopy) {
                                    if (mi.m_6095_() != ModEntities.MI.get()) {
                                        employees.remove((Object)mi);
                                        continue;
                                    }
                                    if (mi.Weapon != "") continue;
                                    priorities.add(mi);
                                }
                                break;
                            }
                            case 9: {
                                for (EntityMi mi : employeesCopy) {
                                    if (mi.m_6095_() != ModEntities.MI.get()) {
                                        employees.remove((Object)mi);
                                        continue;
                                    }
                                    if (mi.Weapon != "") continue;
                                    priorities.add(mi);
                                }
                                break;
                            }
                            case 10: {
                                int r10 = r.m_188503_(dis.outpost_candidates.size());
                                gi = dis.outpost_candidates.get(r10);
                                break;
                            }
                            case 22: {
                                while (!pass) {
                                    ++ito1;
                                    pass = true;
                                    gox = 45 + r.m_188503_(30);
                                    if (r.m_188499_()) {
                                        gox *= -1;
                                    }
                                    goz = r.m_188503_(41) - 20;
                                    gi = r.m_188499_() ? w.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, dis.m_58899_().m_7918_(goz, 5, gox)) : w.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, dis.m_58899_().m_7918_(gox, 5, goz));
                                    if (gi.m_123342_() < 10) {
                                        pass = false;
                                    }
                                    if (ito1 <= 20) continue;
                                    dis.recents[Party] = -16;
                                    return;
                                }
                                for (EntityMi mi : employeesCopy) {
                                    if (mi.m_6095_() != ModEntities.MI.get()) {
                                        employees.remove((Object)mi);
                                        continue;
                                    }
                                    if (mi.Weapon != "") continue;
                                    priorities.add(mi);
                                }
                                break;
                            }
                            case 23: {
                                gi = dis.Docks;
                                for (EntityMi mi : employeesCopy) {
                                    if (mi.Weapon != "") continue;
                                    priorities.add(mi);
                                }
                                break;
                            }
                        }
                        while (!employees.isEmpty() && PartyMax > 0) {
                            EntityMi mi = null;
                            if (!priorities.isEmpty()) {
                                mi = (EntityMi)((Object)priorities.get(r.m_188503_(priorities.size())));
                                priorities.remove((Object)mi);
                            } else {
                                mi = employees.get(r.m_188503_(employees.size()));
                            }
                            employees.remove((Object)mi);
                            mi.ObjectiveProgress = Party;
                            mi.ObjectiveTarget = dis.m_58899_();
                            mi.ObjectiveTarget2 = gi;
                            mi.CheckObjective = null;
                            mi.CheckObjective2 = null;
                            --PartyMax;
                        }
                    }
                }
                if (dis.nearbyEnemy()) break block172;
                switch (dis.Goal) {
                    case 0: {
                        if (dis.isTubian()) {
                            if (dis.nearbyColonyPurpose().size() > 2) {
                                dis.Goal = 3;
                                break;
                            }
                            if (!dis.build_candidates.isEmpty() && base.size() * 3 - dis.friends.size() < 3) {
                                dis.Goal = 1;
                                break;
                            }
                            if (base.size() * 5 - dis.friends.size() > 0) {
                                dis.Goal = 2;
                            }
                            if (dis.getTechs(base, 1).size() <= 0 || !r.m_188499_()) break;
                            dis.Goal = 4;
                            break;
                        }
                        float Chess = r.m_188501_() * 10.0f;
                        Chess += (float)(base.size() * 5 - dis.friends.size());
                        if (dis.CoreLevel > 0 && (Chess < 5.0f || dis.Resources > 200)) {
                            dis.Goal = 1;
                            if (dis.nearbyColonyPurpose().size() <= 2) break;
                            dis.Goal = 3;
                            break;
                        }
                        dis.Goal = 2;
                        if (dis.getTechs(base, 1).size() <= 0 || !r.m_188499_()) break;
                        dis.Goal = 4;
                        break;
                    }
                    case 1: {
                        EntityMi mi;
                        int amn;
                        int i;
                        if (dis.Resources <= 90) break;
                        dis.Goal = 0;
                        List<TileEntityCore> ex = dis.nearbyColonyExpand();
                        if (base.size() > (Integer)MiCon.MI_CORE_MAX.get()) {
                            return;
                        }
                        dis.readyParty = 6;
                        BlockPos check = null;
                        if (dis.isTubian()) {
                            check = dis.build_candidates.get(0);
                            dis.build_candidates.remove(dis.build_candidates.get(0));
                            if (!lev.m_8055_(check).m_60713_((Block)ModBlocks.FAMILIAR_CORE.get())) {
                                return;
                            }
                            boolean Success = true;
                            for (TileEntityCore o : base) {
                                int dx = Math.abs(o.m_58899_().m_123341_() - check.m_123341_());
                                int dz = Math.abs(o.m_58899_().m_123343_() - check.m_123343_());
                                if (dx >= 7 || dz >= 7) continue;
                                Success = false;
                            }
                            if (!Success) {
                                return;
                            }
                            dis.outposts.add(check);
                        } else {
                            i = 50;
                            boolean Success = false;
                            check = null;
                            while (!Success && i > 0) {
                                BlockPos soep;
                                Success = true;
                                --i;
                                BlockPos pos = ex.get(r.m_188503_(ex.size())).m_58899_();
                                int plux = r.m_188499_() ? 7 : -7;
                                check = r.m_188499_() ? pos.m_7918_(plux, 0, r.m_188503_(5) - 2) : pos.m_7918_(r.m_188503_(5) - 2, 0, plux);
                                for (TileEntityCore o : base) {
                                    int dx = Math.abs(o.m_58899_().m_123341_() - check.m_123341_());
                                    int dz = Math.abs(o.m_58899_().m_123343_() - check.m_123343_());
                                    if (dx >= 7 || dz >= 7) continue;
                                    Success = false;
                                }
                                if (!Success || (soep = w.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, check)).m_123342_() >= check.m_123342_()) continue;
                                check = check.m_7495_();
                            }
                            if (check == null || i == 0) {
                                return;
                            }
                        }
                        dis.spendResources(55 + base.size() * 6);
                        w.m_7731_(check, ((Block)ModBlocks.MI_CORE.get()).m_49966_(), 3);
                        TileEntityCore co = (TileEntityCore)w.m_7702_(check);
                        co.VarType = r.m_188503_(6);
                        co.isTubian = dis.isTubian;
                        List<EntityMi> mis = dis.nearbyMi();
                        for (amn = 0; !mis.isEmpty() && amn < 4; ++amn) {
                            mi = mis.get(r.m_188503_(mis.size()));
                            mis.remove((Object)mi);
                            mi.ObjectiveTarget = check;
                        }
                        break block171;
                    }
                    case 2: {
                        if (dis.Resources <= 60) break;
                        if (dis.isTubian() && (dis.owner == null || dis.f_58857_.m_46003_(dis.owner) == null || dis.friends.isEmpty())) {
                            dis.Goal = 0;
                            return;
                        }
                        int colm = 2 + r.m_188503_(2);
                        for (int col = 0; col < colm; ++col) {
                            dis.Goal = 0;
                            if (dis.nearbyMi().size() > 60) {
                                return;
                            }
                            String spawn = dis.buildMi(base);
                            if (spawn != "Mi") {
                                col = colm;
                            }
                            dis.GoMi(spawn, base.get(r.m_188503_(base.size())).m_58899_(), "", r);
                            dis.spendResources(30.0f);
                            dis.spendResources(Math.max(0, dis.friends.size() - base.size() * 5 - 5) * 3);
                        }
                        break block171;
                    }
                    case 3: {
                        EntityMi mi;
                        int amn;
                        if (dis.Resources <= 60) break;
                        dis.Goal = 0;
                        dis.readyParty = 4;
                        Object check = null;
                        TileEntityCore co = null;
                        for (TileEntityCore o : base) {
                            if (o.Type != 0) continue;
                            co = o;
                            break;
                        }
                        if (co == null) break;
                        dis.spendResources(45 + base.size() * 3);
                        boolean upg = true;
                        while (upg) {
                            upg = false;
                            if (!dis.haveTechSpecific(base, 15) && dis.BaseType == 2) {
                                co.Type = 15;
                            } else if (dis.Phase > 1) {
                                if (!dis.haveTechSpecific(base, 13)) {
                                    co.Type = 13;
                                } else if (dis.getTechs(base, 0).size() > 2) {
                                    co.Type = 1 + r.m_188503_(14);
                                    if (dis.Docks != null && r.m_188503_(2) == 0 && !dis.haveTechSpecific(base, 11)) {
                                        co.Type = 11;
                                    }
                                } else {
                                    co.Type = 1 + r.m_188503_(3);
                                }
                            } else if (dis.getTechs(base, 0).size() > 2) {
                                co.Type = 1 + r.m_188503_(12);
                                if (!dis.haveTechSpecific(base, 16) && dis.LocationID.contains((Object)LocationTypes.END)) {
                                    co.Type = 16;
                                }
                                if (!dis.haveTechSpecific(base, 1)) {
                                    co.Type = 1;
                                } else if (dis.Docks != null && r.m_188503_(2) == 0 && !dis.haveTechSpecific(base, 12)) {
                                    co.Type = 12;
                                }
                            } else {
                                co.Type = 1 + r.m_188503_(3);
                            }
                            if (!(w.m_45527_(co.m_58899_().m_6630_(10)) || co.Type != 3 && co.Type != 9 && co.Type != 11 && co.Type != 14)) {
                                upg = true;
                                continue;
                            }
                            if (co.Type == 12 && dis.Docks == null) {
                                upg = true;
                                continue;
                            }
                            if (!((Boolean)MiCon.MI_UNIT_COMMANDOS.get()).booleanValue() && co.Type == 4) {
                                upg = true;
                                continue;
                            }
                            if (!((Boolean)MiCon.MI_UNIT_TONKS.get()).booleanValue() && co.Type == 10) {
                                upg = true;
                                continue;
                            }
                            if (!((Boolean)MiCon.MI_UNIT_BILLOOS.get()).booleanValue() && co.Type == 11) {
                                upg = true;
                                continue;
                            }
                            if (!((Boolean)MiCon.MI_UNIT_SUBMIRINE.get()).booleanValue() && co.Type == 12) {
                                upg = true;
                                continue;
                            }
                            if (((Boolean)MiCon.MI_UNIT_CARRYMI.get()).booleanValue() || co.Type != 14) continue;
                            upg = true;
                        }
                        if (co.Type == 0) {
                            dis.spendResources(-(45 + base.size() * 3));
                            break;
                        }
                        if (co.Type == 1 || co.Type == 2 || co.Type == 6 || co.Type == 7 || co.Type == 13) {
                            co.StructureAdds = 1;
                        }
                        co.Tier = 1 + r.m_188503_(4);
                        co.Done = false;
                        List<EntityMi> mis = dis.nearbyMi();
                        for (amn = 0; !mis.isEmpty() && amn < 4; ++amn) {
                            mi = mis.get(r.m_188503_(mis.size()));
                            mis.remove((Object)mi);
                            mi.ObjectiveTarget = check;
                        }
                        break block171;
                    }
                    case 4: {
                        if (dis.Resources <= 30) break;
                        List<EntityMi> mitos = dis.nearbyEquippable();
                        List<TileEntityCore> techs = dis.getTechs(base, 1);
                        dis.Goal = 0;
                        if (mitos.isEmpty() || techs.isEmpty()) break;
                        int i = 15;
                        int pts = 25 + base.size() * 3;
                        while (pts > 0 && i > 0) {
                            --i;
                            EntityMi mey = mitos.get(r.m_188503_(mitos.size()));
                            mey.setColor(dis.giveColor);
                            if (mey.Weapon == "" && mey.m_6095_() == ModEntities.MI.get()) {
                                int Typus = techs.get((int)r.m_188503_((int)techs.size())).Type;
                                switch (Typus) {
                                    case 1: {
                                        pts -= 10;
                                        dis.spendResources(10.0f);
                                        mey.Weapon = "Spear";
                                        if (r.m_188499_()) {
                                            mey.Weapon = "Bow";
                                        }
                                        for (LocationTypes type : dis.LocationID) {
                                            switch (type) {
                                                case FOREST: {
                                                    if (r.m_188503_(3) != 0) break;
                                                    mey.Weapon = "Axe";
                                                    break;
                                                }
                                                case DESERT: {
                                                    if (r.m_188503_(3) != 0) break;
                                                    mey.Weapon = "SwordDesert";
                                                }
                                            }
                                        }
                                        dis.GiveWeapon(mey);
                                        break;
                                    }
                                    case 2: {
                                        pts -= 5;
                                        dis.spendResources(5.0f);
                                        mey.Weapon = "Pickaxe";
                                        dis.GiveWeapon(mey);
                                        break;
                                    }
                                    case 6: {
                                        pts -= 20;
                                        dis.spendResources(20.0f);
                                        mey.m_5496_(SoundEvents.f_11679_, 1.0f, 1.0f);
                                        mey.Weapon = "Gem";
                                        dis.GiveWeapon(mey);
                                        break;
                                    }
                                    case 7: {
                                        pts -= 15;
                                        dis.spendResources(15.0f);
                                        mey.Weapon = "Rider";
                                        if (r.m_188499_()) {
                                            mey.Weapon = "RiderBow";
                                        }
                                        dis.GiveWeapon(mey);
                                        break;
                                    }
                                    case 13: {
                                        pts -= 15;
                                        dis.spendResources(15.0f);
                                        mey.Weapon = "SpearMiridium";
                                        if (r.m_188499_()) {
                                            mey.Weapon = "Pistol";
                                        }
                                        dis.GiveWeapon(mey);
                                        break;
                                    }
                                    case 15: {
                                        pts -= 20;
                                        dis.spendResources(20.0f);
                                        mey.Weapon = "Flamethrower";
                                        dis.GiveWeapon(mey);
                                    }
                                }
                            }
                            if (mey.hasArmor()) continue;
                            if (dis.haveTechSpecific(base, 15)) {
                                pts -= 4;
                                dis.spendResources(4.0f);
                                mey.equipInfermium();
                                mey.m_5496_(SoundEvents.f_11679_, 1.0f, 1.0f);
                                continue;
                            }
                            if (dis.haveTechSpecific(base, 13)) {
                                pts -= 5;
                                dis.spendResources(5.0f);
                                mey.equipMiridium();
                                mey.m_5496_(SoundEvents.f_11679_, 1.0f, 1.0f);
                                continue;
                            }
                            if (!dis.haveTechSpecific(base, 16)) continue;
                            pts -= 4;
                            dis.spendResources(4.0f);
                            mey.equipEndimium();
                            mey.m_5496_(SoundEvents.f_11679_, 1.0f, 1.0f);
                        }
                        break;
                    }
                }
                break block171;
            }
            if (dis.Resources > 80) {
                dis.Resources = 80;
            }
        }
    }

    private String buildMi(List<TileEntityCore> base) {
        RandomSource rr = this.f_58857_.m_213780_();
        int ren = 1 + rr.m_188503_(22);
        boolean commando = this.haveTechSpecific(base, 4);
        boolean goob = this.haveTechSpecific(base, 5);
        boolean tonk = this.haveTechSpecific(base, 10);
        boolean billoo = this.haveTechSpecific(base, 11);
        boolean carrymi = this.haveTechSpecific(base, 14);
        boolean warptrooper = this.haveTechSpecific(base, 16);
        boolean submirine = this.hasDocks();
        if (billoo && !this.haveSpecificMi((EntityType)ModEntities.BILLOO.get())) {
            this.spendResources(55.0f);
            return "Billoo";
        }
        if (carrymi && (!this.haveSpecificMi((EntityType)ModEntities.CARRYMI.get()) || this.haveMiAmount((EntityType)ModEntities.PLANE.get()) < 3)) {
            for (EntityMi mi : this.nearbyMi()) {
                if (!(mi instanceof EntityCarrymi) || mi.m_20197_().size() >= 3) continue;
                this.spendResources(30.0f);
                return "Plane";
            }
            this.spendResources(75.0f);
            return "Carrymi";
        }
        if (submirine && !this.haveSpecificMi((EntityType)ModEntities.SUBMIRINE.get())) {
            this.spendResources(55.0f);
            return "Submirine";
        }
        if (tonk && (ren > 20 || !this.haveSpecificMi((EntityType)ModEntities.TONK.get()))) {
            this.spendResources(45.0f);
            return "Tonk";
        }
        if (warptrooper && (!this.haveSpecificMi((EntityType)ModEntities.WARPTROOPER.get()) || rr.m_188503_(4) == 0)) {
            this.spendResources(25.0f);
            return "Warptrooper";
        }
        if (commando && (!this.haveSpecificMi((EntityType)ModEntities.COMMANDO.get()) || !goob && ren < 5 || goob && ren < 7 && ren > 3)) {
            this.spendResources(20.0f);
            return "Commando";
        }
        if (goob && (!this.haveSpecificMi((EntityType)ModEntities.GOOB.get()) || ren < 4 || !commando && ren < 5)) {
            this.spendResources(30.0f);
            return "Goob";
        }
        return "Mi";
    }

    private void GiveWeapon(EntityMi mey) {
        mey.m_5496_(SoundEvents.f_11679_, 1.0f, 1.0f);
        mey.equipSelf();
    }

    private boolean hasDocks() {
        if (this.Docks == null) {
            return false;
        }
        return this.f_58857_.m_7702_(this.Docks) instanceof TileEntityCore;
    }

    private EntityMi getEmptyCarrymi() {
        for (EntityMi mi : this.nearbyMi()) {
            if (!(mi instanceof EntityCarrymi) || mi.m_20197_().size() >= 3) continue;
            return mi;
        }
        return null;
    }

    private void GoMi(String ent, BlockPos loc, String wp, RandomSource rd) {
        EntityMi car;
        EntityMi mi;
        block12 : switch (ent) {
            case "Goob": {
                mi = (EntityMi)((EntityType)ModEntities.GOOB.get()).m_20615_(this.f_58857_);
                break;
            }
            case "Commando": {
                mi = (EntityMi)((EntityType)ModEntities.COMMANDO.get()).m_20615_(this.f_58857_);
                break;
            }
            case "Warptrooper": {
                mi = (EntityMi)((EntityType)ModEntities.WARPTROOPER.get()).m_20615_(this.f_58857_);
                break;
            }
            case "Tonk": {
                mi = (EntityMi)((EntityType)ModEntities.TONK.get()).m_20615_(this.f_58857_);
                break;
            }
            case "Turret": {
                switch (rd.m_188503_(4)) {
                    default: {
                        mi = (EntityMi)((EntityType)ModEntities.TONK_TURRET.get()).m_20615_(this.f_58857_);
                        break block12;
                    }
                    case 1: {
                        mi = (EntityMi)((EntityType)ModEntities.TONK_TURRET_AP.get()).m_20615_(this.f_58857_);
                        break block12;
                    }
                    case 2: {
                        mi = (EntityMi)((EntityType)ModEntities.TONK_TURRET_FLAMETHROWER.get()).m_20615_(this.f_58857_);
                        break block12;
                    }
                    case 3: 
                }
                mi = (EntityMi)((EntityType)ModEntities.TONK_TURRET_AUTOCANNON.get()).m_20615_(this.f_58857_);
                break;
            }
            case "Billoo": {
                mi = (EntityMi)((EntityType)ModEntities.BILLOO.get()).m_20615_(this.f_58857_);
                break;
            }
            case "Submirine": {
                mi = (EntityMi)((EntityType)ModEntities.SUBMIRINE.get()).m_20615_(this.f_58857_);
                break;
            }
            case "Carrymi": {
                mi = (EntityMi)((EntityType)ModEntities.CARRYMI.get()).m_20615_(this.f_58857_);
                break;
            }
            case "Plane": {
                mi = (EntityMi)((EntityType)ModEntities.PLANE.get()).m_20615_(this.f_58857_);
                break;
            }
            case "Mortar": {
                mi = (EntityMi)((EntityType)ModEntities.MI.get()).m_20615_(this.f_58857_);
                break;
            }
            default: {
                mi = (EntityMi)((EntityType)ModEntities.MI.get()).m_20615_(this.f_58857_);
                switch (wp) {
                    case "": {
                        break block12;
                    }
                    case "Pickaxe": {
                        break block12;
                    }
                    case "Spear": {
                        break block12;
                    }
                    case "Bow": {
                        break block12;
                    }
                }
            }
        }
        BlockPos spo = loc;
        if (ent == "Billoo") {
            spo = loc.m_6630_(10);
            while (!this.f_58857_.m_45527_(spo)) {
                spo = spo.m_7494_();
            }
        }
        if (ent == "Submirine" || ent == "Battlecruiser") {
            spo = this.Docks.m_6625_(3);
        }
        mi.m_20035_(spo.m_7494_(), 0.0f, 0.0f);
        mi.Objective = "Colony";
        mi.ObjectiveTarget = loc;
        mi.Weapon = wp;
        mi.PowerLevel = 2 + this.Phase;
        mi.MissionType = "Build";
        mi.setColor(this.giveColor);
        if (this.isTubian()) {
            TileEntityCore co;
            Player peio;
            boolean flag = false;
            if (this.owner != null && (peio = this.f_58857_.m_46003_(this.owner)) != null) {
                mi.tame(peio);
                flag = true;
            }
            if (!flag && (co = this.getCenter()) != null && !co.friends.isEmpty()) {
                mi.tame(co.friends.get(0).getOwnerUUID());
            }
            if (!mi.isTame()) {
                mi.m_142687_(Entity.RemovalReason.DISCARDED);
                return;
            }
        } else if (!(this.haveLeaderMi() && this.f_58857_.m_213780_().m_188503_(40) != 0 || mi.m_6095_() != ModEntities.MI.get())) {
            mi.setPatrolLeader(true);
        }
        if (ent == "Mortar") {
            mi.Objective = "Guard";
            mi.ObjectiveTarget = loc.m_7495_();
            mi.Weapon = "Mortimi";
        }
        mi.m_6518_((ServerLevelAccessor)((ServerLevel)this.f_58857_), this.f_58857_.m_6436_(this.m_58899_()), MobSpawnType.STRUCTURE, null, null);
        ((ServerLevel)this.f_58857_).m_47205_((Entity)mi);
        if (ent == "Plane" && (car = this.getEmptyCarrymi()) != null) {
            mi.m_20329_((Entity)car);
        }
        if (this.LocationID.contains((Object)LocationTypes.SNOWY)) {
            mi.setCosmeticSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_41981_));
            mi.setCosmeticSlot(EquipmentSlot.FEET, new ItemStack((ItemLike)Items.f_42463_));
        }
        if (this.LocationID.contains((Object)LocationTypes.MOUNTAIN) && ent == "Goob") {
            ((EntityGoob)mi).setMountainGoob();
        }
        mi.m_21373_();
    }

    public void construction() {
        block58: {
            RandomSource r;
            Level w;
            block57: {
                int Goes = 1;
                w = this.f_58857_;
                r = w.m_213780_();
                int miny = 0;
                int may = 5;
                if (this.Tier > 0) {
                    may = 8;
                }
                if (this.Type == 2) {
                    miny = -1;
                }
                for (int iy = miny; iy < may; ++iy) {
                    for (int ix = -3; ix < 4; ++ix) {
                        for (int iz = -3; iz < 4; ++iz) {
                            BlockPos min = this.m_58899_().m_7918_(ix, iy, iz);
                            int build = this.targetBuild(ix, iy, iz);
                            if (build > 0) {
                                if (build > 1) {
                                    --Goes;
                                }
                            } else if (this.shouldMine(min, iy)) {
                                --Goes;
                                if (!w.m_8055_(min).m_60713_(Blocks.f_50016_) && this.Done) {
                                    w.m_46961_(min, true);
                                    w.m_7731_(min, Blocks.f_50016_.m_49966_(), 3);
                                } else if (iy == miny) {
                                    w.m_7731_(min, this.convertedBlock((Block)ModBlocks.MISTRUM_BRICK.get()).m_49966_(), 3);
                                } else if (Math.abs(ix) == 3 && Math.abs(iz) == 3) {
                                    w.m_7731_(min, this.convertedBlock((Block)ModBlocks.MITREAN_LOG.get()).m_49966_(), 3);
                                } else if (iy == 4) {
                                    if (this.Tier > 0) {
                                        w.m_7731_(min, this.convertedBlock((Block)ModBlocks.MITREAN_PLANKS.get()).m_49966_(), 3);
                                    } else {
                                        w.m_7731_(min, this.convertedBlock((Block)ModBlocks.MITREAN_PLANKS_SLAB.get()).m_49966_(), 3);
                                    }
                                } else if (iy == 7 && (Math.abs(ix) == 3 || Math.abs(iz) == 3)) {
                                    w.m_7731_(min, this.convertedBlock((Block)ModBlocks.MISTRUM_BRICK_SLAB.get()).m_49966_(), 3);
                                } else if (!w.m_8055_(min).m_60713_(Blocks.f_50016_) && (w.m_6425_(min).m_76170_() || w.m_6425_(min).m_76178_())) {
                                    w.m_7731_(min, Blocks.f_50016_.m_49966_(), 3);
                                } else {
                                    ++Goes;
                                }
                            }
                            if (Goes >= 1) continue;
                            return;
                        }
                    }
                }
                if (this.Done) break block57;
                boolean PillarScan = true;
                int i = 0;
                while (PillarScan) {
                    PillarScan = false;
                    if (this.m_58899_().m_6630_(--i).m_123342_() < 10 || i < -9) {
                        i = 0;
                        break;
                    }
                    if (!w.m_8055_(this.m_58899_().m_7918_(-3, i, -3)).m_60767_().m_76337_()) {
                        PillarScan = true;
                        continue;
                    }
                    if (!w.m_8055_(this.m_58899_().m_7918_(3, i, -3)).m_60767_().m_76337_()) {
                        PillarScan = true;
                        continue;
                    }
                    if (!w.m_8055_(this.m_58899_().m_7918_(-3, i, 3)).m_60767_().m_76337_()) {
                        PillarScan = true;
                        continue;
                    }
                    if (w.m_8055_(this.m_58899_().m_7918_(3, i, 3)).m_60767_().m_76337_()) continue;
                    PillarScan = true;
                }
                for (int down = 1; down < -i; ++down) {
                    if (!w.m_8055_(this.m_58899_().m_7918_(-3, -down, -3)).m_60767_().m_76337_()) {
                        w.m_7731_(this.m_58899_().m_7918_(-3, -down, -3), this.convertedBlock((Block)ModBlocks.MISTRUM_PILLAR.get()).m_49966_(), 3);
                    }
                    if (!w.m_8055_(this.m_58899_().m_7918_(3, -down, -3)).m_60767_().m_76337_()) {
                        w.m_7731_(this.m_58899_().m_7918_(3, -down, -3), this.convertedBlock((Block)ModBlocks.MISTRUM_PILLAR.get()).m_49966_(), 3);
                    }
                    if (!w.m_8055_(this.m_58899_().m_7918_(-3, -down, 3)).m_60767_().m_76337_()) {
                        w.m_7731_(this.m_58899_().m_7918_(-3, -down, 3), this.convertedBlock((Block)ModBlocks.MISTRUM_PILLAR.get()).m_49966_(), 3);
                    }
                    if (w.m_8055_(this.m_58899_().m_7918_(3, -down, 3)).m_60767_().m_76337_()) continue;
                    w.m_7731_(this.m_58899_().m_7918_(3, -down, 3), this.convertedBlock((Block)ModBlocks.MISTRUM_PILLAR.get()).m_49966_(), 3);
                }
                if (!this.DocksDone) {
                    PillarScan = true;
                    i = 1;
                    while (PillarScan && i > -3) {
                        PillarScan = false;
                        BlockPos po = this.m_58899_().m_7918_(-4, --i, -2 - i);
                        if (!w.m_8055_(po).m_60767_().m_76337_()) {
                            PillarScan = true;
                            w.m_7731_(po, this.convertedBlock((Block)ModBlocks.MISTRUM_CHISELED.get()).m_49966_(), 3);
                        }
                        if (!w.m_8055_(po = this.m_58899_().m_7918_(4, i, 2 + i)).m_60767_().m_76337_()) {
                            PillarScan = true;
                            w.m_7731_(po, this.convertedBlock((Block)ModBlocks.MISTRUM_CHISELED.get()).m_49966_(), 3);
                        }
                        if (!w.m_8055_(po = this.m_58899_().m_7918_(-2 - i, i, 4)).m_60767_().m_76337_()) {
                            PillarScan = true;
                            w.m_7731_(po, this.convertedBlock((Block)ModBlocks.MISTRUM_CHISELED.get()).m_49966_(), 3);
                        }
                        if (w.m_8055_(po = this.m_58899_().m_7918_(2 + i, i, -4)).m_60767_().m_76337_()) continue;
                        PillarScan = true;
                        w.m_7731_(po, this.convertedBlock((Block)ModBlocks.MISTRUM_CHISELED.get()).m_49966_(), 3);
                    }
                }
                BlockPos po = null;
                switch (this.Type) {
                    case 1: {
                        int bix;
                        po = null;
                        for (int mt = 0; mt < 4; ++mt) {
                            bix = 1 + r.m_188503_(2);
                            int biz = 1 + r.m_188503_(2);
                            if (r.m_188499_()) {
                                bix *= -1;
                            }
                            if (r.m_188499_()) {
                                biz *= -1;
                            }
                            po = this.m_58899_().m_7918_(bix, 5, biz);
                            w.m_7731_(po, this.convertedBlock((Block)ModBlocks.MITREAN_CORE.get()).m_49966_(), 3);
                        }
                        break block58;
                    }
                    case 2: {
                        int bix;
                        po = null;
                        for (int mt = 0; mt < 4; ++mt) {
                            bix = 1 + r.m_188503_(2);
                            int biz = 1 + r.m_188503_(2);
                            if (r.m_188499_()) {
                                bix *= -1;
                            }
                            if (r.m_188499_()) {
                                biz *= -1;
                            }
                            po = this.m_58899_().m_7918_(bix, 0, biz);
                            w.m_7731_(po.m_6630_(5), this.convertedBlock((Block)ModBlocks.MISTRUMORE.get()).m_49966_(), 3);
                        }
                        break block58;
                    }
                    case 3: {
                        po = this.m_58899_().m_7918_(0, 8, 0);
                        w.m_7731_(po, this.convertedBlock((Block)ModBlocks.MISTRUM_PILLAR.get()).m_49966_(), 3);
                        po = this.m_58899_().m_7918_(0, 9, 0);
                        w.m_7731_(po, this.convertedBlock((Block)ModBlocks.MISTRUM_PILLAR.get()).m_49966_(), 3);
                        po = this.m_58899_().m_7918_(0, 10, 0);
                        this.GoMi("Turret", po, "", r);
                        break;
                    }
                    case 9: {
                        int bix;
                        po = null;
                        for (int mt = 0; mt < 2; ++mt) {
                            bix = 0 + r.m_188503_(2);
                            int biz = 0 + r.m_188503_(2);
                            if (r.m_188499_()) {
                                bix *= -1;
                            }
                            if (r.m_188499_()) {
                                biz *= -1;
                            }
                            if (!w.m_8055_(po = this.m_58899_().m_7918_(bix, 5, biz)).m_60713_(this.convertedBlock((Block)ModBlocks.MISTRUM_PILLAR.get()))) {
                                w.m_7731_(po, this.convertedBlock((Block)ModBlocks.MISTRUM_PILLAR.get()).m_49966_(), 3);
                                this.GoMi("Mortar", po.m_7494_(), "", r);
                                continue;
                            }
                            --mt;
                        }
                        break block58;
                    }
                    case 14: {
                        po = this.m_58899_().m_7918_(0, 7, 0);
                        this.GoMi("Carrymi", po, "", r);
                    }
                }
                break block58;
            }
            if (this.Type == 3) {
                this.fixTurret(r, w);
            } else if (this.Type == 9) {
                this.fixMortar(r, w);
            }
        }
        this.Done = true;
    }

    private boolean shouldMine(BlockPos p, int y) {
        BlockState s = this.f_58857_.m_8055_(p);
        if (s.m_60713_(Blocks.f_50016_)) {
            return true;
        }
        if (s.m_60713_(this.convertedBlock((Block)ModBlocks.MI_CORE.get()))) {
            return false;
        }
        if (s.m_60713_(this.convertedBlock((Block)ModBlocks.MISTRUM_BRICK.get()))) {
            return false;
        }
        if (s.m_60713_(this.convertedBlock((Block)ModBlocks.MISTRUM_BRICK_SLAB.get()))) {
            return false;
        }
        if (s.m_60713_(this.convertedBlock((Block)ModBlocks.MITREAN_PLANKS.get()))) {
            return false;
        }
        if (s.m_60713_(this.convertedBlock((Block)ModBlocks.MITREAN_PLANKS_SLAB.get())) && this.Type == 0) {
            return false;
        }
        if (s.m_60713_(this.convertedBlock((Block)ModBlocks.MISTRUM_DARKBRICK.get()))) {
            return false;
        }
        if (s.m_60713_(this.convertedBlock((Block)ModBlocks.MISTRUM_DARKBRICK_SLAB.get()))) {
            return false;
        }
        if (s.m_60713_(this.convertedBlock((Block)ModBlocks.MISTRUM_PILLAR.get()))) {
            return false;
        }
        if (s.m_60713_(this.convertedBlock((Block)ModBlocks.MISTRUM_CHISELED.get()))) {
            return false;
        }
        if (s.m_60713_(this.convertedBlock((Block)ModBlocks.MITREAN_GLASS.get()))) {
            return false;
        }
        if (s.m_60713_(this.convertedBlock((Block)ModBlocks.MITREAN_LOG.get()))) {
            return false;
        }
        if (s.m_60713_(this.convertedBlock((Block)ModBlocks.MISTRUM_GRASS.get()))) {
            return false;
        }
        if (s.m_60713_(this.convertedBlock((Block)ModBlocks.MITREAN_CORE.get()))) {
            return false;
        }
        if (s.m_60713_(this.convertedBlock((Block)ModBlocks.MISTRUMORE.get()))) {
            return false;
        }
        if (s.m_60713_(this.convertedBlock((Block)ModBlocks.METALLIUM_PLATING.get()))) {
            return false;
        }
        return !s.m_60713_(Blocks.f_50683_) || this.isDaytime();
    }

    private boolean isDaytime() {
        return this.f_58857_.m_46461_() || this.f_58857_.m_6042_().m_63967_();
    }

    private int targetBlock(Level w, BlockPos po, Block b) {
        if (!w.m_8055_(po).m_60713_(b)) {
            w.m_7731_(po, b.m_49966_(), 3);
            return 2;
        }
        return 1;
    }

    private void checkFriends() {
        for (EntityMi mi : this.nearbyAllMi()) {
            if (this.friends.contains((Object)mi)) continue;
            this.friends.add(mi);
        }
        ArrayList<EntityMi> copy = new ArrayList<EntityMi>(this.friends);
        for (EntityMi mi : copy) {
            if (!mi.m_21224_()) continue;
            this.friends.remove((Object)mi);
        }
    }

    private int targetBuild(int ix, int iy, int iz) {
        Level w = this.f_58857_;
        BlockPos min = this.m_58899_().m_7918_(ix, iy, iz);
        if (w.m_8055_(min).m_60713_(this.convertedBlock((Block)ModBlocks.MI_CORE.get()))) {
            return 1;
        }
        if (w.m_8055_(min.m_7495_()).m_60713_(this.convertedBlock((Block)ModBlocks.MI_CORE.get())) && this.isDaytime()) {
            return this.targetBlock(w, min, Blocks.f_50016_);
        }
        if (this.Tier > 0) {
            int i = 0;
            int k = this.Tier;
            while (i < 3) {
                BlockPos po = null;
                po = k == 1 ? this.m_58899_().m_7918_(-3, i, -3 + i) : (k == 2 ? this.m_58899_().m_7918_(3, i, 3 - i) : (k == 3 ? this.m_58899_().m_7918_(-3 + i, i, 3) : this.m_58899_().m_7918_(3 - ++i, i, -3)));
                if (ix != po.m_123341_() - this.m_58899_().m_123341_() || iz != po.m_123343_() - this.m_58899_().m_123343_()) continue;
                if (iy == i) {
                    w.m_7731_(po.m_6630_(4 - i), Blocks.f_50016_.m_49966_(), 3);
                    w.m_7731_(po.m_6630_(5 - i), Blocks.f_50016_.m_49966_(), 3);
                    return this.targetBlock(w, po, this.convertedBlock((Block)ModBlocks.MISTRUM_CHISELED.get()));
                }
                if (iy == i - 1 && i == 2) {
                    return this.targetBlock(w, po.m_7495_(), this.convertedBlock((Block)ModBlocks.MISTRUM_CHISELED.get()));
                }
                if (iy != 4 && iy != 5) continue;
                return this.targetBlock(w, po.m_6630_(iy - i), Blocks.f_50016_);
            }
        }
        switch (this.Type) {
            case 1: {
                if (iy != 5 || Math.abs(ix) != 3 && Math.abs(iz) != 3) break;
                return this.targetBlock(w, min, this.convertedBlock((Block)ModBlocks.MISTRUM_BRICK.get()));
            }
            case 2: {
                if (iy != 0 || Math.abs(ix) >= 3 || Math.abs(iz) >= 3) break;
                if (!w.m_8055_(min).m_60713_(this.convertedBlock((Block)ModBlocks.MISTRUM_ROCK.get()))) {
                    return this.targetBlock(w, min, Blocks.f_50016_);
                }
                return 1;
            }
            case 3: {
                if (iy > 4 && Math.abs(ix) < 1 && Math.abs(iz) < 1) {
                    return this.targetBlock(w, min, this.convertedBlock((Block)ModBlocks.MISTRUM_PILLAR.get()));
                }
                if (iy != 5 || Math.abs(ix) != 3 && Math.abs(iz) != 3) break;
                return this.targetBlock(w, min, this.convertedBlock((Block)ModBlocks.MISTRUM_PILLAR.get()));
            }
            case 4: {
                if (iy == 5 && Math.abs(ix) < 2 && Math.abs(iz) < 2) {
                    return this.targetBlock(w, min, this.convertedBlock((Block)ModBlocks.MISTRUM_GRASS.get()));
                }
                if (iy != 5 || Math.abs(ix) >= 3 || Math.abs(iz) >= 3) break;
                return this.targetBlock(w, min, this.convertedBlock((Block)ModBlocks.MISTRUM_DARKBRICK_SLAB.get()));
            }
            case 5: {
                if (iy == 5 && Math.abs(ix) < 2 && Math.abs(iz) < 2) {
                    return this.targetBlock(w, min, this.convertedBlock((Block)ModBlocks.MISTRUM_GRASS.get()));
                }
                if (iy != 5 || Math.abs(ix) >= 3 || Math.abs(iz) >= 3) break;
                return this.targetBlock(w, min, this.convertedBlock((Block)ModBlocks.MISTRUM_BRICK_SLAB.get()));
            }
            case 6: {
                if (iy == 6 && Math.abs(ix) < 1 && Math.abs(iz) < 1) {
                    return this.targetBlock(w, min, Blocks.f_50489_);
                }
                if (iy != 5 || Math.abs(ix) >= 2 || Math.abs(iz) >= 2) break;
                return this.targetBlock(w, min, Blocks.f_50259_);
            }
            case 7: {
                if (iy != 4 || Math.abs(ix) >= 2 || Math.abs(iz) >= 2) break;
                return this.targetBlock(w, min, this.convertedBlock((Block)ModBlocks.METALLIUM_PLATING.get()));
            }
            case 8: {
                if (iy != 5 || Math.abs(ix) >= 2 || Math.abs(iz) >= 2) break;
                return this.targetBlock(w, min, this.convertedBlock((Block)ModBlocks.MISTRUM_CHISELED.get()));
            }
            case 9: {
                break;
            }
            case 10: {
                if (iy != 4 || Math.abs(ix) >= 3 || Math.abs(iz) >= 3) break;
                return this.targetBlock(w, min, this.convertedBlock((Block)ModBlocks.MISTRUM_PILLAR.get()));
            }
            case 11: {
                if (iy > 4 && (Math.abs(ix) == 3 || Math.abs(iz) == 3)) {
                    return this.targetBlock(w, min, this.convertedBlock((Block)ModBlocks.MITREAN_GLASS.get()));
                }
                if (iy != 4 || Math.abs(ix) >= 2 || Math.abs(iz) >= 2) break;
                return this.targetBlock(w, min, this.convertedBlock((Block)ModBlocks.METALLIUM_PLATING.get()));
            }
            case 12: {
                if (iy > 4 && (Math.abs(ix) == 3 || Math.abs(iz) == 3)) {
                    return this.targetBlock(w, min, Blocks.f_50378_);
                }
                if (iy != 4 || Math.abs(ix) >= 3 || Math.abs(iz) >= 3) break;
                return this.targetBlock(w, min, this.convertedBlock((Block)ModBlocks.METALLIUM_PLATING.get()));
            }
            case 13: {
                if (iy != 4 && iy != 0 || Math.abs(ix) >= 3 || Math.abs(iz) >= 3) break;
                return this.targetBlock(w, min, this.convertedBlock((Block)ModBlocks.MIRIDIUM_PLATING.get()));
            }
            case 14: {
                if (iy > 4 && (Math.abs(ix) == 3 || Math.abs(iz) == 3)) {
                    return this.targetBlock(w, min, this.convertedBlock((Block)ModBlocks.MITREAN_GLASS.get()));
                }
                if (iy != 4 && iy != 0 || Math.abs(ix) >= 3 || Math.abs(iz) >= 3) break;
                return this.targetBlock(w, min, this.convertedBlock((Block)ModBlocks.MIRIDIUM_PLATING.get()));
            }
            case 15: {
                if (iy != 4 && iy != 0 || Math.abs(ix) >= 3 || Math.abs(iz) >= 3) break;
                return this.targetBlock(w, min, this.convertedBlock((Block)ModBlocks.INFERMIUM_PLATING.get()));
            }
            case 16: {
                if (iy != 4 && iy != 0 || Math.abs(ix) >= 3 || Math.abs(iz) >= 3) break;
                return this.targetBlock(w, min, this.convertedBlock((Block)ModBlocks.ENDIMIUM_PLATING.get()));
            }
            case 20: {
                if (iy > 4 && (Math.abs(ix) == 3 || Math.abs(iz) == 3)) {
                    return this.targetBlock(w, min, Blocks.f_50378_);
                }
                if (iy != 0 && iy != 4 || Math.abs(ix) >= 3 || Math.abs(iz) >= 3) break;
                return this.targetBlock(w, min, this.convertedBlock((Block)ModBlocks.MITREAN_GLASS.get()));
            }
        }
        switch (this.VarType) {
            case 1: {
                if (iy != 0 || Math.abs(ix) >= 2 || Math.abs(iz) >= 2) break;
                return this.targetBlock(w, min, this.convertedBlock((Block)ModBlocks.MISTRUM_GRASS.get()));
            }
            case 2: {
                if (Math.abs(ix) + Math.abs(iz) <= 5) break;
                return this.targetBlock(w, min, this.convertedBlock((Block)ModBlocks.MISTRUM_PILLAR.get()));
            }
            case 3: {
                if (iy == 0) {
                    return this.targetBlock(w, min, this.convertedBlock((Block)ModBlocks.MISTRUM_CHISELED.get()));
                }
                if (iy != 4 || Math.abs(ix) != 3 && Math.abs(iz) != 3) break;
                if (this.Tier > 0) {
                    return this.targetBlock(w, min, this.convertedBlock((Block)ModBlocks.MISTRUM_BRICK.get()));
                }
                return this.targetBlock(w, min, this.convertedBlock((Block)ModBlocks.MISTRUM_BRICK_SLAB.get()));
            }
            case 4: {
                if (iy == 0) {
                    return this.targetBlock(w, min, this.convertedBlock((Block)ModBlocks.MISTRUM_DARKBRICK.get()));
                }
                if (iy != 4 || Math.abs(ix) != 3 && Math.abs(iz) != 3) break;
                if (this.Tier > 0) {
                    return this.targetBlock(w, min, this.convertedBlock((Block)ModBlocks.MISTRUM_DARKBRICK.get()));
                }
                return this.targetBlock(w, min, this.convertedBlock((Block)ModBlocks.MISTRUM_DARKBRICK_SLAB.get()));
            }
            case 5: {
                if (iy == 0) {
                    return this.targetBlock(w, min, this.convertedBlock((Block)ModBlocks.MITREAN_PLANKS.get()));
                }
                if (iy != 4 || Math.abs(ix) != 3 && Math.abs(iz) != 3) break;
                if (this.Tier > 0) {
                    return this.targetBlock(w, min, this.convertedBlock((Block)ModBlocks.MITREAN_PLANKS.get()));
                }
                return this.targetBlock(w, min, this.convertedBlock((Block)ModBlocks.MITREAN_PLANKS_SLAB.get()));
            }
        }
        return 0;
    }

    public void destroySelf() {
        Level w = this.f_58857_;
        boolean PillarScan = true;
        int i = 0;
        while (PillarScan) {
            PillarScan = false;
            if (w.m_8055_(this.m_58899_().m_7918_(-3, --i, -3)).m_60713_(this.convertedBlock((Block)ModBlocks.MISTRUM_PILLAR.get()))) {
                PillarScan = true;
                w.m_7731_(this.m_58899_().m_7918_(-3, i, -3), this.convertedBlock((Block)ModBlocks.MI_SCAFFOLDING.get()).m_49966_(), 3);
            }
            if (w.m_8055_(this.m_58899_().m_7918_(3, i, -3)).m_60713_(this.convertedBlock((Block)ModBlocks.MISTRUM_PILLAR.get()))) {
                PillarScan = true;
                w.m_7731_(this.m_58899_().m_7918_(3, i, -3), this.convertedBlock((Block)ModBlocks.MI_SCAFFOLDING.get()).m_49966_(), 3);
            }
            if (w.m_8055_(this.m_58899_().m_7918_(-3, i, 3)).m_60713_(this.convertedBlock((Block)ModBlocks.MISTRUM_PILLAR.get()))) {
                PillarScan = true;
                w.m_7731_(this.m_58899_().m_7918_(-3, i, 3), this.convertedBlock((Block)ModBlocks.MI_SCAFFOLDING.get()).m_49966_(), 3);
            }
            if (!w.m_8055_(this.m_58899_().m_7918_(3, i, 3)).m_60713_(this.convertedBlock((Block)ModBlocks.MISTRUM_PILLAR.get()))) continue;
            PillarScan = true;
            w.m_7731_(this.m_58899_().m_7918_(3, i, 3), this.convertedBlock((Block)ModBlocks.MI_SCAFFOLDING.get()).m_49966_(), 3);
        }
        PillarScan = true;
        i = 1;
        while (PillarScan) {
            PillarScan = false;
            BlockPos po = this.m_58899_().m_7918_(-4, --i, -2 - i);
            if (w.m_8055_(po).m_60713_(this.convertedBlock((Block)ModBlocks.MISTRUM_CHISELED.get()))) {
                PillarScan = true;
                w.m_7731_(po, this.convertedBlock((Block)ModBlocks.MI_SCAFFOLDING.get()).m_49966_(), 3);
            }
            if (w.m_8055_(po = this.m_58899_().m_7918_(4, i, 2 + i)).m_60713_(this.convertedBlock((Block)ModBlocks.MISTRUM_CHISELED.get()))) {
                PillarScan = true;
                w.m_7731_(po, this.convertedBlock((Block)ModBlocks.MI_SCAFFOLDING.get()).m_49966_(), 3);
            }
            if (w.m_8055_(po = this.m_58899_().m_7918_(-2 - i, i, 4)).m_60713_(this.convertedBlock((Block)ModBlocks.MISTRUM_CHISELED.get()))) {
                PillarScan = true;
                w.m_7731_(po, this.convertedBlock((Block)ModBlocks.MI_SCAFFOLDING.get()).m_49966_(), 3);
            }
            if (!w.m_8055_(po = this.m_58899_().m_7918_(2 + i, i, -4)).m_60713_(this.convertedBlock((Block)ModBlocks.MISTRUM_CHISELED.get()))) continue;
            PillarScan = true;
            w.m_7731_(po, this.convertedBlock((Block)ModBlocks.MI_SCAFFOLDING.get()).m_49966_(), 3);
        }
        BlockPos pew = this.m_58899_();
        int lo = 0;
        int hei = 5;
        if (this.Tier > 0) {
            hei = 8;
        }
        if (this.Type == 2) {
            lo = -1;
        }
        for (int rr = 0; rr < 7; ++rr) {
            for (int rr2 = lo; rr2 < hei; ++rr2) {
                for (int rr3 = 0; rr3 < 7; ++rr3) {
                    pew = this.m_58899_().m_7918_(rr - 3, rr2, rr3 - 3);
                    if (this.m_58899_() == pew || w.m_8055_(pew) == Blocks.f_50016_.m_49966_()) continue;
                    w.m_7731_(pew, this.convertedBlock((Block)ModBlocks.MI_SCAFFOLDING.get()).m_49966_(), 3);
                }
            }
        }
        if (this.Type == 3) {
            pew = this.m_58899_().m_7918_(0, 8, 0);
            w.m_7731_(pew, ((Block)ModBlocks.MI_SCAFFOLDING.get()).m_49966_(), 3);
            pew = this.m_58899_().m_7918_(0, 9, 0);
            w.m_7731_(pew, ((Block)ModBlocks.MI_SCAFFOLDING.get()).m_49966_(), 3);
        }
        if (this.calculateHonor() > 0.0) {
            this.addHonor(-25.0 * (1.0 / (Double)MiCon.MI_DIPLOMACY_LENIENCY.get()));
        }
    }

    public void transferCore() {
        List<TileEntityCore> corl = this.nearbyColony();
        corl.remove((Object)this);
        if (!corl.isEmpty()) {
            TileEntityCore cor = corl.get(0);
            cor.Center = true;
            cor.Resources = this.Resources;
            cor.Phase = this.Phase;
            cor.CoreLevel = this.CoreLevel;
            cor.BaseType = this.BaseType;
            cor.defenseTurrets = this.defenseTurrets;
            cor.miniStructures = this.miniStructures;
            cor.StructureAdds = this.StructureAdds;
            cor.bridgeBlocks = this.bridgeBlocks;
            cor.defenseBlocks = this.defenseBlocks;
            cor.mines = this.mines;
            cor.outposts = this.outposts;
            cor.outpost_candidates = this.outpost_candidates;
            cor.build_candidates = this.build_candidates;
            cor.Docks = this.Docks;
            cor.owner = this.owner;
            cor.isTubian = this.isTubian;
            cor.TubianTunnels = this.TubianTunnels;
            cor.SecurityPoints = this.SecurityPoints;
        }
    }

    private void fixMortar(RandomSource r, Level w) {
        if (this.nearbyEnemy()) {
            return;
        }
        if (this.nearbyMortimi()) {
            return;
        }
        TileEntityCore cor = this.getCenter();
        if (cor == null) {
            return;
        }
        if (cor.Resources < 50 || cor.friends.isEmpty()) {
            return;
        }
        cor.spendResources(50.0f);
        BlockPos po = null;
        for (int mt = 0; mt < 3; ++mt) {
            int bix = 0 + r.m_188503_(2);
            int biz = 0 + r.m_188503_(2);
            if (r.m_188499_()) {
                bix *= -1;
            }
            if (r.m_188499_()) {
                biz *= -1;
            }
            po = this.m_58899_().m_7918_(bix, 5, biz);
            w.m_7731_(po, this.convertedBlock((Block)ModBlocks.MITOPIUM_MORTAR.get()).m_49966_(), 3);
            this.GoMi("Mortar", po.m_7494_(), "", r);
        }
    }

    private boolean nearbyMortimi() {
        int k = this.f_58858_.m_123341_();
        int l = this.f_58858_.m_123342_() + 5;
        int i1 = this.f_58858_.m_123343_();
        AABB axisalignedbb = new AABB((double)k, (double)l, (double)i1, (double)(k + 1), (double)(l + 1), (double)(i1 + 1)).m_82377_(8.0, 8.0, 8.0);
        List list = this.f_58857_.m_45976_(EntityMi.class, axisalignedbb);
        ArrayList list2 = new ArrayList(list);
        for (EntityMi mi : list2) {
            if (mi.Weapon == "Mortimi") continue;
            list.remove((Object)mi);
        }
        return !list.isEmpty();
    }

    private void fixTurret(RandomSource r, Level w) {
        if (this.nearbyEnemy()) {
            return;
        }
        if (this.nearbyTurret()) {
            return;
        }
        TileEntityCore cor = this.getCenter();
        if (cor == null) {
            return;
        }
        if (cor.Resources < 50 || cor.friends.isEmpty()) {
            return;
        }
        cor.spendResources(50.0f);
        BlockPos po = this.m_58899_().m_7918_(0, 10, 0);
        this.GoMi("Turret", po, "", r);
    }

    private boolean nearbyTurret() {
        int i1;
        int l;
        int k = this.f_58858_.m_123341_();
        AABB axisalignedbb = new AABB((double)k, (double)(l = this.f_58858_.m_123342_() + 10), (double)(i1 = this.f_58858_.m_123343_()), (double)(k + 1), (double)(l + 1), (double)(i1 + 1)).m_82377_(4.0, 4.0, 4.0);
        List list = this.f_58857_.m_45976_(EntityTonkTurret.class, axisalignedbb);
        return !list.isEmpty();
    }

    private List<TileEntityCore> nearbyColony() {
        List list = this.f_58857_.f_151512_;
        ArrayList<TileEntityCore> list2 = new ArrayList<TileEntityCore>();
        for (TickingBlockEntity mi : list) {
            double d;
            if (!mi.m_142280_().equals("mialliance:core") || !((d = mi.m_142689_().m_123331_(new Vec3i(this.m_58899_().m_123341_(), mi.m_142689_().m_123342_(), this.m_58899_().m_123343_()))) < 9216.0) && !this.outposts.contains(mi.m_142689_())) continue;
            list2.add((TileEntityCore)this.f_58857_.m_7702_(mi.m_142689_()));
        }
        return list2;
    }

    private List<TileEntityCore> getTechs(List<TileEntityCore> list, int target) {
        ArrayList<TileEntityCore> list2 = new ArrayList<TileEntityCore>();
        for (TileEntityCore mi : list) {
            if (mi.Type <= 0 || target != 0 && mi.StructureAdds != target) continue;
            list2.add(mi);
        }
        return list2;
    }

    private boolean haveTechSpecific(List<TileEntityCore> list, int target) {
        for (TileEntityCore mi : list) {
            if (mi.Type != target) continue;
            return true;
        }
        return false;
    }

    private List<TileEntityCore> nearbyColonyPurpose() {
        List list = this.f_58857_.f_151512_;
        ArrayList<TileEntityCore> list2 = new ArrayList<TileEntityCore>();
        for (TickingBlockEntity mi : list) {
            if (mi == null || mi.m_142689_() == null) continue;
            double d = mi.m_142689_().m_123331_(new Vec3i(this.m_58899_().m_123341_(), mi.m_142689_().m_123342_(), this.m_58899_().m_123343_()));
            if (!mi.m_142280_().equals("mialliance:core") || !(d < 5041.0) || ((TileEntityCore)this.f_58857_.m_7702_((BlockPos)mi.m_142689_())).Type != 0) continue;
            list2.add((TileEntityCore)this.f_58857_.m_7702_(mi.m_142689_()));
        }
        return list2;
    }

    private List<TileEntityCore> nearbyColonyExpand() {
        List list = this.f_58857_.f_151512_;
        ArrayList<TileEntityCore> list2 = new ArrayList<TileEntityCore>();
        for (TickingBlockEntity mi : list) {
            double d = mi.m_142689_().m_123331_(new Vec3i(this.m_58899_().m_123341_(), mi.m_142689_().m_123342_(), this.m_58899_().m_123343_()));
            if (!mi.m_142280_().equals("mialliance:core") || !(d < 4096.0) || ((TileEntityCore)this.f_58857_.m_7702_((BlockPos)mi.m_142689_())).DocksDone) continue;
            list2.add((TileEntityCore)this.f_58857_.m_7702_(mi.m_142689_()));
        }
        return list2;
    }

    private List<EntityMi> nearbyMi() {
        int k = this.f_58858_.m_123341_();
        int l = this.f_58858_.m_123342_();
        int i1 = this.f_58858_.m_123343_();
        AABB axisalignedbb = new AABB((double)k, (double)l, (double)i1, (double)(k + 1), (double)(l + 1), (double)(i1 + 1)).m_82377_(80.0, 32.0, 80.0);
        List list = this.f_58857_.m_45976_(EntityMi.class, axisalignedbb);
        List list2 = this.f_58857_.m_45976_(EntityMi.class, axisalignedbb);
        for (EntityMi mi : list) {
            if (mi.Objective == "Colony" && mi.ObjectiveProgress <= 0 && mi.m_6095_() != ModEntities.LOON.get() && mi.m_6095_() != ModEntities.TONK_TURRET.get() && (!this.isTubian() || mi.isTame()) && (this.isTubian() || !mi.isTame())) continue;
            list2.remove((Object)mi);
        }
        return list2;
    }

    private boolean nearbyEnemy() {
        int k = this.f_58858_.m_123341_();
        int l = this.f_58858_.m_123342_();
        int i1 = this.f_58858_.m_123343_();
        AABB axisalignedbb = new AABB((double)k, (double)l, (double)i1, (double)(k + 1), (double)(l + 1), (double)(i1 + 1)).m_82377_(16.0, 8.0, 16.0);
        if (this.isTubian()) {
            List list = this.f_58857_.m_45976_(EntityMi.class, axisalignedbb);
            for (EntityMi mi : list) {
                if (mi.isTame()) continue;
                return true;
            }
            return false;
        }
        List list = this.f_58857_.m_45976_(EntityMi.class, axisalignedbb);
        List list2 = this.f_58857_.m_45976_(Player.class, axisalignedbb);
        for (Object mi : list2) {
            if (mi.m_7500_() || mi.m_5833_()) continue;
            return true;
        }
        for (Object mi : list) {
            if (!mi.isTame()) continue;
            return true;
        }
        return false;
    }

    private List<EntityMi> nearbyAllMi() {
        int k = this.f_58858_.m_123341_();
        int l = this.f_58858_.m_123342_();
        int i1 = this.f_58858_.m_123343_();
        AABB axisalignedbb = new AABB((double)k, (double)l, (double)i1, (double)(k + 1), (double)(l + 1), (double)(i1 + 1)).m_82377_(100.0, 48.0, 100.0);
        List list = this.f_58857_.m_45976_(EntityMi.class, axisalignedbb);
        List list2 = this.f_58857_.m_45976_(EntityMi.class, axisalignedbb);
        for (EntityMi mi : list) {
            if (mi.Objective == "Colony" && mi.m_6095_() != ModEntities.LOON.get() && mi.m_6095_() != ModEntities.TONK_TURRET.get() && (!this.isTubian() || mi.isTame()) && (this.isTubian() || !mi.isTame())) continue;
            list2.remove((Object)mi);
        }
        return list2;
    }

    private boolean haveSpecificMi(EntityType<?> type) {
        int k = this.f_58858_.m_123341_();
        int l = this.f_58858_.m_123342_();
        int i1 = this.f_58858_.m_123343_();
        AABB axisalignedbb = new AABB((double)k, (double)l, (double)i1, (double)(k + 1), (double)(l + 1), (double)(i1 + 1)).m_82377_(200.0, 48.0, 200.0);
        List list = this.f_58857_.m_45976_(EntityMi.class, axisalignedbb);
        for (EntityMi mi : list) {
            if (mi.m_6095_() != type || mi.Objective != "Colony") continue;
            return true;
        }
        return false;
    }

    private boolean haveLeaderMi() {
        int k = this.f_58858_.m_123341_();
        int l = this.f_58858_.m_123342_();
        int i1 = this.f_58858_.m_123343_();
        AABB axisalignedbb = new AABB((double)k, (double)l, (double)i1, (double)(k + 1), (double)(l + 1), (double)(i1 + 1)).m_82377_(200.0, 48.0, 200.0);
        List list = this.f_58857_.m_45976_(EntityMi.class, axisalignedbb);
        for (EntityMi mi : list) {
            if (!mi.isPatrolLeader() || mi.Objective != "Colony") continue;
            return true;
        }
        return false;
    }

    private int haveMiAmount(EntityType<?> type) {
        int k = this.f_58858_.m_123341_();
        int l = this.f_58858_.m_123342_();
        int i1 = this.f_58858_.m_123343_();
        AABB axisalignedbb = new AABB((double)k, (double)l, (double)i1, (double)(k + 1), (double)(l + 1), (double)(i1 + 1)).m_82377_(200.0, 48.0, 200.0);
        List list = this.f_58857_.m_45976_(EntityMi.class, axisalignedbb);
        int i = 0;
        for (EntityMi mi : list) {
            if (mi.m_6095_() != type || mi.Objective != "Colony") continue;
            ++i;
        }
        return i;
    }

    private List<EntityMi> nearbyEquippable() {
        int k = this.f_58858_.m_123341_();
        int l = this.f_58858_.m_123342_();
        int i1 = this.f_58858_.m_123343_();
        AABB axisalignedbb = new AABB((double)k, (double)l, (double)i1, (double)(k + 1), (double)(l + 1), (double)(i1 + 1)).m_82377_(48.0, 16.0, 48.0);
        List list = this.f_58857_.m_45976_(EntityMi.class, axisalignedbb);
        List list2 = this.f_58857_.m_45976_(EntityMi.class, axisalignedbb);
        for (EntityMi mi : list) {
            if (mi.Objective == "Colony" && (!this.isTubian() || mi.isTame()) && (this.isTubian() || !mi.isTame())) continue;
            list2.remove((Object)mi);
        }
        return list2;
    }

    private List<EntityMi> nearbyUnemployed() {
        int k = this.f_58858_.m_123341_();
        int l = this.f_58858_.m_123342_();
        int i1 = this.f_58858_.m_123343_();
        AABB axisalignedbb = new AABB((double)k, (double)l, (double)i1, (double)(k + 1), (double)(l + 1), (double)(i1 + 1)).m_82377_(48.0, 16.0, 48.0);
        List list = this.f_58857_.m_45976_(EntityMi.class, axisalignedbb);
        List list2 = this.f_58857_.m_45976_(EntityMi.class, axisalignedbb);
        ArrayList<BlockPos> poses = new ArrayList<BlockPos>();
        for (EntityMi mi : list) {
            if (mi.Objective != "Colony" || mi.ObjectiveProgress > 0 || mi.ObjectiveTarget == null || mi.isObject() && mi.m_6095_() != ModEntities.TONK.get() || this.isTubian() && !mi.isTame() || !this.isTubian() && mi.isTame()) {
                list2.remove((Object)mi);
                continue;
            }
            if (poses.contains(mi.ObjectiveTarget)) continue;
            list2.remove((Object)mi);
            poses.add(mi.ObjectiveTarget);
        }
        return list2;
    }

    public boolean canBeCaptured() {
        int k = this.f_58858_.m_123341_();
        int l = this.f_58858_.m_123342_() + 5;
        int i1 = this.f_58858_.m_123343_();
        AABB axisalignedbb = new AABB((double)k, (double)l, (double)i1, (double)(k + 1), (double)(l + 1), (double)(i1 + 1)).m_82377_(8.0, 8.0, 8.0);
        List list = this.f_58857_.m_45976_(EntityMi.class, axisalignedbb);
        ArrayList list2 = new ArrayList(list);
        for (EntityMi mi : list2) {
            if (!mi.isTame()) continue;
            list.remove((Object)mi);
        }
        return list.isEmpty();
    }

    public void m_183515_(CompoundTag nb) {
        ListTag nlist2;
        super.m_183515_(nb);
        nb.m_128379_("Center", this.Center);
        nb.m_128379_("Done", this.Done);
        nb.m_128379_("DocksDone", this.DocksDone);
        nb.m_128379_("isTubian", this.isTubian);
        nb.m_128405_("Resources", this.Resources);
        nb.m_128405_("VarType", this.VarType);
        nb.m_128405_("giveColor", this.giveColor);
        nb.m_128405_("CoreLevel", this.CoreLevel);
        nb.m_128405_("BaseType", this.BaseType);
        nb.m_128405_("Type", this.Type);
        nb.m_128405_("Tier", this.Tier);
        nb.m_128405_("StructureAdds", this.StructureAdds);
        nb.m_128405_("Phase", this.Phase);
        nb.m_128405_("Bridges", this.bridgeBlocks);
        nb.m_128405_("Strucs", this.miniStructures);
        nb.m_128405_("Turrets", this.defenseTurrets);
        nb.m_128405_("DefenseBlocks", this.defenseBlocks);
        nb.m_128379_("TubianTunnels", this.TubianTunnels);
        if (this.owner != null) {
            nb.m_128362_("Owner", this.owner);
        }
        if (!this.mines.isEmpty()) {
            nlist2 = new ListTag();
            for (BlockPos pos : this.mines) {
                nlist2.add((Object)NbtUtils.m_129224_((BlockPos)pos));
            }
            nb.m_128365_("Mines", (Tag)nlist2);
        }
        if (!this.outposts.isEmpty()) {
            nlist2 = new ListTag();
            for (BlockPos pos : this.outposts) {
                nlist2.add((Object)NbtUtils.m_129224_((BlockPos)pos));
            }
            nb.m_128365_("Outposts", (Tag)nlist2);
        }
        if (!this.outpost_candidates.isEmpty()) {
            nlist2 = new ListTag();
            for (BlockPos pos : this.outpost_candidates) {
                nlist2.add((Object)NbtUtils.m_129224_((BlockPos)pos));
            }
            nb.m_128365_("Outpost_Candidates", (Tag)nlist2);
        }
        if (!this.build_candidates.isEmpty()) {
            nlist2 = new ListTag();
            for (BlockPos pos : this.build_candidates) {
                nlist2.add((Object)NbtUtils.m_129224_((BlockPos)pos));
            }
            nb.m_128365_("Build_Candidates", (Tag)nlist2);
        }
        if (!this.SecurityPoints.isEmpty()) {
            nlist2 = new ListTag();
            for (BlockPos pos : this.SecurityPoints) {
                nlist2.add((Object)NbtUtils.m_129224_((BlockPos)pos));
            }
            nb.m_128365_("SecurityPoints", (Tag)nlist2);
        }
        if (this.Docks != null) {
            nb.m_128365_("Docks", (Tag)NbtUtils.m_129224_((BlockPos)this.Docks));
        }
    }

    public void m_142466_(CompoundTag nb) {
        int i;
        ListTag nlist2;
        super.m_142466_(nb);
        this.Center = nb.m_128471_("Center");
        this.Done = nb.m_128471_("Done");
        this.isTubian = nb.m_128471_("isTubian");
        this.Resources = nb.m_128451_("Resources");
        this.VarType = nb.m_128451_("VarType");
        this.giveColor = nb.m_128451_("giveColor");
        this.CoreLevel = nb.m_128451_("CoreLevel");
        this.BaseType = nb.m_128451_("BaseType");
        this.Type = nb.m_128451_("Type");
        this.Tier = nb.m_128451_("Tier");
        this.StructureAdds = nb.m_128451_("StructureAdds");
        this.Phase = nb.m_128451_("Phase");
        this.bridgeBlocks = nb.m_128451_("Bridges");
        this.miniStructures = nb.m_128451_("Strucs");
        this.defenseTurrets = nb.m_128451_("Turrets");
        this.defenseBlocks = nb.m_128451_("DefenseBlocks");
        this.TubianTunnels = nb.m_128471_("TubianTunnels");
        if (nb.m_128441_("Owner")) {
            this.owner = nb.m_128342_("Owner");
        }
        if (nb.m_128441_("Mines")) {
            nlist2 = (ListTag)nb.m_128423_("Mines");
            for (i = 0; i < nlist2.size(); ++i) {
                this.mines.add(NbtUtils.m_129239_((CompoundTag)nlist2.m_128728_(i)));
            }
        }
        if (nb.m_128441_("Outposts")) {
            nlist2 = (ListTag)nb.m_128423_("Outposts");
            for (i = 0; i < nlist2.size(); ++i) {
                this.outposts.add(NbtUtils.m_129239_((CompoundTag)nlist2.m_128728_(i)));
            }
        }
        if (nb.m_128441_("Outpost_Candidates")) {
            nlist2 = (ListTag)nb.m_128423_("Outpost_Candidates");
            for (i = 0; i < nlist2.size(); ++i) {
                this.outpost_candidates.add(NbtUtils.m_129239_((CompoundTag)nlist2.m_128728_(i)));
            }
        }
        if (nb.m_128441_("Build_Candidates")) {
            nlist2 = (ListTag)nb.m_128423_("Build_Candidates");
            for (i = 0; i < nlist2.size(); ++i) {
                this.build_candidates.add(NbtUtils.m_129239_((CompoundTag)nlist2.m_128728_(i)));
            }
        }
        if (nb.m_128441_("SecurityPoints")) {
            nlist2 = (ListTag)nb.m_128423_("SecurityPoints");
            for (i = 0; i < nlist2.size(); ++i) {
                this.SecurityPoints.add(NbtUtils.m_129239_((CompoundTag)nlist2.m_128728_(i)));
            }
        }
        this.DocksDone = nb.m_128471_("DocksDone");
        if (nb.m_128441_("Docks")) {
            this.Docks = NbtUtils.m_129239_((CompoundTag)nb.m_128469_("Docks"));
        }
        this.m_6596_();
    }

    private double calculateHonor() {
        List ents = this.f_58857_.f_151512_;
        TileEntityEmbassy hob = null;
        for (TickingBlockEntity bop : ents) {
            if (!bop.m_142280_().equals("mialliance:embassy")) continue;
            hob = (TileEntityEmbassy)this.f_58857_.m_7702_(bop.m_142689_());
            break;
        }
        if (hob == null) {
            return 0.0;
        }
        return hob.pri;
    }

    private void addHonor(double hon) {
        List ents = this.f_58857_.f_151512_;
        for (TickingBlockEntity bop : ents) {
            if (!bop.m_142280_().equals("mialliance:embassy")) continue;
            ((TileEntityEmbassy)this.f_58857_.m_7702_((BlockPos)bop.m_142689_())).pri += hon;
        }
    }

    private void spendResources(float fe) {
        if (this.isTubian()) {
            this.Resources = (int)((double)this.Resources - (double)(fe *= 3.0f) / (Double)MiCon.MI_TUBIAN_GROWTH.get());
            return;
        }
        if (this.CoreLevel == 1) {
            fe *= 3.0f;
        } else if (this.CoreLevel == 0) {
            fe *= 4.0f;
        }
        this.Resources = (int)((double)this.Resources - (double)fe / (Double)MiCon.MI_COLONY_GROWTH.get());
    }

    private void clearWeightMi() {
        this.Mi_Weights = 0;
        this.Mi_WeightTotal = 0;
        this.Mi_ID = new ArrayList<Integer>();
        this.Mi_WeightMin = new ArrayList<Integer>();
    }

    private void addWeightMi(int miID, int miWeight) {
        ++this.Mi_Weights;
        this.Mi_ID.add(miID);
        this.Mi_WeightMin.add(this.Mi_WeightTotal);
        this.Mi_WeightTotal += miWeight;
    }

    private void addWeightMiRecents(int miID, int miWeight) {
        ++this.Mi_Weights;
        this.Mi_ID.add(miID);
        this.Mi_WeightMin.add(this.Mi_WeightTotal);
        this.Mi_WeightTotal += miWeight + this.recents[miID];
        if (this.recents[miID] < 0) {
            int n = miID;
            this.recents[n] = this.recents[n] + 2;
        }
    }

    private int getMi(RandomSource r) {
        int rr = r.m_188503_(this.Mi_WeightTotal);
        for (int i = this.Mi_Weights - 1; i >= 0; --i) {
            if (rr < this.Mi_WeightMin.get(i)) continue;
            return this.Mi_ID.get(i);
        }
        return 0;
    }

    public TileEntityCore getCenter() {
        List<TileEntityCore> col = this.nearbyColony();
        for (TileEntityCore co : col) {
            if (!co.Center) continue;
            return co;
        }
        return null;
    }

    public boolean convertToPlayer(Player pl) {
        TileEntityCore cor = this.getCenter();
        for (TileEntityCore co : this.nearbyColony()) {
            if (co.canBeCaptured()) continue;
            return false;
        }
        if (cor == null) {
            return false;
        }
        cor.isTubian = true;
        for (TileEntityCore co : this.nearbyColony()) {
            co.isTubian = true;
        }
        cor.Resources = 100;
        cor.CoreLevel = 2;
        cor.Terraform = 80;
        cor.owner = pl.m_20148_();
        cor.Goal = 0;
        cor.ConvertCooldown = 15;
        return true;
    }

    public boolean convertToPlayerGuarantee(Player pl) {
        TileEntityCore cor = this;
        cor.Center = true;
        cor.isTubian = true;
        cor.Resources = 100;
        cor.CoreLevel = 2;
        cor.Terraform = 80;
        cor.owner = pl.m_20148_();
        cor.Goal = 0;
        cor.ConvertCooldown = 15;
        return true;
    }

    public boolean convertToMitopia() {
        TileEntityCore cor = this.getCenter();
        if (cor == null) {
            return false;
        }
        cor.isTubian = false;
        for (TileEntityCore co : this.nearbyColony()) {
            co.isTubian = false;
        }
        cor.Resources = 100;
        cor.CoreLevel = 2;
        cor.Terraform = 80;
        cor.Goal = 0;
        return true;
    }

    private void terraformingPulse() {
        int iy;
        if (this.Terraform == 0) {
            return;
        }
        --this.Terraform;
        int disto = 80 - this.Terraform;
        for (int ix = -disto; ix <= disto; ix += disto * 2) {
            for (iy = -16; iy <= 16; ++iy) {
                for (int iz = -disto; iz <= disto; ++iz) {
                    this.Terraform(this.m_58899_().m_7918_(ix, iy, iz));
                }
            }
        }
        for (int iz = -disto; iz <= disto; iz += disto * 2) {
            for (iy = -16; iy <= 16; ++iy) {
                for (int ix = -disto; ix <= disto; ++ix) {
                    this.Terraform(this.m_58899_().m_7918_(ix, iy, iz));
                }
            }
        }
    }

    private void Reconvert() {
        --this.ConvertCooldown;
        if (!this.isTubian() || this.ConvertCooldown > 0) {
            return;
        }
        if (!this.nearbyEnemy() || !this.nearbyAllMi().isEmpty()) {
            return;
        }
        this.convertToMitopia();
    }

    private Block convertedBlock(Block b) {
        if (!this.isTubian()) {
            return b;
        }
        if (b == ModBlocks.MITREAN_LOG.get()) {
            return (Block)ModBlocks.FAMILIAR_LOG.get();
        }
        if (b == ModBlocks.MITREAN_PLANKS.get()) {
            return (Block)ModBlocks.FAMILIAR_PLANKS.get();
        }
        if (b == ModBlocks.MITREAN_PLANKS_SLAB.get()) {
            return (Block)ModBlocks.FAMILIAR_PLANKS_SLAB.get();
        }
        if (b == ModBlocks.MITREAN_TILES.get()) {
            return (Block)ModBlocks.FAMILIAR_TILES.get();
        }
        if (b == ModBlocks.MISTRUM_BRICK.get() || b == ModBlocks.MISTRUM_DARKBRICK.get()) {
            return (Block)ModBlocks.FORGOTTEN_BRICKS.get();
        }
        if (b == ModBlocks.MISTRUM_BRICK_SLAB.get() || b == ModBlocks.MISTRUM_DARKBRICK_SLAB.get()) {
            return (Block)ModBlocks.FORGOTTEN_BRICKS_SLAB.get();
        }
        if (b == ModBlocks.MISTRUM_PILLAR.get()) {
            return (Block)ModBlocks.FORGOTTEN_PILLAR.get();
        }
        if (b == ModBlocks.MISTRUM_CHISELED.get()) {
            return (Block)ModBlocks.FORGOTTEN_ROCK.get();
        }
        if (b == ModBlocks.MITREAN_CORE.get()) {
            return (Block)ModBlocks.FAMILIAR_CORE.get();
        }
        if (b == ModBlocks.MI_BEACON.get() || b == ModBlocks.MI_BEACON_INACTIVE.get()) {
            return (Block)ModBlocks.FRIENDLY_BEACON.get();
        }
        return b;
    }

    private void Terraform(BlockPos po) {
        Level lev = this.f_58857_;
        BlockState st = lev.m_8055_(po);
        if (this.isTubian()) {
            if (st.m_60713_((Block)ModBlocks.MITREAN_LOG.get())) {
                lev.m_7731_(po, ((Block)ModBlocks.FAMILIAR_LOG.get()).m_49966_(), 3);
                return;
            }
            if (st.m_60713_((Block)ModBlocks.MITREAN_PLANKS.get())) {
                lev.m_7731_(po, ((Block)ModBlocks.FAMILIAR_PLANKS.get()).m_49966_(), 3);
                return;
            }
            if (st.m_60713_((Block)ModBlocks.MITREAN_PLANKS_SLAB.get())) {
                lev.m_7731_(po, ((Block)ModBlocks.FAMILIAR_PLANKS_SLAB.get()).m_49966_(), 3);
                return;
            }
            if (st.m_60713_((Block)ModBlocks.MITREAN_TILES.get())) {
                lev.m_7731_(po, ((Block)ModBlocks.FAMILIAR_TILES.get()).m_49966_(), 3);
                return;
            }
            if (st.m_60713_((Block)ModBlocks.MISTRUM_BRICK.get()) || st.m_60713_((Block)ModBlocks.MISTRUM_DARKBRICK.get())) {
                lev.m_7731_(po, ((Block)ModBlocks.FORGOTTEN_BRICKS.get()).m_49966_(), 3);
                return;
            }
            if (st.m_60713_((Block)ModBlocks.MISTRUM_BRICK_SLAB.get()) || st.m_60713_((Block)ModBlocks.MISTRUM_DARKBRICK_SLAB.get())) {
                lev.m_7731_(po, ((Block)ModBlocks.FORGOTTEN_BRICKS_SLAB.get()).m_49966_(), 3);
                return;
            }
            if (st.m_60713_((Block)ModBlocks.MISTRUM_PILLAR.get())) {
                lev.m_7731_(po, ((Block)ModBlocks.FORGOTTEN_PILLAR.get()).m_49966_(), 3);
                return;
            }
            if (st.m_60713_((Block)ModBlocks.MISTRUM_CHISELED.get())) {
                lev.m_7731_(po, ((Block)ModBlocks.FORGOTTEN_ROCK.get()).m_49966_(), 3);
                return;
            }
            if (st.m_60713_((Block)ModBlocks.MI_BEACON.get())) {
                lev.m_7731_(po, Blocks.f_50016_.m_49966_(), 3);
                return;
            }
            if (st.m_60713_((Block)ModBlocks.MITREAN_CORE.get())) {
                lev.m_7731_(po, ((Block)ModBlocks.FAMILIAR_CORE.get()).m_49966_(), 3);
                return;
            }
            if (st.m_60713_((Block)ModBlocks.METALLIUM_MINE.get())) {
                lev.m_7731_(po, Blocks.f_50016_.m_49966_(), 3);
                lev.m_7731_(po.m_7495_(), ((Block)ModBlocks.TUBIAN_SCARSTONE.get()).m_49966_(), 3);
                return;
            }
            if (st.m_60713_((Block)ModBlocks.METALLIUM_BARBS.get())) {
                lev.m_7731_(po, Blocks.f_50016_.m_49966_(), 3);
                lev.m_7731_(po.m_7495_(), ((Block)ModBlocks.TUBIAN_SCARSTONE.get()).m_49966_(), 3);
                return;
            }
            if (st.m_60713_((Block)ModBlocks.MI_BEACON.get()) || st.m_60713_((Block)ModBlocks.MI_BEACON_INACTIVE.get())) {
                lev.m_7731_(po, ((Block)ModBlocks.FRIENDLY_BEACON.get()).m_49966_(), 3);
            }
            return;
        }
        if (st.m_60713_((Block)ModBlocks.FAMILIAR_LOG.get())) {
            lev.m_7731_(po, ((Block)ModBlocks.MITREAN_LOG.get()).m_49966_(), 3);
            return;
        }
        if (st.m_60713_((Block)ModBlocks.FAMILIAR_PLANKS.get())) {
            lev.m_7731_(po, ((Block)ModBlocks.MITREAN_PLANKS.get()).m_49966_(), 3);
            return;
        }
        if (st.m_60713_((Block)ModBlocks.FAMILIAR_PLANKS_SLAB.get())) {
            lev.m_7731_(po, ((Block)ModBlocks.MITREAN_PLANKS_SLAB.get()).m_49966_(), 3);
            return;
        }
        if (st.m_60713_((Block)ModBlocks.FAMILIAR_TILES.get())) {
            lev.m_7731_(po, ((Block)ModBlocks.MITREAN_TILES.get()).m_49966_(), 3);
            return;
        }
        if (st.m_60713_((Block)ModBlocks.FORGOTTEN_BRICKS.get())) {
            lev.m_7731_(po, ((Block)ModBlocks.MISTRUM_BRICK.get()).m_49966_(), 3);
            return;
        }
        if (st.m_60713_((Block)ModBlocks.FORGOTTEN_BRICKS_SLAB.get())) {
            lev.m_7731_(po, ((Block)ModBlocks.MISTRUM_BRICK_SLAB.get()).m_49966_(), 3);
            return;
        }
        if (st.m_60713_((Block)ModBlocks.FORGOTTEN_PILLAR.get())) {
            lev.m_7731_(po, ((Block)ModBlocks.MISTRUM_PILLAR.get()).m_49966_(), 3);
            return;
        }
        if (st.m_60713_((Block)ModBlocks.FORGOTTEN_ROCK.get())) {
            lev.m_7731_(po, ((Block)ModBlocks.MISTRUM_CHISELED.get()).m_49966_(), 3);
            return;
        }
        if (st.m_60713_((Block)ModBlocks.FAMILIAR_CORE.get())) {
            lev.m_7731_(po, ((Block)ModBlocks.MITREAN_CORE.get()).m_49966_(), 3);
            return;
        }
        if (st.m_60713_((Block)ModBlocks.TUBIAN_SCARSTONE.get())) {
            lev.m_7731_(po.m_7494_(), ((Block)ModBlocks.METALLIUM_BARBS.get()).m_49966_(), 3);
            lev.m_7731_(po, ((Block)ModBlocks.MISTRUM_SOIL.get()).m_49966_(), 3);
            return;
        }
        if (st.m_60713_((Block)ModBlocks.FRIENDLY_BEACON.get())) {
            lev.m_7731_(po, ((Block)ModBlocks.MI_BEACON.get()).m_49966_(), 3);
        }
    }

    public boolean isTubian() {
        return this.isTubian;
    }

    private static enum LocationTypes {
        FOREST,
        DESERT,
        SNOWY,
        MOUNTAIN,
        END;

    }
}

