/*
 * Decompiled with CFR 0.152.
 */
package com.mialliance.entities;

import com.mialliance.MiCon;
import com.mialliance.block.ModBlocks;
import com.mialliance.block.TileEntityBeaconInactive;
import com.mialliance.block.TileEntityCore;
import com.mialliance.block.TileEntityEmbassy;
import com.mialliance.block.TileEntityForgottenAltar;
import com.mialliance.entities.EntityMi;
import com.mialliance.entities.EntityPlane;
import com.mialliance.entities.EntityTrain;
import com.mialliance.entities.MiEngineeringGoal;
import com.mialliance.entities.MiWarpsaveGoal;
import com.mialliance.entities.ModEntities;
import com.mialliance.item.ModItems;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.eventbus.api.Event;
import org.slf4j.Logger;

public abstract class EntityPatrollus
extends EntityTrain {
    private BlockPos patrolTarget;
    public boolean patrolLeader;
    public boolean chosen;
    private boolean patrolling;
    protected int patroltime = 1200;
    public int Ammo = 0;
    public int Logistics = 0;
    public String MissionType = "Scout";
    public String Weapon = "";
    public EntityPatrollus leader = null;
    public boolean isStrategist = false;
    public BlockPos flyTarget = null;
    public boolean Greeting = false;
    public boolean Peace = false;
    public int SpecialGadget = 0;
    protected int bringSupplies = 0;
    public int chosenAbility = 0;
    public int chosenAbility2 = 0;
    public long chosenAnnounced;
    public long chosenSummon;
    public long chosenCooldown;
    private static final EntityDataAccessor<Boolean> DATA_ID_CHOSEN = SynchedEntityData.m_135353_(EntityMi.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final Logger LOGGER = LogUtils.getLogger();
    protected boolean isCurrentlyIteratingGoals = false;
    protected MiWarpsaveGoal warpsaveGoal = new MiWarpsaveGoal(this);

    protected EntityPatrollus(EntityType<? extends EntityPatrollus> p_i50201_1_, Level p_i50201_2_) {
        super(p_i50201_1_, p_i50201_2_);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(5, new PatrolGoal<EntityPatrollus>(this, 1.0, 0.85));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_CHOSEN, (Object)false);
    }

    public void setChosen(boolean bo) {
        this.chosen = bo;
        this.f_19804_.m_135381_(DATA_ID_CHOSEN, (Object)bo);
    }

    @Override
    public void m_7380_(CompoundTag p_213281_1_) {
        super.m_7380_(p_213281_1_);
        if (this.patrolTarget != null) {
            p_213281_1_.m_128365_("PatrolTarget", (Tag)NbtUtils.m_129224_((BlockPos)this.patrolTarget));
        }
        if (this.MissionType != null) {
            p_213281_1_.m_128359_("MissionType", this.MissionType);
            switch (this.MissionType) {
                case "Scout": {
                    p_213281_1_.m_128405_("MissionTypeID", 1);
                    break;
                }
                case "Alone": {
                    p_213281_1_.m_128405_("MissionTypeID", 2);
                    break;
                }
                case "Explore": {
                    p_213281_1_.m_128405_("MissionTypeID", 3);
                    break;
                }
                case "Hunt": {
                    p_213281_1_.m_128405_("MissionTypeID", 4);
                    break;
                }
                case "Miners": {
                    p_213281_1_.m_128405_("MissionTypeID", 5);
                    break;
                }
                case "Build": {
                    p_213281_1_.m_128405_("MissionTypeID", 6);
                    break;
                }
                case "Assassinate": {
                    p_213281_1_.m_128405_("MissionTypeID", 7);
                    break;
                }
                case "Structure": {
                    p_213281_1_.m_128405_("MissionTypeID", 8);
                    break;
                }
                case "Message": {
                    p_213281_1_.m_128405_("MissionTypeID", 9);
                    break;
                }
                case "Guardian": {
                    p_213281_1_.m_128405_("MissionTypeID", 10);
                    break;
                }
                case "FighterSquadron": {
                    p_213281_1_.m_128405_("MissionTypeID", 11);
                    break;
                }
                case "Expedition": {
                    p_213281_1_.m_128405_("MissionTypeID", 12);
                    break;
                }
                case "Airstrike": {
                    p_213281_1_.m_128405_("MissionTypeID", 13);
                    break;
                }
                case "Snipers": {
                    p_213281_1_.m_128405_("MissionTypeID", 14);
                    break;
                }
                case "Diplomacy": {
                    p_213281_1_.m_128405_("MissionTypeID", 15);
                    break;
                }
                case "Recon": {
                    p_213281_1_.m_128405_("MissionTypeID", 16);
                    break;
                }
                case "Engineers": {
                    p_213281_1_.m_128405_("MissionTypeID", 17);
                    break;
                }
                default: {
                    p_213281_1_.m_128405_("MissionTypeID", 0);
                    break;
                }
            }
        } else {
            p_213281_1_.m_128359_("MissionType", "None");
        }
        p_213281_1_.m_128379_("PatrolLeader", this.patrolLeader);
        p_213281_1_.m_128379_("Patrolling", this.patrolling);
        p_213281_1_.m_128379_("Chosen", this.chosen);
        p_213281_1_.m_128405_("ChosenAbility", this.chosenAbility);
        p_213281_1_.m_128405_("ChosenAbility2", this.chosenAbility2);
        p_213281_1_.m_128379_("Strategist", this.isStrategist);
        p_213281_1_.m_128379_("Greeting", this.Greeting);
        p_213281_1_.m_128379_("Peace", this.Peace);
        p_213281_1_.m_128405_("bringSupplies", this.bringSupplies);
        p_213281_1_.m_128405_("Ammo", this.Ammo);
        p_213281_1_.m_128405_("Logistics", this.Logistics);
        p_213281_1_.m_128405_("Gadget", this.SpecialGadget);
        if (this.Weapon == "Train") {
            p_213281_1_.m_128379_("Train", true);
        } else {
            p_213281_1_.m_128379_("Train", false);
        }
    }

    @Override
    public void m_7378_(CompoundTag p_70037_1_) {
        super.m_7378_(p_70037_1_);
        if (p_70037_1_.m_128441_("PatrolTarget")) {
            this.patrolTarget = NbtUtils.m_129239_((CompoundTag)p_70037_1_.m_128469_("PatrolTarget"));
        }
        if (p_70037_1_.m_128441_("MissionType")) {
            // empty if block
        }
        if (p_70037_1_.m_128441_("MissionTypeID")) {
            switch (p_70037_1_.m_128451_("MissionTypeID")) {
                case 1: {
                    this.MissionType = "Scout";
                    break;
                }
                case 2: {
                    this.MissionType = "Alone";
                    break;
                }
                case 3: {
                    this.MissionType = "Explore";
                    this.isStrategist = true;
                    break;
                }
                case 4: {
                    this.MissionType = "Hunt";
                    this.isStrategist = true;
                    break;
                }
                case 5: {
                    this.MissionType = "Miners";
                    break;
                }
                case 6: {
                    this.MissionType = "Build";
                    this.isStrategist = true;
                    break;
                }
                case 7: {
                    this.MissionType = "Assassinate";
                    break;
                }
                case 8: {
                    this.MissionType = "Structure";
                    break;
                }
                case 9: {
                    this.MissionType = "Message";
                    break;
                }
                case 10: {
                    this.MissionType = "Guardian";
                    this.isStrategist = true;
                    break;
                }
                case 11: {
                    this.MissionType = "FighterSquadron";
                    break;
                }
                case 12: {
                    this.MissionType = "Expedition";
                    break;
                }
                case 13: {
                    this.MissionType = "Airstrike";
                    break;
                }
                case 14: {
                    this.MissionType = "Snipers";
                    break;
                }
                case 15: {
                    this.MissionType = "Diplomacy";
                    break;
                }
                case 16: {
                    this.MissionType = "Recon";
                    break;
                }
                case 17: {
                    this.MissionType = "Engineers";
                    break;
                }
                default: {
                    this.MissionType = "Scout";
                }
            }
        }
        this.patrolLeader = p_70037_1_.m_128471_("PatrolLeader");
        this.patrolling = p_70037_1_.m_128471_("Patrolling");
        this.chosen = p_70037_1_.m_128471_("Chosen");
        this.chosenAbility = p_70037_1_.m_128451_("ChosenAbility");
        this.chosenAbility2 = p_70037_1_.m_128451_("ChosenAbility2");
        this.isStrategist = p_70037_1_.m_128471_("Strategist");
        this.Greeting = p_70037_1_.m_128471_("Greeting");
        this.Peace = p_70037_1_.m_128471_("Peace");
        this.bringSupplies = p_70037_1_.m_128451_("bringSupplies");
        this.Ammo = p_70037_1_.m_128451_("Ammo");
        this.Logistics = p_70037_1_.m_128451_("Logistics");
        this.SpecialGadget = p_70037_1_.m_128451_("Gadget");
        if (p_70037_1_.m_128441_("Train") && p_70037_1_.m_128471_("Train")) {
            this.Weapon = "Train";
        }
    }

    public boolean canBeLeader() {
        return true;
    }

    public void setCosmeticSlot(EquipmentSlot p_184201_1_, ItemStack p_184201_2_) {
        super.m_8061_(p_184201_1_, p_184201_2_);
    }

    public void InitPatrolLeader() {
        if (this.isPatrolLeader()) {
            if (this.m_7770_() == null && !((EntityMi)this).isObject()) {
                this.m_6593_(this.randomLeaderName());
            }
            boolean tactician = false;
            switch (this.MissionType) {
                case "Explore": {
                    this.setCosmeticSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42664_));
                    this.Ammo = 10;
                    tactician = true;
                    this.isStrategist = true;
                    break;
                }
                case "Hunt": {
                    this.setCosmeticSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42727_));
                    this.Ammo = 0;
                    tactician = true;
                    this.isStrategist = true;
                    break;
                }
                case "Message": {
                    this.setCosmeticSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42660_));
                    this.Peace = true;
                    break;
                }
                case "Diplomacy": {
                    this.setCosmeticSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42660_));
                    this.Peace = true;
                    break;
                }
                case "Build": {
                    this.setCosmeticSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42671_));
                    this.Ammo = 1;
                    this.isStrategist = true;
                    break;
                }
                case "Miners": {
                    this.setCosmeticSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42667_));
                    break;
                }
                case "Expedition": {
                    this.setCosmeticSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42672_));
                    tactician = true;
                }
                case "Engineers": {
                    this.setCosmeticSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42672_));
                    this.Ammo = 2 + this.f_19853_.m_213780_().m_188503_(3);
                    tactician = true;
                    this.isStrategist = true;
                    break;
                }
                case "Guardian": {
                    this.setCosmeticSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42661_));
                    tactician = true;
                    this.isStrategist = true;
                    break;
                }
                case "Scout": {
                    this.setCosmeticSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42673_));
                    this.Ammo = 6 + this.f_19853_.m_213780_().m_188503_(3);
                }
            }
            if (tactician) {
                this.setHealthUpgrade(40.0);
            }
            this.m_21409_(EquipmentSlot.HEAD, 0.0f);
            this.setPatrolling(true);
            if (this.MissionType != "Airstrike" && this.MissionType != "Hunt" && this.MissionType != "Message" && this.MissionType != "Miners") {
                this.findPatrolTarget();
            }
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_213386_1_, DifficultyInstance p_213386_2_, MobSpawnType p_213386_3_, @Nullable SpawnGroupData p_213386_4_, @Nullable CompoundTag p_213386_5_) {
        if (p_213386_3_ != MobSpawnType.PATROL && p_213386_3_ != MobSpawnType.STRUCTURE) {
            this.setPatrolling(true);
        }
        this.InitPatrolLeader();
        if (p_213386_3_ == MobSpawnType.PATROL || p_213386_3_ == MobSpawnType.SPAWN_EGG || p_213386_3_ == MobSpawnType.COMMAND || p_213386_3_ == MobSpawnType.MOB_SUMMONED) {
            if (this.MissionType == "Message") {
                this.m_21051_(Attributes.f_22279_).m_22100_(0.45);
                this.m_21051_(Attributes.f_22277_).m_22100_(128.0);
            }
            if (this.MissionType == "Diplomacy") {
                this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42660_));
                this.Peace = true;
            }
            if (this.MissionType == "Engineers") {
                this.m_21051_(Attributes.f_22277_).m_22100_(20.0);
                this.f_21345_.m_25352_(7, (Goal)new MiEngineeringGoal((EntityMi)this));
            }
        }
        if (this.isPatrolLeader()) {
            LOGGER.info("Leader3" + this.Weapon);
        }
        this.equipSelf();
        this.canBeChosen();
        this.setMiHealth();
        return super.m_6518_(p_213386_1_, p_213386_2_, p_213386_3_, p_213386_4_, p_213386_5_);
    }

    public void canBeChosen() {
        if (this.Weapon == "Train" || this.isTame()) {
            this.chosenCandidate(0.01 * (Double)MiCon.MI_FRIENDLY_CHOSEN.get());
        }
        if (this.PowerLevel > 1) {
            double chc = 0.015;
            if (this.f_19853_.m_46791_() == Difficulty.NORMAL) {
                chc = 0.02;
            }
            if (this.f_19853_.m_46791_() == Difficulty.HARD) {
                chc = 0.025;
            }
            this.chosenCandidate(chc * (Double)MiCon.MI_CHOSEN.get());
        }
    }

    public boolean isWizard() {
        return this.m_21120_(this.m_7655_()).m_41720_() == ModItems.MITOPIUM_GEM.get() || this.m_21120_(this.m_7655_()).m_41720_() == ModItems.MITOPIUM.get();
    }

    public boolean isShielding() {
        return this.m_21120_(this.m_7655_()).m_41720_() == ModItems.MITOPIUM.get();
    }

    public boolean isTonking() {
        return this.m_21120_(this.m_7655_()).m_41720_() == ModItems.TONK_STAFF.get();
    }

    public boolean isFlaming() {
        return this.m_21120_(this.m_7655_()).m_41720_() == ModItems.INFERMIUM_FLAMETHROWER.get();
    }

    public void equipSelf() {
        boolean weapon = false;
        switch (this.Weapon) {
            case "Spear": {
                this.setCosmeticSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ModItems.MISTRUM_SPEAR.get()));
                this.setCosmeticSlot(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_42740_));
                weapon = true;
                break;
            }
            case "SpearMiridium": {
                this.setCosmeticSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ModItems.MIRIDIUM_SPEAR.get()));
                this.setCosmeticSlot(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_42740_));
                weapon = true;
                break;
            }
            case "Pickaxe": {
                this.setCosmeticSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ModItems.MISTRUM_PICKAXE.get()));
                this.setCosmeticSlot(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_42000_));
                weapon = true;
                break;
            }
            case "Sword": {
                this.setCosmeticSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ModItems.MISTRUM_SWORD.get()));
                weapon = true;
                break;
            }
            case "SwordDesert": {
                this.setCosmeticSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42430_));
                this.setCosmeticSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_41830_));
                weapon = true;
                break;
            }
            case "Axe": {
                this.setCosmeticSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ModItems.MISTRUM_AXE.get()));
                weapon = true;
                break;
            }
            case "Pistol": {
                this.setCosmeticSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ModItems.MISTRUM_SWORD.get()));
                this.setCosmeticSlot(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)ModItems.MIRIDIUM_PISTOL.get()));
                break;
            }
            case "Zapper": {
                this.setCosmeticSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ModItems.ENDIMIUM_ZAPPER.get()));
                if (this.isTame()) break;
                this.equipEndimium();
                break;
            }
            case "Rifle": {
                this.setCosmeticSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ModItems.MIRIDIUM_RIFLE.get()));
                break;
            }
            case "Mortimi": {
                this.setCosmeticSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ModItems.MITOPIUM_MORTAR.get()));
                break;
            }
            case "Flamethrower": {
                this.setCosmeticSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ModItems.INFERMIUM_FLAMETHROWER.get()));
                if (this.isTame()) break;
                this.equipInfermium();
                break;
            }
            case "Tonkmi": {
                this.setCosmeticSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ModItems.TONK_STAFF.get()));
                if (!(this.m_21133_(Attributes.f_22276_) < 40.0)) break;
                this.m_21051_(Attributes.f_22276_).m_22100_(40.0);
                this.m_21153_(40.0f);
                break;
            }
            case "Bow": {
                this.setCosmeticSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
                weapon = true;
                break;
            }
            case "ForgottenArt": {
                this.setCosmeticSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ModItems.FORGOTTEN_BLADE.get()));
                weapon = true;
                break;
            }
            case "Gem": {
                this.setCosmeticSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ModItems.MITOPIUM_GEM.get()));
                break;
            }
            case "Rider": {
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ModItems.MISTRUM_SPEAR.get()));
                this.spawnMount((EntityType)ModEntities.LOON.get(), this.f_19853_, false);
                weapon = true;
                break;
            }
            case "RiderBow": {
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
                this.spawnMount((EntityType)ModEntities.LOON.get(), this.f_19853_, false);
                weapon = true;
                break;
            }
        }
        if (!this.isTame()) {
            if (this.f_19853_.m_6042_().f_63856_()) {
                this.equipInfermium();
            } else if (this.PowerLevel > 3) {
                this.equipMiridium();
            }
        }
        if (weapon && this.PowerLevel > 3) {
            if (this.PowerLevel > 4) {
                if (this.m_217043_().m_188503_(4) > 0) {
                    this.setCosmeticSlot(EquipmentSlot.MAINHAND, EnchantmentHelper.m_220292_((RandomSource)this.f_19796_, (ItemStack)this.m_21205_(), (int)((int)(22.0f + 2.0f * (float)this.f_19796_.m_188503_(6))), (boolean)false));
                }
            } else if (this.m_217043_().m_188503_(2) > 0) {
                this.setCosmeticSlot(EquipmentSlot.MAINHAND, EnchantmentHelper.m_220292_((RandomSource)this.f_19796_, (ItemStack)this.m_21205_(), (int)((int)(12.0f + 2.0f * (float)this.f_19796_.m_188503_(6))), (boolean)false));
            }
        }
        ((EntityMi)this).reassessWeaponGoal();
    }

    public boolean hasArmor() {
        return this.MiridiumArmor || this.ForgottenArmor || this.InfermiumArmor;
    }

    public boolean hasArmor(int i) {
        return this.MiridiumArmor && i == 0 || this.ForgottenArmor || this.InfermiumArmor && i != 1;
    }

    public boolean m_5825_() {
        if (this.InfermiumArmor) {
            return true;
        }
        return this.m_6095_().m_20672_();
    }

    public boolean shouldOverwriteHat() {
        return !this.isPatrolLeader() && this.Weapon != "Gem" && this.Weapon != "SwordDesert" && this.MissionType != "Assassinate" && !this.isChosen();
    }

    protected void setHealthUpgradeTotal(double ff) {
        if ((ff *= this.getBonus()) <= this.m_21051_(Attributes.f_22276_).m_22115_() * this.getBonus()) {
            return;
        }
        this.m_21051_(Attributes.f_22276_).m_22100_(ff);
        this.m_21153_((float)ff);
    }

    protected void setHealthUpgrade(double ff) {
        this.setHealthUpgradeTotal(ff + this.getTotalBonus());
    }

    protected double getBonus() {
        return (Double)MiCon.MI_HP_BONUS.get();
    }

    protected double getAttackBonus() {
        return (Double)MiCon.MI_ATTACK_BONUS.get();
    }

    protected double getForeignAttackBonus() {
        return (Double)MiCon.MI_OUTSIDER_ATTACK_BONUS.get();
    }

    protected double getTotalBonus() {
        double bonus = (this.getBonus() - 1.0) * this.m_21051_(Attributes.f_22276_).m_22115_();
        if (this.isPatrolLeader()) {
            bonus = Mth.m_14005_((double)bonus, (double)((Double)MiCon.OFFICER_HP_BONUS.get()));
        }
        return bonus;
    }

    public void equipInfermium() {
        boolean weapon = false;
        if (this.shouldOverwriteHat()) {
            weapon = true;
        }
        if (weapon && !this.isChosen()) {
            this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)ModBlocks.INFERMIUM_PLATING.get()));
        }
        this.ForgottenArmor = false;
        this.MiridiumArmor = false;
        this.InfermiumArmor = true;
        this.setMiHealth();
    }

    public void equipMiridium() {
        boolean weapon = false;
        if (this.shouldOverwriteHat()) {
            weapon = true;
        }
        if (weapon && !this.isChosen()) {
            this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)ModBlocks.MIRIDIUM_PLATING.get()));
        }
        this.MiridiumArmor = true;
        this.ForgottenArmor = false;
        this.InfermiumArmor = false;
        this.EndimiumArmor = false;
        this.setMiHealth();
    }

    public void equipEndimium() {
        boolean weapon = false;
        if (this.shouldOverwriteHat()) {
            weapon = true;
        }
        if (weapon && !this.isChosen()) {
            this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)ModBlocks.ENDIMIUM_PLATING.get()));
        }
        this.EndimiumArmor = true;
        this.ForgottenArmor = false;
        this.InfermiumArmor = false;
        this.MiridiumArmor = false;
        if (!this.isCurrentlyIteratingGoals) {
            this.f_21345_.m_25363_((Goal)this.warpsaveGoal);
            this.f_21345_.m_25352_(1, (Goal)this.warpsaveGoal);
        }
        this.setMiHealth();
    }

    public void equipForgotten() {
        boolean weapon = false;
        if (this.shouldOverwriteHat()) {
            weapon = true;
        }
        if (weapon && !this.isChosen()) {
            this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)ModBlocks.FORGOTTEN_BRICKS.get()));
        }
        this.ForgottenArmor = true;
        this.MiridiumArmor = false;
        this.InfermiumArmor = false;
        this.setMiHealth();
    }

    protected void gainEXP() {
        if (this.officer_Cooldown < 0) {
            ++this.officer_EXP;
            ++this.officer_Cooldown;
            if (this.officer_Cooldown == 0) {
                this.officer_Cooldown = 200;
            }
        }
        if (this.officer_EXP > 6 && this.m_21223_() > 10.0f && this.officer_LVL < 20) {
            this.officer_EXP -= 7;
            ++this.officer_LVL;
            this.setMiHealth();
            this.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 200, 3, false, false));
            this.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 200, 1, false, false));
            this.m_5496_(SoundEvents.f_12275_, 2.0f, 1.0f / (this.m_217043_().m_188501_() * 0.2f + 0.9f));
        }
    }

    protected void reduceOfficerCooldown() {
        if (this.officer_Cooldown > 0) {
            --this.officer_Cooldown;
            if (this.officer_Cooldown == 0) {
                this.officer_Cooldown = -4;
            }
        }
    }

    public void setMiHealth() {
        float amn = this.mi_health_standard();
        float miridiumplus = this.mi_health_armor1_bonus();
        float forgottenplus = this.mi_health_armor2_bonus();
        if (this.isChosen()) {
            amn = Mth.m_14036_((float)(amn * 2.0f), (float)(60 + this.officer_LVL * 5), (float)999.0f);
            miridiumplus = Mth.m_14036_((float)(miridiumplus * 2.0f), (float)15.0f, (float)99.0f);
            forgottenplus = Mth.m_14036_((float)(forgottenplus * 2.0f), (float)30.0f, (float)99.0f);
        } else if (this.isPatrolLeader()) {
            amn = Mth.m_14036_((float)amn, (float)(40 + this.officer_LVL * 5), (float)999.0f);
            miridiumplus = Mth.m_14036_((float)miridiumplus, (float)15.0f, (float)99.0f);
            forgottenplus = Mth.m_14036_((float)forgottenplus, (float)30.0f, (float)99.0f);
        }
        amn += this.mi_health_extra_buffs();
        if (this.ForgottenArmor) {
            amn += forgottenplus;
        } else if (this.MiridiumArmor || this.InfermiumArmor || this.EndimiumArmor) {
            amn += miridiumplus;
        }
        if (this.PowerLevel > 4) {
            amn = (float)((double)amn * (Double)MiCon.MI_HP_BONUS_PHASE3.get());
        } else if (this.PowerLevel > 3) {
            amn = (float)((double)amn * (Double)MiCon.MI_HP_BONUS_PHASE2.get());
        }
        this.setHealthUpgrade(amn + (float)this.getTotalBonus());
    }

    public float mi_health_extra_buffs() {
        return 0.0f;
    }

    public float mi_health_standard() {
        return 20.0f;
    }

    public float mi_health_armor1_bonus() {
        return 10.0f;
    }

    public float mi_health_armor2_bonus() {
        return 20.0f;
    }

    public void chosenCandidate(double chance) {
        RandomSource rr = this.f_19853_.m_213780_();
        if ((double)rr.m_188501_() < chance) {
            this.becomeChosen();
        }
    }

    public void becomeChosen() {
        this.setChosen(true);
        if (this.m_7770_() == null && !((EntityMi)this).isObject()) {
            this.m_6593_(this.randomLeaderName());
        }
        double attack = Mth.m_14008_((double)(this.m_21051_(Attributes.f_22281_).m_22135_() * 1.6), (double)5.0, (double)14.0);
        this.m_21051_(Attributes.f_22281_).m_22100_(attack);
        this.m_7292_(new MobEffectInstance(MobEffects.f_19621_, 99999, 3));
        this.setMiHealth();
        this.chosenAbility = 2 + this.f_19853_.m_213780_().m_188503_(11);
        this.chosenAbility2 = 2 + this.f_19853_.m_213780_().m_188503_(11);
        if (!this.isPatrolLeader()) {
            this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)ModBlocks.HONORIUM.get()));
            this.m_21409_(EquipmentSlot.HEAD, 1.0f);
        }
    }

    public void m_6043_() {
        if (!(this.m_21532_() || this.m_8023_() || this.isTame() || this.Objective != null || this.MissionType != "Scout")) {
            Event.Result result = ForgeEventFactory.canEntityDespawn((Mob)this);
            if (result == Event.Result.DENY) {
                this.f_20891_ = 0;
            } else if (result == Event.Result.ALLOW) {
                this.m_142467_(Entity.RemovalReason.DISCARDED);
            }
        } else {
            this.f_20891_ = 0;
        }
    }

    public static boolean checkPatrollingMonsterSpawnRules(EntityType<? extends EntityPatrollus> p_223330_0_, Level p_223330_1_, MobSpawnType p_223330_2_, BlockPos p_223330_3_, Random p_223330_4_) {
        return true;
    }

    public boolean m_6785_(double p_213397_1_) {
        return !this.patrolling || p_213397_1_ > 16384.0;
    }

    public void setPatrolTarget(BlockPos p_213631_1_) {
        this.patrolTarget = p_213631_1_;
        this.patrolling = true;
    }

    public BlockPos getPatrolTarget() {
        return this.patrolTarget;
    }

    public double getPatrolTargetDistanceNoY() {
        if (this.patrolTarget == null) {
            return 0.0;
        }
        double xx = Math.abs((double)this.patrolTarget.m_123341_() - this.m_20185_()) * Math.abs((double)this.patrolTarget.m_123341_() - this.m_20185_());
        double zz = Math.abs((double)this.patrolTarget.m_123343_() - this.m_20189_()) * Math.abs((double)this.patrolTarget.m_123343_() - this.m_20189_());
        return Math.sqrt(xx + zz);
    }

    public boolean hasPatrolTarget() {
        return this.patrolTarget != null;
    }

    public void setPatrolLeader(boolean p_213635_1_) {
        this.patrolLeader = p_213635_1_;
        this.patrolling = true;
    }

    public boolean isPatrolLeader() {
        return this.patrolLeader;
    }

    public boolean isChosen() {
        return this.chosen;
    }

    public boolean canJoinPatrol() {
        return true;
    }

    public void findPatrolTarget() {
        this.patrolling = true;
        if (this.MissionType == "Build") {
            this.patrolTarget = this.m_20183_();
            return;
        }
        if (this.MissionType == "Guardian") {
            List ents = this.f_19853_.f_151512_;
            ArrayList<TickingBlockEntity> hobs = new ArrayList<TickingBlockEntity>();
            for (TickingBlockEntity bop : ents) {
                if (!(this.m_20275_(bop.m_142689_().m_123341_(), bop.m_142689_().m_123342_(), bop.m_142689_().m_123343_()) < 22500.0) || !bop.m_142280_().equals("mialliance:beacon") && !bop.m_142280_().equals("mialliance:core")) continue;
                hobs.add(bop);
            }
            if (!hobs.isEmpty()) {
                int rr = this.f_19796_.m_188503_(hobs.size());
                TickingBlockEntity tar = (TickingBlockEntity)hobs.get(rr);
                this.patrolTarget = tar.m_142689_();
                return;
            }
        }
        if (this.MissionType == "Expedition") {
            if (this.expeditionTarget == null) {
                this.MissionType = "Hunt";
                return;
            }
            TileEntityForgottenAltar core = (TileEntityForgottenAltar)this.f_19853_.m_7702_(this.expeditionTarget);
            if (!(core instanceof TileEntityForgottenAltar)) {
                this.MissionType = "Hunt";
                return;
            }
            List<BlockPos> poses = core.romos;
            if (poses.isEmpty()) {
                if (this.f_19853_.m_45930_((Entity)this, -1.0) != null && this.isPatrolLeader()) {
                    this.MissionType = "Hunt";
                    this.patrolTarget = this.f_19853_.m_45930_((Entity)this, -1.0).m_20183_();
                }
                return;
            }
            BlockPos destos = null;
            double maxy = 0.0;
            for (BlockPos po : poses) {
                if (!((double)po.m_123342_() > maxy)) continue;
                maxy = po.m_123342_();
                destos = po;
            }
            this.patrolTarget = destos.m_7918_(-1, 1, 0);
            if (this.isPatrolLeader()) {
                core.romos.remove(destos);
            }
            return;
        }
        if (this.expeditionTarget != null && this.m_6844_(EquipmentSlot.HEAD).m_41720_() == Items.f_42672_) {
            if (this.f_19853_.m_45930_((Entity)this, -1.0) != null) {
                this.patrolTarget = this.f_19853_.m_45930_((Entity)this, -1.0).m_20183_();
            }
            return;
        }
        int rr = 0;
        while (rr < 15) {
            ++rr;
            this.patrolTarget = this.m_20183_().m_7918_(-50 + this.f_19796_.m_188503_(100), 0, -50 + this.f_19796_.m_188503_(100));
            this.patrolTarget = this.f_19853_.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, this.patrolTarget);
            Holder biome = this.f_19853_.m_204166_(this.patrolTarget);
            if (biome.containsTag(BiomeTags.f_207603_) || biome.containsTag(BiomeTags.f_207605_) || this.patrolTarget.m_123342_() <= 10) continue;
            rr = 15;
        }
    }

    protected boolean isPatrolling() {
        return !this.isTame();
    }

    public void setPatrolling(boolean p_226541_1_) {
        this.patrolling = p_226541_1_;
    }

    protected void setBeacon(BlockPos po) {
        this.f_19853_.m_7731_(po, ((Block)ModBlocks.MI_BEACON_INACTIVE.get()).m_49966_(), 3);
        TileEntityBeaconInactive tit2 = (TileEntityBeaconInactive)this.f_19853_.m_7702_(po);
        if (tit2 != null) {
            tit2.Tech = this.PowerLevel;
        }
        if (this.PowerLevel > 4 && this.m_9236_().m_213780_().m_188503_(3) == 0) {
            this.f_19853_.m_7731_(po.m_7494_(), ((Block)ModBlocks.MI_ANCHOR.get()).m_49966_(), 3);
        }
    }

    protected void FlightNavigate(BlockPos td, double spd, String Reason) {
        EntityPatrollus mi = this;
        if (mi instanceof EntityMi) {
            EntityMi plane = (EntityMi)mi;
            if (!plane.moveFirst) {
                return;
            }
        }
        RandomSource rr = mi.f_19796_;
        int TargetHeight = 20;
        int TargetLift = 15;
        int RadFly = 5;
        if (this instanceof EntityPlane && this.MissionType != "FighterSquadron" && this.MissionType != "Airstrike" && Reason == "Patrol" || Reason == "Point") {
            RadFly = 30;
        }
        BlockPos groundpos = this.f_19853_.m_5452_(Heightmap.Types.MOTION_BLOCKING, this.m_20183_());
        BlockPos targetpos = null;
        BlockPos pos = mi.m_20183_();
        BlockPos dest = null;
        int dx = td.m_123341_() - pos.m_123341_();
        int dz = td.m_123343_() - pos.m_123343_();
        boolean findTarget = false;
        if (Reason == "Patrol") {
            TargetLift = 15;
            TargetHeight = 25;
            if (this.MissionType == "Airstrike") {
                TargetLift = 40;
                TargetHeight = 50;
            }
        } else if (Reason == "Escape") {
            TargetLift = 90;
            TargetHeight = 150;
        } else if (Reason == "Crash") {
            TargetLift = -5;
            TargetHeight = 0;
            RadFly = 5;
        } else if ((Reason == "Dock" || Reason == "Land" || Reason == "Pickup" || Reason == "Descend") && dx * dx + dz * dz < 110) {
            TargetLift = -5;
            TargetHeight = 0;
            RadFly = 1;
        }
        if (mi.flyTarget == null) {
            findTarget = true;
        } else {
            dest = mi.flyTarget;
            if (mi.m_20275_(dest.m_123341_(), dest.m_123342_(), dest.m_123343_()) < 16.0) {
                findTarget = true;
            }
        }
        int Diff = 6;
        if (findTarget) {
            switch (Reason) {
                case "Strafe": {
                    TargetLift = 0;
                    Diff = 6;
                    if (this.MissionType == "Airstrike") {
                        Diff = 12;
                    }
                    int goX = 2 * (td.m_123341_() - mi.m_20183_().m_123341_());
                    int goZ = 2 * (td.m_123343_() - mi.m_20183_().m_123343_());
                    dest = this.getFlyTarget(this.m_20183_(), this.m_20183_().m_7918_(goX, 0, goZ), Diff);
                    break;
                }
                case "PrepareStrafe": {
                    TargetLift = 8;
                    int modX = 22;
                    int modZ = rr.m_188503_(40) - 20;
                    if (rr.m_188499_()) {
                        modZ = 22;
                        modX = rr.m_188503_(40) - 20;
                    }
                    if (rr.m_188499_()) {
                        modX *= -1;
                    }
                    if (rr.m_188499_()) {
                        modZ *= -1;
                    }
                    Diff = 12;
                    if (this.MissionType == "Airstrike") {
                        Diff = 18;
                    }
                    dest = this.getFlyTarget(this.m_20183_(), td.m_7918_(modX, 0, modZ), Diff);
                    break;
                }
                case "Land": {
                    TargetLift = 4;
                    int modeX = 70;
                    int modeZ = rr.m_188503_(80) - 40;
                    if (rr.m_188499_()) {
                        modeZ = 70;
                        modeX = rr.m_188503_(80) - 40;
                    }
                    if (rr.m_188499_()) {
                        modeX *= -1;
                    }
                    if (rr.m_188499_()) {
                        modeZ *= -1;
                    }
                    dest = td.m_7918_(modeX, 0, modeZ);
                    targetpos = this.f_19853_.m_5452_(Heightmap.Types.MOTION_BLOCKING, dest).m_6630_(7);
                    if (td.m_123342_() > targetpos.m_123342_()) {
                        targetpos = this.f_19853_.m_5452_(Heightmap.Types.MOTION_BLOCKING, dest).m_6630_(7 + td.m_123342_() - targetpos.m_123342_());
                    }
                    dest = targetpos;
                    break;
                }
                case "Descend": {
                    dest = td;
                    break;
                }
                default: {
                    Diff = TargetHeight;
                    if (this.m_20275_(td.m_123341_(), td.m_123342_(), td.m_123343_()) > 16384.0) {
                        Vec3 gro = new Vec3((double)(td.m_123341_() - pos.m_123341_()), (double)(td.m_123342_() - pos.m_123342_()), (double)(td.m_123343_() - pos.m_123343_())).m_82541_().m_82542_(64.0, 64.0, 64.0);
                        dest = this.getFlyTarget(this.m_20183_(), new BlockPos((double)pos.m_123341_() + gro.f_82479_, (double)pos.m_123342_() + gro.f_82480_, (double)pos.m_123343_() + gro.f_82481_), Diff);
                        break;
                    }
                    dest = this.getFlyTarget(this.m_20183_(), td.m_7918_(rr.m_188503_(1 + RadFly * 2) - RadFly, rr.m_188503_(7) - 3, rr.m_188503_(1 + RadFly * 2) - RadFly), Diff);
                    if (dest.m_123342_() >= 70) break;
                    dest = dest.m_6630_(70 - dest.m_123342_());
                }
            }
            mi.flyTarget = dest;
        }
        int Height = pos.m_123342_() - groundpos.m_123342_();
        double Speed = 0.2 * spd;
        Vec3 move = null;
        if (this.MissionType == "Airstrike" || this instanceof EntityPlane) {
            Speed = 0.35 * spd;
            move = new Vec3((double)(dest.m_123341_() - pos.m_123341_()), (double)(dest.m_123342_() - pos.m_123342_()), (double)(dest.m_123343_() - pos.m_123343_())).m_82541_().m_82542_(Speed, Speed, Speed).m_82542_(0.95 + (double)this.f_19796_.m_188501_() * 0.1, 0.95 + (double)this.f_19796_.m_188501_() * 0.1, 0.95 + (double)this.f_19796_.m_188501_() * 0.1).m_82520_(0.0, 0.005, 0.0);
        } else {
            move = new Vec3((double)(dest.m_123341_() - pos.m_123341_()), (double)(dest.m_123342_() - pos.m_123342_()), (double)(dest.m_123343_() - pos.m_123343_())).m_82541_().m_82542_(Speed, Speed, Speed).m_82542_(0.8 + (double)this.f_19796_.m_188501_() * 0.4, 0.8 + (double)this.f_19796_.m_188501_() * 0.4, 0.8 + (double)this.f_19796_.m_188501_() * 0.4).m_82520_(0.0, 0.005, 0.0);
        }
        if (Height < TargetLift) {
            move.m_82542_(0.5, 0.5, 0.5);
            move.m_82520_(0.0, Speed * 2.0, 0.0);
        } else if (Reason == "Strafe" && mi.m_20186_() > (double)dest.m_123342_()) {
            move.m_82520_(0.0, -0.5, 0.0);
        } else if (Reason == "Escape") {
            mi.m_21373_();
            mi.m_142467_(Entity.RemovalReason.DISCARDED);
        } else if (Reason == "Crash" || Reason == "Land" || Reason == "Dock" || Reason == "Pickup") {
            dx = dest.m_123341_() - pos.m_123341_();
            dz = dest.m_123343_() - pos.m_123343_();
            if (Reason == "Crash" && this.f_19853_.m_8055_(this.m_20183_().m_7495_()).m_60767_().m_76333_()) {
                mi.m_6074_();
            } else if (Reason == "Land" && dx * dx + dz * dz < 16) {
                EntityPlane plane = (EntityPlane)mi;
                plane.Flying = false;
                plane.Escape();
            } else if (Reason == "Dock") {
                EntityPlane plane = (EntityPlane)mi;
                if (plane.homeo != null && plane.m_20270_((Entity)plane.homeo) < 16.0f) {
                    plane.Flying = false;
                    plane.m_20329_((Entity)plane.homeo);
                }
            } else if (Reason == "Pickup" && dx * dx + dz * dz < 16 && (double)(td.m_123342_() + 8) > this.m_20186_()) {
                this.evacuateLads();
            }
        }
        mi.m_20256_(move);
        Vec3 Vec32 = this.m_20184_();
        this.m_146922_(-((float)Math.atan2(Vec32.f_82479_, Vec32.f_82481_)) * 57.295776f);
        this.f_20883_ = this.m_146908_();
        this.f_19859_ = this.m_146908_();
        this.f_20884_ = this.m_146908_();
        if (Reason == "Patrol") {
            mi.patroltime -= 40;
        }
    }

    private BlockPos getFlyTarget(BlockPos mypos, BlockPos theirpos, int height) {
        BlockPos theirposbottom;
        BlockPos myposbottom = this.f_19853_.m_5452_(Heightmap.Types.MOTION_BLOCKING, mypos);
        BlockPos usetheir = theirposbottom = this.f_19853_.m_5452_(Heightmap.Types.MOTION_BLOCKING, theirpos);
        if (myposbottom.m_123342_() > theirposbottom.m_123342_()) {
            height += myposbottom.m_123342_() - theirposbottom.m_123342_();
        }
        if (theirpos.m_123342_() - height > theirposbottom.m_123342_()) {
            height += theirpos.m_123342_() - height - theirposbottom.m_123342_();
        }
        return usetheir.m_6630_(height);
    }

    private void evacuateLads() {
        List<EntityMi> Evacs = this.evacuateLadsTargets();
        for (EntityMi mi : Evacs) {
            mi.m_21373_();
            mi.m_142467_(Entity.RemovalReason.DISCARDED);
        }
    }

    private List<EntityMi> evacuateLadsTargets() {
        return this.f_19853_.m_6443_(EntityMi.class, this.m_20191_().m_82377_(24.0, 48.0, 24.0), p_226543_1_ -> p_226543_1_.Tactic == "Surrender");
    }

    public boolean isFlyer() {
        return false;
    }

    public boolean isSpecialMover() {
        return false;
    }

    public void pingRadio(SoundEvent soundalert, int priority) {
    }

    private Component randomLeaderName() {
        String one = null;
        String two = null;
        switch (this.m_217043_().m_188503_(10)) {
            case 0: {
                one = "Sergeant ";
                break;
            }
            case 1: {
                one = "Leader ";
                break;
            }
            case 2: {
                one = "Corporal ";
                break;
            }
            case 3: {
                one = "Ranger ";
                break;
            }
            case 4: {
                one = "Officer ";
                break;
            }
            case 5: {
                one = "Scout ";
                break;
            }
            case 6: {
                one = "Commander ";
                break;
            }
            case 7: {
                one = "Commodore ";
                break;
            }
            case 8: {
                one = "Comrade ";
                break;
            }
            case 9: {
                one = "Ensign ";
            }
        }
        switch (this.m_217043_().m_188503_(35)) {
            case 0: {
                two = "Mimi";
                break;
            }
            case 1: {
                two = "Dimitri";
                break;
            }
            case 2: {
                two = "Mirt";
                break;
            }
            case 3: {
                two = "Misoza";
                break;
            }
            case 4: {
                two = "Mio";
                break;
            }
            case 5: {
                two = "Chmi";
                break;
            }
            case 6: {
                two = "Brimi";
                break;
            }
            case 7: {
                two = "Chummi";
                break;
            }
            case 8: {
                two = "Krimi";
                break;
            }
            case 9: {
                two = "Ami";
                break;
            }
            case 10: {
                two = "Simi";
                break;
            }
            case 11: {
                two = "Wemmi";
                break;
            }
            case 12: {
                two = "Lemi";
                break;
            }
            case 13: {
                two = "Mipi";
                break;
            }
            case 14: {
                two = "Zimi";
                break;
            }
            case 15: {
                two = "Hi-Mi";
                break;
            }
            case 16: {
                two = "Domi";
                break;
            }
            case 17: {
                two = "Rami";
                break;
            }
            case 18: {
                two = "Sitami";
                break;
            }
            case 19: {
                two = "Emiko";
                break;
            }
            case 20: {
                two = "Links";
                break;
            }
            case 21: {
                two = "Rechts";
                break;
            }
            case 22: {
                two = "Oost";
                break;
            }
            case 23: {
                two = "West";
                break;
            }
            case 24: {
                two = "Minx";
                break;
            }
            case 25: {
                two = "Lyxmi";
                break;
            }
            case 26: {
                two = "Miri";
                break;
            }
            case 27: {
                two = "Timmi";
                break;
            }
            case 28: {
                two = "Albimi";
                break;
            }
            case 29: {
                two = "Bami";
                break;
            }
            case 30: {
                two = "Mint";
                break;
            }
            case 31: {
                two = "Qumi";
                break;
            }
            case 32: {
                two = "Milli";
                break;
            }
            case 33: {
                two = "Mixer";
                break;
            }
            case 34: {
                two = "Da Minci";
            }
        }
        return Component.m_237113_((String)(one + two));
    }

    protected void announceColony() {
        List<TileEntityEmbassy> embs = this.allEmbassies();
        if (!embs.isEmpty()) {
            for (TileEntityEmbassy em : embs) {
                em.announceColony();
            }
        }
    }

    protected List<TileEntityEmbassy> allEmbassies() {
        List ents = this.f_19853_.f_151512_;
        ArrayList<TileEntityEmbassy> enti = new ArrayList<TileEntityEmbassy>();
        double distmax = 250000.0;
        for (TickingBlockEntity bop : ents) {
            double disto;
            if (!bop.m_142280_().equals("mialliance:embassy") || !((disto = this.m_20275_(bop.m_142689_().m_123341_(), bop.m_142689_().m_123342_(), bop.m_142689_().m_123343_())) < distmax)) continue;
            enti.add((TileEntityEmbassy)this.f_19853_.m_7702_(bop.m_142689_()));
        }
        return enti;
    }

    public static class PatrolGoal<T extends EntityPatrollus>
    extends Goal {
        private final T mob;
        private final double speedModifier;
        private final double leaderSpeedModifier;
        private long cooldownUntil = 0L;

        public PatrolGoal(T p_i50070_1_, double p_i50070_2_, double p_i50070_4_) {
            this.mob = p_i50070_1_;
            this.speedModifier = p_i50070_2_;
            this.leaderSpeedModifier = p_i50070_4_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            boolean flag;
            boolean bl = flag = ((EntityPatrollus)((Object)this.mob)).f_19853_.m_46467_() < this.cooldownUntil && this.cooldownUntil > 1L;
            if (((EntityPatrollus)((Object)this.mob)).MissionType == "Expedition") {
                return false;
            }
            if (!((EntityPatrollus)((Object)this.mob)).hasPatrolTarget()) {
                ((EntityPatrollus)((Object)this.mob)).findPatrolTarget();
            }
            return (((EntityPatrollus)((Object)this.mob)).Objective == null || ((EntityPatrollus)((Object)this.mob)).Objective == "") && ((EntityPatrollus)((Object)this.mob)).isPatrolling() && ((EntityPatrollus)((Object)this.mob)).hasPatrolTarget() && !flag && !((EntityTrain)((Object)this.mob)).isTame();
        }

        public void m_8056_() {
        }

        public void m_8041_() {
        }

        public void m_8037_() {
            block36: {
                BlockPos blockpos;
                List<EntityPatrollus> list;
                boolean flag;
                block39: {
                    PathNavigation pathnavigator;
                    block38: {
                        block37: {
                            flag = ((EntityPatrollus)((Object)this.mob)).isPatrolLeader();
                            pathnavigator = this.mob.m_21573_();
                            if (!pathnavigator.m_26571_() && !((EntityPatrollus)((Object)this.mob)).isFlyer()) break block36;
                            list = this.findPatrolCompanions();
                            if (this.mob instanceof EntityPlane) {
                                list = this.findPatrolCompanionsSpecific();
                            }
                            if (flag && !list.isEmpty() && ((EntityPatrollus)((Object)this.mob)).MissionType != "Alone") {
                                for (EntityPatrollus patrollerentity : list) {
                                    patrollerentity.leader = this.mob;
                                    if (patrollerentity.patrolTarget != null) continue;
                                    patrollerentity.setPatrolTarget(((EntityPatrollus)((Object)this.mob)).getPatrolTarget());
                                }
                            }
                            if (!((EntityPatrollus)((Object)this.mob)).isPatrolling() || !list.isEmpty() || ((EntityPatrollus)((Object)this.mob)).isFlyer()) break block37;
                            ((EntityPatrollus)((Object)this.mob)).patroltime = 1200;
                            this.cooldownUntil = ((EntityPatrollus)((Object)this.mob)).f_19853_.m_46467_() + 50L;
                            break block36;
                        }
                        if (!flag || ((EntityPatrollus)((Object)this.mob)).Objective != null && ((EntityPatrollus)((Object)this.mob)).Objective != "" || !(((EntityPatrollus)((Object)this.mob)).getPatrolTargetDistanceNoY() < 5.0)) break block38;
                        ((EntityPatrollus)((Object)this.mob)).patroltime = 1200;
                        if ((((EntityPatrollus)((Object)this.mob)).Ammo > 0 || this.shouldRest()) && ((EntityPatrollus)((Object)this.mob)).f_19853_.m_8055_(((EntityPatrollus)((Object)this.mob)).getPatrolTarget()) != ((Block)ModBlocks.MI_BEACON_INACTIVE.get()).m_49966_() && ((EntityPatrollus)((Object)this.mob)).f_19853_.m_8055_(((EntityPatrollus)((Object)this.mob)).getPatrolTarget()) != ((Block)ModBlocks.MI_BEACON.get()).m_49966_() && ((EntityPatrollus)((Object)this.mob)).MissionType != "Guardian") {
                            if (((EntityPatrollus)((Object)this.mob)).Ammo == 1 && ((EntityPatrollus)((Object)this.mob)).MissionType == "Engineers") {
                                for (EntityPatrollus mi : this.findPatrolCompanions()) {
                                    if (mi.Objective == "Engineering") continue;
                                    mi.Objective = "Engineering";
                                    mi.ObjectiveTarget = ((EntityPatrollus)((Object)this.mob)).getPatrolTarget();
                                    mi.friendlyFacilityID = ((EntityPatrollus)((Object)this.mob)).friendlyFacilityID;
                                    mi.setPatrolling(false);
                                }
                                ((EntityPatrollus)((Object)this.mob)).Objective = "Engineering";
                                ((EntityPatrollus)((Object)this.mob)).ObjectiveTarget = ((EntityPatrollus)((Object)this.mob)).getPatrolTarget();
                                ((EntityPatrollus)((Object)this.mob)).setPatrolling(false);
                                return;
                            }
                            if (((EntityPatrollus)((Object)this.mob)).MissionType == "Build" || ((EntityPatrollus)((Object)this.mob)).Ammo == 1 && ((Boolean)MiCon.MI_SPAWN_BUILDERS.get()).booleanValue()) {
                                List cols = ((EntityPatrollus)((Object)this.mob)).f_19853_.f_151512_;
                                boolean Go = true;
                                BlockPos testpos = null;
                                Iterator iterator = cols.iterator();
                                while (iterator.hasNext()) {
                                    TickingBlockEntity tickingBlockEntity = (TickingBlockEntity)iterator.next();
                                    if (!tickingBlockEntity.m_142280_().equals("mialliance:core") || !(this.mob.m_20275_((double)tickingBlockEntity.m_142689_().m_123341_(), (double)tickingBlockEntity.m_142689_().m_123342_(), (double)tickingBlockEntity.m_142689_().m_123343_()) < 40000.0) || !((TileEntityCore)((EntityPatrollus)((Object)this.mob)).f_19853_.m_7702_((BlockPos)tickingBlockEntity.m_142689_())).Center) continue;
                                    Go = false;
                                    testpos = tickingBlockEntity.m_142689_();
                                    break;
                                }
                                if (((EntityPatrollus)((Object)this.mob)).MissionType == "Build") {
                                    ((EntityPatrollus)((Object)this.mob)).Objective = "Colony";
                                    if (Go) {
                                        testpos = ((EntityPatrollus)((Object)this.mob)).getPatrolTarget();
                                        if (this.mob.m_20183_().m_123342_() < 60 || ((EntityPatrollus)((Object)this.mob)).f_19853_.m_6042_().f_63856_()) {
                                            testpos = testpos.m_6625_(3);
                                        }
                                        ((EntityPatrollus)((Object)this.mob)).f_19853_.m_7731_(testpos, ((Block)ModBlocks.MI_CORE.get()).m_49966_(), 3);
                                        co = (TileEntityCore)((EntityPatrollus)((Object)this.mob)).f_19853_.m_7702_(testpos);
                                        if (co != null) {
                                            ((TileEntityCore)((Object)co)).setCore(2, ((EntityPatrollus)((Object)this.mob)).PowerLevel);
                                            ((EntityPatrollus)((Object)this.mob)).announceColony();
                                        }
                                    } else {
                                        ((EntityPatrollus)((Object)this.mob)).bringSupplies = 2;
                                    }
                                    ((EntityPatrollus)((Object)this.mob)).ObjectiveTarget = testpos;
                                    for (EntityPatrollus entityPatrollus : list) {
                                        entityPatrollus.Objective = ((EntityPatrollus)((Object)this.mob)).Objective;
                                        entityPatrollus.ObjectiveTarget = testpos;
                                    }
                                } else if (!Go) {
                                    ((EntityPatrollus)((Object)this.mob)).Objective = "Colony";
                                    ((EntityPatrollus)((Object)this.mob)).ObjectiveTarget = testpos;
                                    ((EntityPatrollus)((Object)this.mob)).bringSupplies = 1;
                                    for (EntityPatrollus entityPatrollus : list) {
                                        entityPatrollus.Objective = ((EntityPatrollus)((Object)this.mob)).Objective;
                                        entityPatrollus.ObjectiveTarget = testpos;
                                    }
                                } else if (this.suitableColony(((EntityPatrollus)((Object)this.mob)).getPatrolTarget())) {
                                    ((EntityPatrollus)((Object)this.mob)).Objective = "Colony";
                                    testpos = ((EntityPatrollus)((Object)this.mob)).getPatrolTarget();
                                    ((EntityPatrollus)((Object)this.mob)).f_19853_.m_7731_(testpos, ((Block)ModBlocks.MI_CORE.get()).m_49966_(), 3);
                                    co = (TileEntityCore)((EntityPatrollus)((Object)this.mob)).f_19853_.m_7702_(testpos);
                                    ((TileEntityCore)((Object)co)).setCore(0, ((EntityPatrollus)((Object)this.mob)).PowerLevel);
                                    ((EntityPatrollus)((Object)this.mob)).announceColony();
                                    ((EntityPatrollus)((Object)this.mob)).ObjectiveTarget = testpos;
                                    for (EntityPatrollus patrollerentity : list) {
                                        patrollerentity.Objective = ((EntityPatrollus)((Object)this.mob)).Objective;
                                        patrollerentity.ObjectiveTarget = testpos;
                                    }
                                }
                            } else {
                                --((EntityPatrollus)((Object)this.mob)).Ammo;
                                if (((EntityPatrollus)((Object)this.mob)).getPatrolTarget().m_123342_() > 10) {
                                    ((EntityPatrollus)((Object)this.mob)).setBeacon(((EntityPatrollus)((Object)this.mob)).getPatrolTarget());
                                }
                                if (this.shouldRest() && ((EntityPatrollus)((Object)this.mob)).f_19853_.m_8055_(((EntityPatrollus)((Object)this.mob)).getPatrolTarget().m_7494_()) != Blocks.f_50683_.m_49966_()) {
                                    ((EntityPatrollus)((Object)this.mob)).f_19853_.m_7731_(((EntityPatrollus)((Object)this.mob)).getPatrolTarget().m_7494_(), Blocks.f_50683_.m_49966_(), 3);
                                }
                            }
                        }
                        if (!this.shouldRest()) {
                            if (((EntityPatrollus)((Object)this.mob)).f_19853_.m_8055_(((EntityPatrollus)((Object)this.mob)).getPatrolTarget().m_7494_()) == Blocks.f_50683_.m_49966_()) {
                                ((EntityPatrollus)((Object)this.mob)).f_19853_.m_7731_(((EntityPatrollus)((Object)this.mob)).getPatrolTarget().m_7494_(), Blocks.f_50016_.m_49966_(), 3);
                            }
                            ((EntityPatrollus)((Object)this.mob)).findPatrolTarget();
                            for (EntityPatrollus patrollerentity : list) {
                                patrollerentity.setPatrolTarget(((EntityPatrollus)((Object)this.mob)).getPatrolTarget());
                            }
                        } else {
                            ((EntityPatrollus)this.mob).f_21344_.m_26573_();
                            for (EntityPatrollus patrollerentity : list) {
                                patrollerentity.setPatrolTarget(this.mob.m_20183_());
                            }
                        }
                        break block36;
                    }
                    blockpos = null;
                    Vec3 Vec32 = new Vec3((double)((EntityPatrollus)((Object)this.mob)).getPatrolTarget().m_123341_(), (double)((EntityPatrollus)((Object)this.mob)).getPatrolTarget().m_123342_(), (double)((EntityPatrollus)((Object)this.mob)).getPatrolTarget().m_123343_());
                    Vec3 Vec31 = this.mob.m_20182_();
                    Vec3 Vec322 = Vec31.m_82546_(Vec32);
                    Vec32 = Vec322.m_82524_(90.0f).m_82490_(0.4).m_82549_(Vec32);
                    Vec3 vec3 = Vec32.m_82546_(Vec31).m_82541_().m_82490_(10.0).m_82549_(Vec31);
                    blockpos = new BlockPos(vec3);
                    blockpos = ((EntityPatrollus)((Object)this.mob)).f_19853_.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, blockpos);
                    if (((EntityPatrollus)((Object)this.mob)).isFlyer()) {
                        this.cooldownUntil = ((EntityPatrollus)((Object)this.mob)).f_19853_.m_46467_() + 2L;
                        ((EntityPatrollus)((Object)this.mob)).patroltime -= 2;
                        blockpos = ((EntityPatrollus)((Object)this.mob)).f_19853_.m_5452_(Heightmap.Types.MOTION_BLOCKING, ((EntityPatrollus)((Object)this.mob)).getPatrolTarget());
                        if (this.mob instanceof EntityPlane) {
                            EntityPlane plane = (EntityPlane)this.mob;
                            if (!plane.moveFirst || !plane.Flying) {
                                return;
                            }
                        }
                        if (((EntityPatrollus)((Object)this.mob)).getPatrolTarget().m_123342_() > blockpos.m_123342_()) {
                            blockpos = blockpos.m_6630_(((EntityPatrollus)((Object)this.mob)).getPatrolTarget().m_123342_() - blockpos.m_123342_());
                        }
                        ((EntityPatrollus)((Object)this.mob)).FlightNavigate(blockpos, 1.0, "Patrol");
                        return;
                    }
                    if (((EntityPatrollus)((Object)this.mob)).getPatrolTarget().m_123342_() < 10) {
                        ((EntityPatrollus)((Object)this.mob)).setPatrolTarget(this.mob.m_20183_());
                    }
                    if (pathnavigator.m_26519_((double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_(), flag ? this.leaderSpeedModifier : this.speedModifier)) break block39;
                    if (((EntityPatrollus)((Object)this.mob)).patroltime < 1 && flag && this.mob.m_5448_() == null) {
                        this.moveThere(list);
                    } else {
                        this.moveRandomly();
                    }
                    this.cooldownUntil = ((EntityPatrollus)((Object)this.mob)).f_19853_.m_46467_() + 20L;
                    ((EntityPatrollus)((Object)this.mob)).patroltime -= 20;
                    break block36;
                }
                if (!flag) break block36;
                this.cooldownUntil = ((EntityPatrollus)((Object)this.mob)).f_19853_.m_46467_() + 50L;
                ((EntityPatrollus)((Object)this.mob)).patroltime -= 50;
                for (EntityPatrollus patrollerentity : list) {
                    patrollerentity.setPatrolTarget(blockpos);
                }
            }
        }

        private boolean shouldRest() {
            return !((EntityPatrollus)((Object)this.mob)).f_19853_.m_46461_() && !((EntityPatrollus)((Object)this.mob)).f_19853_.m_6042_().m_63967_() && ((EntityPatrollus)((Object)this.mob)).MissionType != "Airstrike";
        }

        private boolean suitableColony(BlockPos pos) {
            Level lev = ((EntityPatrollus)((Object)this.mob)).f_19853_;
            if (!lev.m_45527_(pos)) {
                return false;
            }
            int yo = pos.m_123342_();
            if (yo < 10) {
                return false;
            }
            for (int ix = -6; ix <= 6; ix += 6) {
                for (int iz = -6; iz <= 6; iz += 6) {
                    BlockPos test = lev.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos.m_7918_(ix, 10, iz));
                    if (Math.abs(yo - test.m_123342_()) <= 3) continue;
                    return false;
                }
            }
            return true;
        }

        private List<EntityPatrollus> findPatrolCompanions() {
            return ((EntityPatrollus)((Object)this.mob)).f_19853_.m_6443_(EntityPatrollus.class, this.mob.m_20191_().m_82377_(35.0, 64.0, 35.0), p_226543_1_ -> p_226543_1_.canJoinPatrol() && !p_226543_1_.m_7306_((Entity)this.mob) && !p_226543_1_.isPatrolLeader() && !p_226543_1_.isTame() && p_226543_1_.Weapon != "Train" && (p_226543_1_.MissionType == ((EntityPatrollus)((Object)((Object)this.mob))).MissionType || p_226543_1_.MissionType == "Scout"));
        }

        private List<EntityPatrollus> findPatrolCompanionsSpecific() {
            return ((EntityPatrollus)((Object)this.mob)).f_19853_.m_6443_(EntityPatrollus.class, this.mob.m_20191_().m_82377_(35.0, 64.0, 35.0), p_226543_1_ -> p_226543_1_.canJoinPatrol() && !p_226543_1_.m_7306_((Entity)this.mob) && !p_226543_1_.isPatrolLeader() && !p_226543_1_.isTame() && p_226543_1_.Weapon != "Train" && p_226543_1_.MissionType == ((EntityPatrollus)((Object)((Object)this.mob))).MissionType);
        }

        private boolean moveThere(List<EntityPatrollus> targets) {
            this.mob.m_6021_((double)((EntityPatrollus)((Object)this.mob)).getPatrolTarget().m_123341_(), (double)((EntityPatrollus)((Object)this.mob)).getPatrolTarget().m_123342_(), (double)((EntityPatrollus)((Object)this.mob)).getPatrolTarget().m_123343_());
            for (EntityPatrollus ent : targets) {
                ent.m_6021_(((EntityPatrollus)((Object)this.mob)).getPatrolTarget().m_123341_(), ((EntityPatrollus)((Object)this.mob)).getPatrolTarget().m_123342_(), ((EntityPatrollus)((Object)this.mob)).getPatrolTarget().m_123343_());
            }
            return true;
        }

        private boolean moveRandomly() {
            if (!this.shouldRest()) {
                RandomSource random = this.mob.m_217043_();
                BlockPos blockpos = ((EntityPatrollus)((Object)this.mob)).f_19853_.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, this.mob.m_20183_().m_7918_(-8 + random.m_188503_(16), 0, -8 + random.m_188503_(16)));
                return this.mob.m_21573_().m_26519_((double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_(), this.speedModifier);
            }
            this.mob.m_21573_().m_26573_();
            return true;
        }
    }

    public static class ExpeditionGoal<T extends EntityPatrollus>
    extends Goal {
        private final EntityPatrollus mob;
        private int reco = 0;
        private int underway = 0;

        public ExpeditionGoal(T p_i50070_1_) {
            this.mob = p_i50070_1_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return this.mob.m_5448_() == null && this.mob.MissionType == "Expedition";
        }

        public boolean m_8045_() {
            return this.m_8036_();
        }

        public void m_8037_() {
            if (this.reco-- < 1) {
                this.reco = 20;
                if (this.mob.isPatrolLeader()) {
                    ++this.underway;
                    if (!this.mob.hasPatrolTarget()) {
                        this.mob.findPatrolTarget();
                        if (!this.mob.hasPatrolTarget()) {
                            return;
                        }
                        this.underway = 0;
                        for (EntityPatrollus mi : this.findPatrolCompanions()) {
                            mi.setPatrolTarget(this.mob.patrolTarget);
                            if (!(mi.m_20270_((Entity)this.mob) > 24.0f)) continue;
                            mi.m_6021_(this.mob.m_20185_(), this.mob.m_20186_(), this.mob.m_20189_());
                        }
                        if (this.mob.MissionType == "Hunt") {
                            TileEntityForgottenAltar alt = (TileEntityForgottenAltar)this.mob.f_19853_.m_7702_(this.mob.expeditionTarget);
                            BlockPos eyo = alt.entros;
                            this.mob.m_6021_(eyo.m_123341_(), eyo.m_123342_(), eyo.m_123343_());
                            for (EntityPatrollus mi : this.findPatrolCompanions()) {
                                mi.MissionType = "Hunt";
                                mi.m_6021_(eyo.m_123341_(), eyo.m_123342_(), eyo.m_123343_());
                            }
                        }
                    }
                    if (this.mob.m_20275_(this.mob.patrolTarget.m_123341_(), this.mob.patrolTarget.m_123342_(), this.mob.patrolTarget.m_123343_()) < 64.0) {
                        this.mob.setPatrolTarget(null);
                        this.reco = 1;
                        return;
                    }
                } else if (!this.mob.hasPatrolTarget()) {
                    this.mob.findPatrolTarget();
                    if (!this.mob.hasPatrolTarget()) {
                        return;
                    }
                    if (this.mob.m_20275_(this.mob.patrolTarget.m_123341_(), this.mob.patrolTarget.m_123342_(), this.mob.patrolTarget.m_123343_()) < 64.0) {
                        this.mob.setPatrolTarget(null);
                        this.reco = 1;
                        return;
                    }
                }
                if (this.mob.hasPatrolTarget()) {
                    BlockPos blockpos = this.mob.patrolTarget;
                    Path po = this.mob.f_21344_.m_7864_(blockpos, 0);
                    this.mob.f_21344_.m_26536_(po, 1.2);
                    if (this.underway > 15 && this.mob.isPatrolLeader() && this.mob.Objective != "Hunt") {
                        this.moveThere(this.findPatrolCompanions());
                    }
                }
            }
        }

        private List<EntityPatrollus> findPatrolCompanions() {
            return this.mob.f_19853_.m_6443_(EntityPatrollus.class, this.mob.m_20191_().m_82377_(64.0, 64.0, 64.0), p_226543_1_ -> p_226543_1_.canJoinPatrol() && !p_226543_1_.m_7306_((Entity)this.mob) && !p_226543_1_.isPatrolLeader() && !p_226543_1_.isTame() && p_226543_1_.Weapon != "Train" && p_226543_1_.MissionType == "Expedition");
        }

        private boolean moveThere(List<EntityPatrollus> targets) {
            this.mob.m_6021_(this.mob.getPatrolTarget().m_123341_(), this.mob.getPatrolTarget().m_123342_(), this.mob.getPatrolTarget().m_123343_());
            for (EntityPatrollus ent : targets) {
                ent.m_6021_(this.mob.getPatrolTarget().m_123341_(), this.mob.getPatrolTarget().m_123342_(), this.mob.getPatrolTarget().m_123343_());
            }
            return true;
        }
    }
}

