/*
 * Decompiled with CFR 0.152.
 */
package com.mialliance.entities;

import com.mialliance.MiCon;
import com.mialliance.ModSounds;
import com.mialliance.entities.EntityMi;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EntityWarptrooper
extends EntityMi {
    public EntityWarptrooper(EntityType<? extends EntityMi> p_i50195_1_, Level p_i50195_2_) {
        super(p_i50195_1_, p_i50195_2_);
        this.f_21364_ = 10;
    }

    @Override
    protected double getBonus() {
        return (Double)MiCon.WARPTROOPER_HP_BONUS.get();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22283_, (double)1.4f).m_22268_(Attributes.f_22288_, 3.0).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22278_, (double)0.7f).m_22268_(Attributes.f_22284_, 16.0);
    }

    @Override
    public float mi_health_standard() {
        return 30.0f;
    }

    @Override
    public float mi_health_armor1_bonus() {
        return 0.0f;
    }

    @Override
    public float mi_health_armor2_bonus() {
        return 15.0f;
    }

    @Override
    protected int m_5639_(float p_225508_1_, float p_225508_2_) {
        return 0;
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(3, (Goal)new WarpGoal(this));
        super.m_8099_();
    }

    public void teleportTo(BlockPos pos) {
        if (this.m_9236_().m_8055_(pos.m_7494_()).m_60767_().m_76337_()) {
            return;
        }
        this.m_6021_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.5, (double)pos.m_123343_() + 0.5);
    }

    public void m_6021_(double p_19887_, double p_19888_, double p_19889_) {
        this.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.2f + 0.9f));
        super.m_6021_(p_19887_, p_19888_, p_19889_);
        this.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.2f + 0.9f));
    }

    static class WarpGoal
    extends Goal {
        private final EntityWarptrooper mob;
        private LivingEntity target;
        private int sound = 0;
        private int jump = 0;
        private boolean stompAttack = false;

        public WarpGoal(EntityWarptrooper p_i1630_1_) {
            this.mob = p_i1630_1_;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (this.mob.m_20160_() || !this.mob.canAttack || this.mob.m_21023_(MobEffects.f_19609_)) {
                return false;
            }
            if (!this.mob.isTargetThreat()) {
                return false;
            }
            this.target = this.mob.m_5448_();
            double d0 = this.mob.m_20280_((Entity)this.target);
            if (!(d0 > 225.0)) {
                if (!this.mob.m_20096_()) {
                    return false;
                }
                return this.mob.m_217043_().m_188503_(30) == 0;
            }
            return false;
        }

        public boolean m_8045_() {
            return !this.mob.m_20096_();
        }

        public void m_8056_() {
            Vec3 vector3d = this.mob.m_20184_();
            Vec3 vector3d1 = new Vec3(this.target.m_20185_() - this.mob.m_20185_(), 0.0, this.target.m_20189_() - this.mob.m_20189_());
            if (vector3d1.m_82556_() > 1.0E-7) {
                vector3d1 = vector3d1.m_82541_().m_82490_(0.6).m_82549_(vector3d.m_82490_(0.3));
            }
            vector3d1 = vector3d1.m_82542_(3.0, 3.0, 3.0);
            this.mob.m_20334_(vector3d1.f_82479_, 1.2, vector3d1.f_82481_);
            this.mob.m_5496_((SoundEvent)ModSounds.WARPTROOPER_JETPACK.get(), 3.0f, 1.0f / (this.mob.m_217043_().m_188501_() * 0.2f + 0.9f));
            if (this.sound == 0) {
                this.mob.m_5496_((SoundEvent)ModSounds.MI_ATTACK.get(), 1.0f, 1.0f / (this.mob.m_217043_().m_188501_() * 0.4f + 0.8f));
                this.sound = 2 + this.mob.m_217043_().m_188503_(2);
            } else {
                --this.sound;
            }
            this.jump = 0;
            this.stompAttack = false;
        }

        public void m_8037_() {
            if (this.jump++ == 6 && this.mob.m_5448_() != null) {
                RandomSource rr = this.mob.m_217043_();
                this.stompAttack = true;
                switch (rr.m_188503_(5)) {
                    case 0: {
                        this.mob.teleportTo(this.mob.m_5448_().m_20183_().m_6630_(5));
                        this.mob.m_20334_(0.0, 0.0, 0.0);
                        break;
                    }
                    case 1: {
                        this.mob.teleportTo(this.mob.m_5448_().m_20183_().m_5484_(this.mob.m_6350_(), 4));
                        this.mob.m_20334_(0.0, 0.0, 0.0);
                        break;
                    }
                    case 2: {
                        this.mob.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 40, 4, false, false));
                        Vec3 vector3d1 = new Vec3(this.target.m_20185_() - this.mob.m_20185_(), 0.0, this.target.m_20189_() - this.mob.m_20189_());
                        vector3d1 = vector3d1.m_82541_().m_82549_(vector3d1.m_82542_(0.07, 0.07, 0.07));
                        this.mob.m_20334_(vector3d1.f_82479_, vector3d1.f_82480_, vector3d1.f_82481_);
                        break;
                    }
                    case 3: {
                        this.mob.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 40, 4, false, false));
                        Vec3 vector3d2 = new Vec3(this.target.m_20185_() - this.mob.m_20185_(), 0.0, this.target.m_20189_() - this.mob.m_20189_());
                        vector3d2 = vector3d2.m_82541_().m_82549_(vector3d2.m_82542_(0.12, 0.12, 0.12));
                        this.mob.m_20334_(vector3d2.f_82479_, vector3d2.f_82480_, vector3d2.f_82481_);
                    }
                }
            }
        }

        public void m_8041_() {
            if (this.mob.m_20096_() && this.stompAttack) {
                this.mob.f_19853_.m_46518_((Entity)this.mob, this.mob.m_20185_(), this.mob.m_20186_(), this.mob.m_20189_(), 0.75f, false, Explosion.BlockInteraction.NONE);
                for (LivingEntity ent : this.findStompVictims(3.0)) {
                    float dmg = 5.0f;
                    if (this.mob.isForeign((Entity)ent)) {
                        dmg += 10.0f;
                    }
                    ent.m_6469_(DamageSource.m_19373_((LivingEntity)this.mob), dmg);
                    ent.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 30, 3, false, false));
                    ent.m_20334_(ent.m_20184_().m_7096_(), ent.m_20184_().m_7098_() + 0.35, ent.m_20184_().m_7094_());
                }
            }
        }

        private List<LivingEntity> findStompVictims(double rad) {
            return this.mob.f_19853_.m_6443_(LivingEntity.class, this.mob.m_20191_().m_82400_(rad), ent -> {
                if (ent instanceof EntityMi) {
                    EntityMi mi = (EntityMi)((Object)ent);
                    if (mi.getOwner() != this.mob.getOwner()) {
                        return ent.m_20096_();
                    }
                    return false;
                }
                return ent.m_20096_();
            });
        }
    }
}

