/*
 * Decompiled with CFR 0.152.
 */
package com.mialliance.entities;

import com.mialliance.ModSounds;
import com.mialliance.entities.EntityBombimi;
import com.mialliance.entities.EntityMi;
import com.mialliance.entities.EntityTonkTurret;
import com.mialliance.entities.EntityTrain;
import com.mialliance.entities.EntityTurretMortar;
import com.mialliance.entities.ModEntities;
import com.mialliance.item.ModItems;
import com.mojang.logging.LogUtils;
import java.util.EnumSet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;

public class MortimiGoal<T extends Mob>
extends Goal {
    private final T mob;
    private final double speedModifier;
    private float attackRadiusSqr;
    private int attackTime = 0;
    private int attackCharge = 0;
    private boolean isHeavyArtillery = false;
    private static final Logger LOGGER = LogUtils.getLogger();
    private long artilleryCooldown = 0L;

    public MortimiGoal(T p_i47515_1_, double p_i47515_2_, float p_i47515_5_) {
        this.mob = p_i47515_1_;
        this.speedModifier = p_i47515_2_;
        this.attackRadiusSqr = p_i47515_5_ * p_i47515_5_;
        this.attackCharge = 0;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public MortimiGoal(T p_i47515_1_, double p_i47515_2_, float p_i47515_5_, boolean isHeavy) {
        this.mob = p_i47515_1_;
        this.speedModifier = p_i47515_2_;
        this.attackRadiusSqr = p_i47515_5_ * p_i47515_5_;
        this.attackCharge = 0;
        this.isHeavyArtillery = isHeavy;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (!((EntityTrain)((Object)this.mob)).canAttack || !((Mob)this.mob).f_19853_.m_45527_(this.mob.m_20183_())) {
            return false;
        }
        return this.mob.m_5448_() == null ? false : this.isHoldingMortar();
    }

    public boolean isHoldingMortar() {
        return this.mob.m_21093_(is -> is.m_41720_().m_5456_() == ModItems.MITOPIUM_MORTAR.get()) || this.mob instanceof EntityTurretMortar;
    }

    public boolean m_8045_() {
        if (this.mob.m_5448_() == null || !((Mob)this.mob).f_19853_.m_45527_(this.mob.m_20183_())) {
            return false;
        }
        return this.mob.m_5448_().m_6084_();
    }

    public void m_8056_() {
        super.m_8056_();
        this.mob.m_21561_(true);
    }

    public void m_8041_() {
        super.m_8041_();
        this.mob.m_21561_(false);
        this.attackTime = -1;
    }

    public boolean canConductArtilleryStrike(Vec3 trt) {
        if (!this.isHoldingMortar()) {
            return false;
        }
        if (this.mob.m_9236_().m_46467_() < this.artilleryCooldown) {
            return false;
        }
        return !(this.mob.m_20238_(trt) > 65536.0);
    }

    public void performArtilleryStrike(Vec3 trt, boolean Devastate) {
        Level lev = ((Mob)this.mob).f_19853_;
        RandomSource r = ((Mob)this.mob).f_19853_.m_213780_();
        this.attackCharge = r.m_188503_(15) - 35;
        this.artilleryCooldown = this.mob.m_9236_().m_46467_() + 800L + (long)r.m_188503_(600);
        if (((EntityMi)((Object)this.mob)).isChosen()) {
            this.attackCharge += 40;
            this.artilleryCooldown = this.mob.m_9236_().m_46467_() + 400L + (long)r.m_188503_(200);
        }
        EntityBombimi en = (EntityBombimi)((EntityType)ModEntities.BOMBIMI.get()).m_20615_(lev);
        Vec3 posm = this.mob.m_20182_();
        Vec3 post = trt;
        en.m_20219_(posm.m_82520_(0.0, 1.0, 0.0));
        if (this.isHeavyArtillery) {
            en.setMortarHeavy();
            this.mob.m_5496_((SoundEvent)ModSounds.MUSIC_MORTAR.get(), 60.0f, 0.9f + r.m_188501_() * 0.2f);
        } else {
            en.setMortar();
            this.mob.m_5496_((SoundEvent)ModSounds.SFX_MORTARSMALL.get(), 60.0f, 0.9f + r.m_188501_() * 0.2f);
        }
        if (this.mob instanceof EntityTonkTurret && ((EntityTonkTurret)((Object)this.mob)).hasSpecialUpgrade()) {
            en.breakthroughRound = true;
        }
        if (Devastate) {
            en.shouldDevastate = true;
        }
        Vec3 move = new Vec3(post.f_82479_ - posm.f_82479_, post.f_82480_ - posm.f_82480_, post.f_82481_ - posm.f_82481_).m_82542_((double)(0.07f + r.m_188501_() * 0.06f), (double)0.05f, (double)(0.07f + r.m_188501_() * 0.06f)).m_82520_(0.0, 4.0, 0.0);
        en.m_20256_(move);
        if (((EntityTrain)((Object)this.mob)).isTame()) {
            en.tame(((EntityTrain)((Object)this.mob)).getOwnerUUID());
        }
        lev.m_7967_((Entity)en);
    }

    public void m_8037_() {
        if (this.attackTime++ > 5) {
            this.attackTime = 0;
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity != null) {
                this.mob.m_21391_((Entity)livingentity, 90.0f, 1.0f);
                double d0 = this.mob.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
                boolean atk = false;
                Level lev = ((Mob)this.mob).f_19853_;
                if (!(d0 > (double)this.attackRadiusSqr) && lev.m_45527_(this.mob.m_20183_())) {
                    atk = true;
                    this.mob.m_21573_().m_26573_();
                    this.mob.m_21563_().m_24960_((Entity)livingentity, 30.0f, 30.0f);
                    this.attackCharge += 5;
                } else if (((EntityMi)((Object)this.mob)).allowMove) {
                    this.attackCharge = 0;
                    this.mob.m_21573_().m_5624_((Entity)livingentity, this.speedModifier);
                }
                if (atk) {
                    if (this.attackCharge == 65) {
                        this.mob.m_21569_().m_24901_();
                        this.attackTime = 2;
                    }
                    if (this.attackCharge >= 70) {
                        RandomSource r = ((Mob)this.mob).f_19853_.m_213780_();
                        this.attackCharge = r.m_188503_(15) - 35;
                        if (((EntityMi)((Object)this.mob)).isChosen()) {
                            this.attackCharge += 40;
                        }
                        EntityBombimi en = (EntityBombimi)((EntityType)ModEntities.BOMBIMI.get()).m_20615_(lev);
                        Vec3 posm = this.mob.m_20182_();
                        Vec3 post = this.mob.m_5448_().m_20182_();
                        en.m_20219_(posm.m_82520_(0.0, 1.7, 0.0));
                        this.mob.m_5496_((SoundEvent)ModSounds.SFX_MORTARSMALL.get(), 60.0f, 0.9f + r.m_188501_() * 0.2f);
                        if (this.isHeavyArtillery) {
                            en.setMortarHeavy();
                        } else {
                            en.setMortar();
                        }
                        if (this.mob instanceof EntityTonkTurret && ((EntityTonkTurret)((Object)this.mob)).hasSpecialUpgrade()) {
                            en.breakthroughRound = true;
                        }
                        double distx = post.f_82479_ - posm.f_82479_;
                        double distz = post.f_82481_ - posm.f_82481_;
                        if (distx > 0.0 && distx < 6.0) {
                            distx = 6.0;
                        }
                        if (distz > 0.0 && distz < 6.0) {
                            distz = 6.0;
                        }
                        if (distx < 0.0 && distx > -6.0) {
                            distx = -6.0;
                        }
                        if (distz < 0.0 && distz > -6.0) {
                            distz = -6.0;
                        }
                        Vec3 move = new Vec3(distx, post.f_82480_ - posm.f_82480_, distz).m_82542_((double)(0.08f + r.m_188501_() * 0.04f), (double)0.05f, (double)(0.08f + r.m_188501_() * 0.04f)).m_82520_(0.0, (double)(2.0f + Mth.m_14116_((float)((float)d0)) * 0.01f), 0.0);
                        en.m_20256_(move);
                        if (((EntityTrain)((Object)this.mob)).isTame()) {
                            en.tame(((EntityTrain)((Object)this.mob)).getOwnerUUID());
                        }
                        lev.m_7967_((Entity)en);
                    }
                }
            }
        }
    }
}

