/*
 * Decompiled with CFR 0.152.
 */
package com.mialliance.item;

import com.mialliance.ModSounds;
import com.mialliance.block.TileEntityEmbassy;
import com.mialliance.entities.EntityMi;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.TickingBlockEntity;

public class ItemDiplomaticLetter
extends Item {
    public ItemDiplomaticLetter(Item.Properties properties) {
        super(properties);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.mialliance.qdiplomatic_letter"));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.mialliance.diplomatic_letter"));
        }
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    public InteractionResult m_6880_(ItemStack stack, Player playerIn, LivingEntity entity, InteractionHand hand) {
        if (entity.f_19853_.f_46443_) {
            return InteractionResult.PASS;
        }
        RandomSource random = playerIn.f_19853_.m_213780_();
        if (entity instanceof EntityMi && !playerIn.m_6144_()) {
            EntityMi target = (EntityMi)entity;
            if (target.MissionType == "Diplomacy") {
                List<EntityMi> list = this.findTargets((LivingEntity)playerIn);
                if (stack.m_41784_().m_128451_("TargetY") == 0) {
                    for (EntityMi mi : list) {
                        mi.ObjectiveProgress = 2;
                    }
                } else {
                    BlockPos location = new BlockPos(stack.m_41784_().m_128451_("TargetX"), stack.m_41784_().m_128451_("TargetY"), stack.m_41784_().m_128451_("TargetZ"));
                    if (this.findEmbassies(playerIn.f_19853_, location) != null) {
                        playerIn.f_19853_.m_6269_((Player)null, (Entity)playerIn, (SoundEvent)ModSounds.MI_NO.get(), SoundSource.HOSTILE, 1.0f, random.m_188501_() * 0.1f + 0.95f);
                    } else {
                        for (EntityMi mi : list) {
                            mi.ObjectiveProgress = 3;
                            mi.ObjectiveTarget = location;
                        }
                    }
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Level world = context.m_43725_();
        RandomSource random = world.m_213780_();
        if (!world.f_46443_ && context.m_43723_().m_6144_()) {
            BlockPos there = context.m_8083_();
            stack.m_41784_().m_128405_("TargetX", there.m_123341_());
            stack.m_41784_().m_128405_("TargetY", there.m_123342_());
            stack.m_41784_().m_128405_("TargetZ", there.m_123343_());
            context.m_43723_().f_19853_.m_6269_((Player)null, (Entity)context.m_43723_(), (SoundEvent)ModSounds.SFX_CONFIRM.get(), SoundSource.BLOCKS, 1.0f, random.m_188501_() * 0.1f + 0.95f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private BlockPos findEmbassies(Level wo, BlockPos po) {
        List ents = wo.f_151512_;
        TileEntityEmbassy kri = null;
        double distmax = 300.0;
        for (TickingBlockEntity bop : ents) {
            double diz;
            double dix;
            double disto;
            if (!bop.m_142280_().equals("mialliance:embassy") || !((disto = Math.sqrt((dix = (double)(bop.m_142689_().m_123341_() - po.m_123341_())) * dix + (diz = (double)(bop.m_142689_().m_123343_() - po.m_123343_())) * diz)) < distmax) || !(disto > 0.0)) continue;
            kri = (TileEntityEmbassy)wo.m_7702_(bop.m_142689_());
            return kri.m_58899_();
        }
        return null;
    }

    private List<EntityMi> findTargets(LivingEntity cast) {
        return cast.f_19853_.m_6443_(EntityMi.class, cast.m_20191_().m_82377_(32.0, 32.0, 32.0), mi -> mi.Objective == "Diplomacy" && mi.ObjectiveProgress < 3);
    }
}

