/*
 *     Copyright (C) 2024 HPK-dev
 *     Copyright (C) 2024 Mike Tang
 *     Copyright (C) 2024 iceice666
 *
 *     This program is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU Affero General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU Affero General Public License for more details.
 *
 *     You should have received a copy of the GNU Affero General Public License
 *     along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package team.hpk.yjas

import net.fabricmc.api.ModInitializer
import org.slf4j.LoggerFactory
import team.hpk.yjas.block.ModBlocks
import team.hpk.yjas.item.ModItems
import team.hpk.yjas.world.gen.ModWorldGeneration


object ModMain : ModInitializer {

    const val MOD_ID = "yjas"
    val LOGGER = LoggerFactory.getLogger(MOD_ID)

    override fun onInitialize() {
        LOGGER.info("We add silver to your game!")
        ModItems.register()
        ModBlocks.register()
        ModWorldGeneration.generateModWorldGen()
    }


}