/*
 *     Copyright (C) 2024 HPK-dev
 *     Copyright (C) 2024 Mike Tang
 *     Copyright (C) 2024 iceice666
 *
 *     This program is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU Affero General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU Affero General Public License for more details.
 *
 *     You should have received a copy of the GNU Affero General Public License
 *     along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package team.hpk.yjas.datagen

import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider
import net.minecraft.registry.RegistryWrapper.WrapperLookup
import team.hpk.yjas.datagen.ModTags.Items.INGOTS
import team.hpk.yjas.datagen.ModTags.Items.INGOTS_SILVER
import team.hpk.yjas.datagen.ModTags.Items.NUGGETS
import team.hpk.yjas.datagen.ModTags.Items.NUGGETS_SILVER
import team.hpk.yjas.datagen.ModTags.Items.ORES
import team.hpk.yjas.datagen.ModTags.Items.ORES_IN_GROUND_DEEPSLATE
import team.hpk.yjas.datagen.ModTags.Items.ORES_IN_GROUND_STONE
import team.hpk.yjas.datagen.ModTags.Items.ORES_SILVER
import team.hpk.yjas.datagen.ModTags.Items.RAW_MATERIALS
import team.hpk.yjas.datagen.ModTags.Items.RAW_MATERIALS_SILVER
import team.hpk.yjas.datagen.ModTags.Items.RAW_SILVER
import team.hpk.yjas.datagen.ModTags.Items.RAW_SILVER_ORES
import team.hpk.yjas.datagen.ModTags.Items.SILVER_BLOCKS
import team.hpk.yjas.datagen.ModTags.Items.SILVER_INGOTS
import team.hpk.yjas.datagen.ModTags.Items.SILVER_NUGGETS
import team.hpk.yjas.datagen.ModTags.Items.SILVER_ORES
import team.hpk.yjas.datagen.ModTags.Items.STORAGE_BLOCKS
import team.hpk.yjas.datagen.ModTags.Items.STORAGE_BLOCKS_SILVER
import team.hpk.yjas.item.ModItems
import java.util.concurrent.CompletableFuture

class Item(output: FabricDataOutput, completableFuture: CompletableFuture<WrapperLookup>) :
    FabricTagProvider.ItemTagProvider(output, completableFuture) {


    override fun configure(arg: WrapperLookup) {
        getOrCreateTagBuilder(ORES)
            .addTag(SILVER_ORES)

        getOrCreateTagBuilder(ORES_SILVER)
            .addTag(SILVER_ORES)

        getOrCreateTagBuilder(SILVER_ORES)
            .add(ModItems.DEEPSLATE_SILVER_ORE)
            .add(ModItems.SILVER_ORE)

        getOrCreateTagBuilder(SILVER_BLOCKS)
            .add(ModItems.SILVER_BLOCK)

        getOrCreateTagBuilder(RAW_MATERIALS)
            .addTag(RAW_SILVER_ORES)

        getOrCreateTagBuilder(RAW_MATERIALS_SILVER)
            .addTag(RAW_SILVER_ORES)

//        getOrCreateTagBuilder(RAW_SILVER)
//            .add(ModItems.RAW_SILVER)

        getOrCreateTagBuilder(ORES_IN_GROUND_DEEPSLATE)
            .add(ModItems.DEEPSLATE_SILVER_ORE)

        getOrCreateTagBuilder(ORES_IN_GROUND_STONE)
            .add(ModItems.SILVER_ORE)

        getOrCreateTagBuilder(INGOTS)
            .addTag(SILVER_INGOTS)

        getOrCreateTagBuilder(INGOTS_SILVER)
            .addTag(SILVER_INGOTS)

        getOrCreateTagBuilder(NUGGETS)
            .addTag(SILVER_NUGGETS)

        getOrCreateTagBuilder(NUGGETS_SILVER)
            .addTag(SILVER_NUGGETS)

        getOrCreateTagBuilder(SILVER_INGOTS)
            .add(ModItems.SILVER_INGOT)

        getOrCreateTagBuilder(SILVER_NUGGETS)
            .add(ModItems.SILVER_NUGGET)

        getOrCreateTagBuilder(STORAGE_BLOCKS)
            .addTag(SILVER_BLOCKS)

        getOrCreateTagBuilder(STORAGE_BLOCKS_SILVER)
            .addTag(SILVER_BLOCKS)

        getOrCreateTagBuilder(RAW_SILVER_ORES)
            .add(ModItems.RAW_SILVER)
    }
}