/*
 *     Copyright (C) 2024 HPK-dev
 *     Copyright (C) 2024 Mike Tang
 *     Copyright (C) 2024 iceice666
 *
 *     This program is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU Affero General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU Affero General Public License for more details.
 *
 *     You should have received a copy of the GNU Affero General Public License
 *     along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package team.hpk.yjas.item

import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup
import net.minecraft.item.BlockItem
import net.minecraft.item.Item
import net.minecraft.item.ItemGroup
import net.minecraft.item.ItemStack
import net.minecraft.registry.Registries
import net.minecraft.registry.Registry
import net.minecraft.registry.RegistryKey
import net.minecraft.registry.RegistryKeys
import net.minecraft.util.Identifier
import team.hpk.yjas.ModMain.MOD_ID
import team.hpk.yjas.Utils.getIdentifier
import team.hpk.yjas.Utils.getTranslatableKey
import team.hpk.yjas.block.ModBlocks


object ModItems {

    // item group
    val ITEM_GROUP: RegistryKey<ItemGroup> = RegistryKey.of(
        RegistryKeys.ITEM_GROUP,
        Identifier.of(MOD_ID, "item_group")
    )


    val SILVER_INGOT = SilverIngot(Item.Settings())
    val SILVER_NUGGET = SilverNugget(Item.Settings())
    val RAW_SILVER = RawSilver(Item.Settings())

    // Block items
    val SILVER_ORE = BlockItem(ModBlocks.SILVER_ORE, Item.Settings())
    val DEEPSLATE_SILVER_ORE = BlockItem(ModBlocks.DEEPSLATE_SILVER_ORE, Item.Settings())
    val SILVER_BLOCK = BlockItem(ModBlocks.SILVER_BLOCK, Item.Settings())


    fun register() {
        Registry.register(
            Registries.ITEM_GROUP,
            ITEM_GROUP,
            FabricItemGroup.builder()
                .displayName(getTranslatableKey("item_group"))
                .icon { ItemStack(SILVER_INGOT) }
                .entries { _, entries ->
                    entries.add(SILVER_INGOT)
                    entries.add(SILVER_NUGGET)
                    entries.add(SILVER_BLOCK)
                    entries.add(RAW_SILVER)
                    entries.add(SILVER_ORE)
                    entries.add(DEEPSLATE_SILVER_ORE)
                }
                .build()
        )


        Registry.register(
            Registries.ITEM,
            getIdentifier("silver_ingot"),
            SILVER_INGOT
        )

        Registry.register(
            Registries.ITEM,
            getIdentifier("silver_nugget"),
            SILVER_NUGGET
        )

        Registry.register(
            Registries.ITEM,
            getIdentifier("raw_silver"),
            RAW_SILVER
        )

        // For block items

        Registry.register(
            Registries.ITEM,
            getIdentifier("silver_block"),
            SILVER_BLOCK
        )

        Registry.register(
            Registries.ITEM,
            getIdentifier("silver_ore"),
            SILVER_ORE
        )

        Registry.register(
            Registries.ITEM,
            getIdentifier("deepslate_silver_ore"),
            DEEPSLATE_SILVER_ORE
        )

    }
}


class SilverIngot(settings: Settings?) : Item(settings)
class SilverNugget(settings: Settings?) : Item(settings)
class RawSilver(settings: Settings?) : Item(settings)