/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.component;

import dev.onyxstudios.cca.api.v3.item.ItemComponent;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2519;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import thefloydman.linkingbooks.api.component.LinkDataComponent;
import thefloydman.linkingbooks.api.linking.LinkEffect;
import thefloydman.linkingbooks.util.registry.ModRegistries;

public class ItemLinkData
extends ItemComponent
implements LinkDataComponent {
    private static final String DIMENSION = "dimension";
    private static final String POSITION = "position";
    private static final String ROTATION = "rotation";
    private static final String UUID_LABEL = "uuid";
    private static final String LINK_EFFECTS = "link_effects";

    public ItemLinkData(class_1799 stack) {
        super(stack);
    }

    @Override
    public void setDimension(class_2960 dimension) {
        this.putString(DIMENSION, dimension.toString());
    }

    @Override
    public class_2960 getDimension() {
        if (!this.hasTag(DIMENSION, 8)) {
            this.putString(DIMENSION, "minecraft:overworld");
        }
        return new class_2960(this.getString(DIMENSION));
    }

    @Override
    public void setPosition(class_2338 pos) {
        this.putCompound(POSITION, class_2512.method_10692((class_2338)pos));
    }

    @Override
    public class_2338 getPosition() {
        if (!this.hasTag(POSITION, 10)) {
            this.putCompound(POSITION, class_2512.method_10692((class_2338)new class_2338(0, 0, 0)));
        }
        return class_2512.method_10691((class_2487)this.getCompound(POSITION));
    }

    @Override
    public void setRotation(float rotation) {
        this.putFloat(ROTATION, rotation);
    }

    @Override
    public float getRotation() {
        if (!this.hasTag(ROTATION, 5)) {
            this.putFloat(ROTATION, 0.0f);
        }
        return this.getFloat(ROTATION);
    }

    @Override
    public void setUUID(UUID uuid) {
        this.putUuid(UUID_LABEL, uuid);
    }

    @Override
    public UUID getUUID() {
        if (!this.hasTag(UUID_LABEL, 11)) {
            this.putUuid(UUID_LABEL, UUID.randomUUID());
        }
        return this.getUuid(UUID_LABEL);
    }

    @Override
    public void setLinkEffects(Set<LinkEffect> effects) {
        class_2499 list = new class_2499();
        list.addAll((Collection)effects.stream().map(arg_0 -> ModRegistries.LINK_EFFECTS.method_10221(arg_0)).map(class_2960::toString).map(class_2519::method_23256).collect(Collectors.toList()));
        this.putList(LINK_EFFECTS, list);
    }

    @Override
    public Set<LinkEffect> getLinkEffects() {
        if (!this.hasTag(LINK_EFFECTS, 9)) {
            this.putList(LINK_EFFECTS, new class_2499());
        }
        class_2499 list = this.getList(LINK_EFFECTS, 8);
        Set<LinkEffect> effectSet = list.stream().map(stringTag -> stringTag.method_10714()).map(class_2960::new).map(LinkEffect::get).collect(Collectors.toSet());
        return effectSet;
    }

    @Override
    public boolean addLinkEffect(LinkEffect effect) {
        Set<LinkEffect> effectSet = this.getLinkEffects();
        if (effectSet.add(effect)) {
            this.setLinkEffects(effectSet);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeLinkEffect(LinkEffect effect) {
        Set<LinkEffect> effectSet = this.getLinkEffects();
        if (effectSet.remove(effect)) {
            this.setLinkEffects(effectSet);
            return true;
        }
        return false;
    }

    @Override
    public class_2540 writeToPacketByteBuf(class_2540 buffer) {
        buffer.method_10794(this.getRootTag());
        return buffer;
    }

    @Override
    public void readFromPacketByteBuf(class_2540 buffer) {
        this.getOrCreateRootTag().method_10543(buffer.method_10798());
    }

    protected void putUuid(String key, UUID uuid) {
        if (uuid != null) {
            this.getOrCreateRootTag().method_25927(key, uuid);
        } else {
            this.remove(key);
        }
    }
}

