/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.entity;

import io.netty.buffer.Unpooled;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import thefloydman.linkingbooks.component.ItemLinkData;
import thefloydman.linkingbooks.component.ModComponents;
import thefloydman.linkingbooks.linking.LinkEffects;
import thefloydman.linkingbooks.network.packets.s2c.SpawnEntityPacket;

public abstract class ObjectEntity
extends class_1297 {
    private static final class_2940<Float> DURABILITY = class_2945.method_12791(ObjectEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<class_1799> ITEM = class_2945.method_12791(ObjectEntity.class, (class_2941)class_2943.field_13322);
    private static final String LABEL_DURABILITY = "Durability";
    private static final String LABEL_ITEM = "Item";
    private static final String LABEL_HURTTIME = "HurtTime";
    private final Class<? extends class_1792> itemClass;
    private final float maxDurability;
    public int hurtTime;

    public ObjectEntity(class_1299<? extends ObjectEntity> type, class_1937 world, Class<? extends class_1792> itemClass, float maxDurability) {
        super(type, world);
        this.itemClass = itemClass;
        this.maxDurability = maxDurability;
        this.setDurability(this.getMaxDurability());
        this.hurtTime = 0;
    }

    public ObjectEntity(class_1299<? extends ObjectEntity> type, class_1937 world, Class<? extends class_1792> itemClass, float maxDurability, class_1799 item) {
        this(type, world, itemClass, maxDurability);
        this.setItem(item);
    }

    public boolean method_5732() {
        return this.method_5805();
    }

    protected void method_5693() {
        this.field_6011.method_12784(DURABILITY, (Object)Float.valueOf(1.0f));
        this.field_6011.method_12784(ITEM, (Object)class_1799.field_8037);
    }

    protected void method_5749(class_2487 compound) {
        if (compound.method_10573(LABEL_DURABILITY, 99)) {
            this.setDurability(compound.method_10583(LABEL_DURABILITY));
        }
        if (compound.method_10573(LABEL_ITEM, 10)) {
            class_1799 stack = class_1799.method_7915((class_2487)compound.method_10562(LABEL_ITEM));
            if (this.itemClass.isInstance(stack.method_7909())) {
                this.setItem(stack);
            } else {
                this.setItem(class_1799.field_8037);
            }
        }
        this.hurtTime = compound.method_10568(LABEL_HURTTIME);
    }

    protected void method_5652(class_2487 compound) {
        compound.method_10548(LABEL_DURABILITY, this.getDurability());
        class_1799 item = this.getItem();
        ItemLinkData data = (ItemLinkData)ModComponents.ITEM_LINK_DATA.get((Object)item);
        if (!data.getLinkEffects().contains(LinkEffects.DUMMY)) {
            data.addLinkEffect(LinkEffects.DUMMY);
        }
        compound.method_10566(LABEL_ITEM, (class_2520)item.method_7953(new class_2487()));
        compound.method_10575(LABEL_HURTTIME, (short)this.hurtTime);
    }

    public class_2596<?> method_18002() {
        class_2540 buf = new SpawnEntityPacket(this).toData(new class_2540(Unpooled.buffer()));
        return ServerPlayNetworking.createS2CPacket((class_2960)SpawnEntityPacket.CHANNEL, (class_2540)buf);
    }

    public final float getMaxDurability() {
        return this.maxDurability;
    }

    public float getDurability() {
        return ((Float)this.field_6011.method_12789(DURABILITY)).floatValue();
    }

    public void setDurability(float health) {
        this.field_6011.method_12778(DURABILITY, (Object)Float.valueOf(class_3532.method_15363((float)health, (float)0.0f, (float)this.getMaxDurability())));
    }

    public class_1799 getItem() {
        return (class_1799)this.field_6011.method_12789(ITEM);
    }

    public void setItem(class_1799 item) {
        this.field_6011.method_12778(ITEM, (Object)item);
    }

    public boolean method_5643(class_1282 source, float amount) {
        this.hurtTime = 10;
        this.setDurability(this.getDurability() - amount);
        return super.method_5643(source, amount);
    }

    public void method_5670() {
        super.method_5670();
        if (this.getItem().method_7960() || this.getDurability() <= 0.0f) {
            this.onKilled();
        }
        if (this.hurtTime > 0) {
            --this.hurtTime;
        }
        if (!this.method_5740()) {
            this.method_18799(this.method_18798().method_1031(0.0, -0.04, 0.0));
        }
        class_243 vec3d = this.method_18798();
        double d1 = vec3d.field_1352;
        double d3 = vec3d.field_1351;
        double d5 = vec3d.field_1350;
        if (this.field_5952) {
            d1 *= 0.8;
            d5 *= 0.8;
        }
        if (Math.abs(vec3d.field_1352) < 0.003) {
            d1 = 0.0;
        }
        if (Math.abs(vec3d.field_1351) < 0.003) {
            d3 = 0.0;
        }
        if (Math.abs(vec3d.field_1350) < 0.003) {
            d5 = 0.0;
        }
        this.method_18800(d1, d3, d5);
        this.method_5784(class_1313.field_6308, this.method_18798());
    }

    public void onKilled() {
        this.method_5768();
    }

    public void method_5694(class_1657 player) {
        if (this.method_5739((class_1297)player) < 0.75f) {
            player.method_5697((class_1297)this);
        }
    }

    public boolean method_30948() {
        return this.method_5805();
    }

    public boolean method_5863() {
        return this.method_5805();
    }

    public boolean method_5810() {
        return this.method_5805();
    }

    @Environment(value=EnvType.CLIENT)
    public boolean method_5640(double distance) {
        double d0 = this.method_5829().method_995();
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 = d0 * 256.0 * ObjectEntity.method_5824()) * d0;
    }
}

