/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.util;

import io.netty.buffer.Unpooled;
import java.util.List;
import me.sargunvohra.mcmods.autoconfig1u.AutoConfig;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thefloydman.linkingbooks.api.component.ColorComponent;
import thefloydman.linkingbooks.api.component.LinkDataComponent;
import thefloydman.linkingbooks.api.linking.LinkEffect;
import thefloydman.linkingbooks.component.ModComponents;
import thefloydman.linkingbooks.config.ModConfig;
import thefloydman.linkingbooks.entity.LinkingBookEntity;
import thefloydman.linkingbooks.item.BlankLinkingBookItem;
import thefloydman.linkingbooks.item.ModItems;
import thefloydman.linkingbooks.linking.LinkEffects;
import thefloydman.linkingbooks.network.packets.s2c.TakeScreenshotForLinkingBookPacket;

public class LinkingUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    public static class_1799 createWrittenLinkingBookfromBlankLinkingBook(class_1657 player, class_1799 originItem) {
        if (!(originItem.method_7909() instanceof BlankLinkingBookItem)) {
            return originItem;
        }
        class_1799 resultItem = ModItems.WRITTEN_LINKING_BOOK.method_7854();
        ColorComponent originColor = (ColorComponent)ModComponents.ITEM_COLOR.get((Object)originItem);
        ColorComponent resultColor = (ColorComponent)ModComponents.ITEM_COLOR.get((Object)resultItem);
        resultColor.setColor(originColor.getColor());
        LinkDataComponent linkData = (LinkDataComponent)ModComponents.ITEM_LINK_DATA.get((Object)resultItem);
        linkData.setDimension(player.method_5770().method_27983().method_29177());
        linkData.setPosition(player.method_24515());
        linkData.setRotation(player.field_6031);
        linkData.addLinkEffect(LinkEffects.DUMMY);
        ServerPlayNetworking.send((class_3222)((class_3222)player), (class_2960)TakeScreenshotForLinkingBookPacket.CHANNEL, (class_2540)new TakeScreenshotForLinkingBookPacket(linkData.getUUID()).toData(new class_2540(Unpooled.buffer())));
        return resultItem;
    }

    public static boolean linkEntity(class_1297 entity, LinkDataComponent linkData, boolean holdingBook) {
        class_1937 world = entity.method_5770();
        if (world.method_8608()) {
            LOGGER.info("An attempt has been made to directly link an entity from the client. Only do this from the server.");
        } else if (linkData == null) {
            LOGGER.info("A null ILinkInfo has been supplied. Link failed.");
        } else if (linkData.getDimension() == null) {
            LOGGER.info("ILinkInfo.getDimension() returned null. Link failed.");
        } else if (linkData.getPosition() == null) {
            LOGGER.info("ILinkInfo.getPosition() returned null. Link failed.");
        } else if (!linkData.getLinkEffects().contains(LinkEffects.INTRAAGE_LINKING) && world.method_27983().method_29177().equals((Object)linkData.getDimension())) {
            if (entity instanceof class_1657) {
                class_3222 player = (class_3222)entity;
                player.method_7346();
                player.method_14247();
                player.method_7353((class_2561)new class_2588("message.linkingbooks.no_intraage_linking"), true);
            }
        } else {
            class_3218 serverWorld = world.method_8503().method_3847(class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)linkData.getDimension()));
            if (serverWorld == null) {
                LOGGER.info("Cannot find dimension \"" + linkData.getDimension().toString() + "\". Link failed.");
                return false;
            }
            for (LinkEffect effect : linkData.getLinkEffects()) {
                effect.onLinkStart(entity, linkData);
            }
            class_2338 pos = linkData.getPosition();
            double x = (double)pos.method_10263() + 0.5;
            double y = pos.method_10264();
            double z = (double)pos.method_10260() + 0.5;
            float rotation = linkData.getRotation();
            if (entity instanceof class_3222) {
                class_3222 player = (class_3222)entity;
                if (holdingBook) {
                    LinkingBookEntity book = new LinkingBookEntity(world, player.method_6047().method_7972());
                    class_243 lookVec = player.method_5720();
                    book.method_5641(player.method_23317() + lookVec.method_10216() / 4.0, player.method_23318() + 1.0, player.method_23321() + lookVec.method_10215() / 4.0, player.field_6241, 0.0f);
                    world.method_8649((class_1297)book);
                    player.method_6047().method_7934(1);
                }
                player.method_14247();
                player.method_7346();
                world.method_8503().execute(() -> player.method_14251(serverWorld, x, y, z, rotation, player.field_5965));
                ModConfig config = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
                player.method_7255(config.linkingCostExperiencePoints * -1);
                player.method_7316(config.linkingCostExperienceLevels * -1);
                if (player.field_7520 < 0) {
                    player.method_7316(config.linkingCostExperienceLevels);
                    player.method_7255(config.linkingCostExperiencePoints);
                    player.method_7346();
                    player.method_14247();
                    player.method_7353((class_2561)new class_2588("message.linkingbooks.insufficient_experience"), true);
                    return false;
                }
            } else {
                entity.method_5866((class_1937)serverWorld);
                entity.method_20620(x, y, z);
            }
            for (LinkEffect effect : linkData.getLinkEffects()) {
                effect.onLinkEnd(entity, linkData);
            }
            return true;
        }
        return false;
    }

    public static int linkEntities(List<class_1297> entities, LinkDataComponent linkInfo, boolean holdingBook) {
        int linked = 0;
        for (class_1297 entity : entities) {
            linked += LinkingUtils.linkEntity(entity, linkInfo, holdingBook) ? 1 : 0;
        }
        return linked;
    }
}

