/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thefloydman.linkingbooks.block.ModBlocks;
import thefloydman.linkingbooks.capability.ColorCapability;
import thefloydman.linkingbooks.capability.LinkData;
import thefloydman.linkingbooks.client.gui.screen.LinkingBookScreen;
import thefloydman.linkingbooks.client.renderer.entity.LinkingBookRenderer;
import thefloydman.linkingbooks.client.renderer.tileentity.LinkingLecternRenderer;
import thefloydman.linkingbooks.config.ModConfig;
import thefloydman.linkingbooks.entity.ModEntityTypes;
import thefloydman.linkingbooks.fluid.ModFluids;
import thefloydman.linkingbooks.inventory.container.ModContainerTypes;
import thefloydman.linkingbooks.item.LinkingBookItem;
import thefloydman.linkingbooks.item.ModItems;
import thefloydman.linkingbooks.item.crafting.ModRecipeSerializers;
import thefloydman.linkingbooks.linking.LinkEffects;
import thefloydman.linkingbooks.network.ModNetworkHandler;
import thefloydman.linkingbooks.tileentity.ModTileEntityTypes;

@Mod(value="linkingbooks")
public class LinkingBooks {
    public static final Logger LOGGER = LogManager.getLogger();

    public LinkingBooks() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModBlocks.BLOCKS.register(eventBus);
        ModItems.ITEMS.register(eventBus);
        ModFluids.FLUIDS.register(eventBus);
        ModEntityTypes.ENTITIES.register(eventBus);
        ModTileEntityTypes.TILE_ENTITIES.register(eventBus);
        ModContainerTypes.CONTAINERS.register(eventBus);
        LinkEffects.LINK_EFFECTS.register(eventBus);
        ModRecipeSerializers.RECIPES.register(eventBus);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, ModConfig.SPEC, "linkingbooks.toml");
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        ModNetworkHandler.registerAllMessages();
        LinkData.register();
        ColorCapability.register();
    }

    private void clientSetup(FMLClientSetupEvent event) {
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntityTypes.LINKING_BOOK.get()), LinkingBookRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)ModTileEntityTypes.LINKING_LECTERN.get()), LinkingLecternRenderer::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainerTypes.LINKING_BOOK.get()), LinkingBookScreen::new);
        ItemColors itemColors = Minecraft.func_71410_x().getItemColors();
        itemColors.func_199877_a((stack, index) -> LinkingBookItem.getColor(stack, index), new IItemProvider[]{(IItemProvider)ModItems.BLANK_LINKING_BOOK.get()});
        itemColors.func_199877_a((stack, index) -> LinkingBookItem.getColor(stack, index), new IItemProvider[]{(IItemProvider)ModItems.WRITTEN_LINKING_BOOK.get()});
    }
}

