/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.item;

import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import thefloydman.linkingbooks.api.capability.IColorCapability;
import thefloydman.linkingbooks.capability.ColorCapability;
import thefloydman.linkingbooks.capability.LinkingBookCapabilityProvider;

public abstract class LinkingBookItem
extends Item {
    public LinkingBookItem(Item.Properties properties) {
        super(properties);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return new LinkingBookCapabilityProvider();
    }

    public static int getColor(ItemStack stack, int tintIndex) {
        if (tintIndex != 0) {
            return -1;
        }
        IColorCapability color = (IColorCapability)stack.getCapability(ColorCapability.COLOR).orElse(null);
        if (color != null) {
            return color.getColor();
        }
        return DyeColor.GREEN.getColorValue();
    }

    public CompoundNBT getShareTag(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        IColorCapability color = (IColorCapability)stack.getCapability(ColorCapability.COLOR).orElse(null);
        if (color != null) {
            CompoundNBT tag = color.writeToShareTag(nbt);
            return tag;
        }
        return nbt;
    }

    public void readShareTag(ItemStack stack, CompoundNBT nbt) {
        IColorCapability color;
        stack.func_77982_d(nbt);
        if (nbt != null && (color = (IColorCapability)stack.getCapability(ColorCapability.COLOR).orElse(null)) != null) {
            color.readFromShareTag(nbt);
        }
    }
}

