/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.item.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;
import thefloydman.linkingbooks.api.capability.IColorCapability;
import thefloydman.linkingbooks.capability.ColorCapability;
import thefloydman.linkingbooks.item.ModItems;
import thefloydman.linkingbooks.item.crafting.ModRecipeSerializers;

public class BlankLinkingBookRecipe
implements ICraftingRecipe {
    private final ResourceLocation id;
    private final ItemStack recipeOutput;
    private final NonNullList<Ingredient> recipeInputs;

    public BlankLinkingBookRecipe(ResourceLocation id, ItemStack recipeOutput, NonNullList<Ingredient> recipeInput) {
        this.id = id;
        this.recipeOutput = recipeOutput;
        this.recipeInputs = recipeInput;
    }

    public boolean matches(CraftingInventory inventory, World world) {
        RecipeItemHelper recipeItemHelper = new RecipeItemHelper();
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int i = 0;
        NonNullList craftingInputs = NonNullList.func_191196_a();
        for (int j = 0; j < inventory.func_70302_i_(); ++j) {
            ItemStack stack = inventory.func_70301_a(j);
            if (stack.func_190926_b()) continue;
            ++i;
            inputs.add(stack);
            craftingInputs.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{inventory.func_70301_a(j)}));
        }
        boolean matches = true;
        for (int j = 0; j < craftingInputs.size(); ++j) {
            boolean foundMatch = false;
            block2: for (int k = 0; k < this.recipeInputs.size(); ++k) {
                ItemStack[] stacks;
                for (ItemStack stack : stacks = ((Ingredient)this.recipeInputs.get(k)).func_193365_a()) {
                    if (stack.func_77973_b() != ((Ingredient)craftingInputs.get(j)).func_193365_a()[0].func_77973_b()) continue;
                    foundMatch = true;
                    continue block2;
                }
            }
            if (foundMatch) continue;
            matches = false;
            break;
        }
        return i == this.recipeInputs.size() && matches;
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        return this.recipeOutput.func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= this.recipeInputs.size();
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipeSerializers.BLANK_LINKING_BOOK.get();
    }

    public ItemStack func_77571_b() {
        return this.recipeOutput;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.recipeInputs;
    }

    private static NonNullList<Ingredient> readIngredients(JsonArray array) {
        NonNullList nonnulllist = NonNullList.func_191196_a();
        for (int i = 0; i < array.size(); ++i) {
            Ingredient ingredient = Ingredient.func_199802_a((JsonElement)array.get(i));
            if (ingredient.func_203189_d()) continue;
            nonnulllist.add((Object)ingredient);
        }
        return nonnulllist;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<BlankLinkingBookRecipe> {
        public BlankLinkingBookRecipe read(ResourceLocation id, JsonObject json) {
            ItemStack stack;
            IColorCapability color;
            NonNullList nonnulllist = BlankLinkingBookRecipe.readIngredients(JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients"));
            if (nonnulllist.isEmpty()) {
                throw new JsonParseException("No ingredients for blank linking book recipe");
            }
            if (nonnulllist.size() > 9) {
                throw new JsonParseException("Too many ingredients for blank linking book recipe the max is 9");
            }
            float red = 0.0f;
            float green = 0.0f;
            float blue = 0.0f;
            if (json.has("color") && json.get("color").isJsonObject()) {
                JsonObject color2 = json.getAsJsonObject("color");
                if (color2.has("red") && color2.get("red").isJsonPrimitive()) {
                    red = color2.get("red").getAsFloat();
                }
                if (color2.has("green") && color2.get("green").isJsonPrimitive()) {
                    green = color2.get("green").getAsFloat();
                }
                if (color2.has("blue") && color2.get("blue").isJsonPrimitive()) {
                    blue = color2.get("blue").getAsFloat();
                }
            }
            if ((color = (IColorCapability)(stack = ((Item)ModItems.BLANK_LINKING_BOOK.get()).func_190903_i()).getCapability(ColorCapability.COLOR).orElse(null)) != null) {
                color.setColor(new Color(red, green, blue).getRGB());
            }
            return new BlankLinkingBookRecipe(id, stack, (NonNullList<Ingredient>)nonnulllist);
        }

        public BlankLinkingBookRecipe read(ResourceLocation id, PacketBuffer buffer) {
            int i = buffer.func_150792_a();
            NonNullList nonnulllist = NonNullList.func_191197_a((int)i, (Object)Ingredient.field_193370_a);
            for (int j = 0; j < nonnulllist.size(); ++j) {
                nonnulllist.set(j, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            ItemStack itemstack = buffer.func_150791_c();
            return new BlankLinkingBookRecipe(id, itemstack, (NonNullList<Ingredient>)nonnulllist);
        }

        public void write(PacketBuffer buffer, BlankLinkingBookRecipe recipe) {
            buffer.func_150787_b(recipe.recipeInputs.size());
            for (Ingredient ingredient : recipe.recipeInputs) {
                ingredient.func_199564_a(buffer);
            }
            buffer.func_150788_a(recipe.recipeOutput);
        }
    }
}

