/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.network.packets;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Util;
import net.minecraftforge.fml.network.NetworkEvent;
import thefloydman.linkingbooks.network.ModNetworkHandler;
import thefloydman.linkingbooks.network.packets.IMessage;
import thefloydman.linkingbooks.network.packets.SaveLinkingPanelImageMessage;
import thefloydman.linkingbooks.util.ImageUtils;

public class TakeScreenshotForLinkingBookMessage
implements IMessage {
    private UUID uuid;

    public TakeScreenshotForLinkingBookMessage(UUID uuid) {
        this.uuid = uuid;
    }

    public TakeScreenshotForLinkingBookMessage() {
        this(UUID.randomUUID());
    }

    @Override
    public PacketBuffer toData(PacketBuffer buffer) {
        buffer.func_179252_a(this.uuid);
        return buffer;
    }

    @Override
    public void fromData(PacketBuffer buffer) {
        this.uuid = buffer.func_179253_g();
    }

    @Override
    public void handle(NetworkEvent.Context ctx) {
        ctx.enqueueWork(() -> {
            if (RenderSystem.isOnRenderThread()) {
                this.getScreenshot();
            } else {
                RenderSystem.recordRenderCall(() -> this.getScreenshot());
            }
            ctx.setPacketHandled(true);
        });
    }

    private void getScreenshot() {
        Minecraft mc = Minecraft.func_71410_x();
        Framebuffer buffer = mc.func_147110_a();
        float largeWidth = buffer.field_147621_c;
        float largeHeight = buffer.field_147618_d;
        float smallWidth = 64.0f;
        float smallHeight = 42.0f;
        if (largeWidth / largeHeight > smallWidth / smallHeight) {
            while (largeHeight % 42.0f != 0.0f) {
                largeHeight -= 1.0f;
            }
            while (largeWidth / largeHeight != smallWidth / smallHeight) {
                largeWidth -= 1.0f;
            }
        } else if (largeWidth / largeHeight < smallWidth / smallHeight) {
            while (largeWidth % 64.0f != 0.0f) {
                largeWidth -= 1.0f;
            }
            while (largeWidth / largeHeight != smallWidth / smallHeight) {
                largeHeight -= 1.0f;
            }
        }
        NativeImage fullImage = new NativeImage(buffer.field_147622_a, buffer.field_147620_b, false);
        mc.func_147110_a().func_147610_a(true);
        boolean hide = mc.field_71474_y.field_74319_N;
        mc.field_71474_y.field_74319_N = true;
        mc.field_71460_t.func_228378_a_(mc.func_184121_ak(), Util.func_211178_c(), new MatrixStack());
        mc.field_71474_y.field_74319_N = hide;
        buffer.func_147612_c();
        fullImage.func_195717_a(0, true);
        mc.func_147110_a().func_147609_e();
        fullImage.func_195710_e();
        NativeImage largeImage = new NativeImage((int)largeWidth, (int)largeHeight, false);
        int initialX = (int)(((float)buffer.field_147621_c - largeWidth) / 2.0f);
        int initialY = (int)(((float)buffer.field_147618_d - largeHeight) / 2.0f);
        int largeY = 0;
        int fullY = initialY;
        while ((float)largeY < largeHeight) {
            int largeX = 0;
            int fullX = initialX;
            while ((float)largeX < largeWidth) {
                largeImage.func_195700_a(largeX, largeY, fullImage.func_195709_a(fullX, fullY));
                ++largeX;
                ++fullX;
            }
            ++largeY;
            ++fullY;
        }
        NativeImage smallImage = new NativeImage((int)smallWidth, (int)smallHeight, false);
        largeImage.func_195708_a(0, 0, (int)largeWidth, (int)largeHeight, smallImage);
        largeImage.close();
        fullImage.close();
        ModNetworkHandler.sendToServer(new SaveLinkingPanelImageMessage(ImageUtils.imageToNBT(smallImage), this.uuid));
    }
}

