/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.util;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thefloydman.linkingbooks.api.capability.IColorCapability;
import thefloydman.linkingbooks.api.capability.ILinkData;
import thefloydman.linkingbooks.api.linking.LinkEffect;
import thefloydman.linkingbooks.capability.ColorCapability;
import thefloydman.linkingbooks.capability.LinkData;
import thefloydman.linkingbooks.config.ModConfig;
import thefloydman.linkingbooks.entity.LinkingBookEntity;
import thefloydman.linkingbooks.inventory.container.LinkingBookContainer;
import thefloydman.linkingbooks.item.ModItems;
import thefloydman.linkingbooks.linking.LinkEffects;
import thefloydman.linkingbooks.network.ModNetworkHandler;
import thefloydman.linkingbooks.network.packets.TakeScreenshotForLinkingBookMessage;
import thefloydman.linkingbooks.world.storage.LinkingBooksGlobalSavedData;

public class LinkingUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    public static ItemStack createWrittenLinkingBook(PlayerEntity player, ItemStack originItem) {
        ItemStack resultItem = ((Item)ModItems.WRITTEN_LINKING_BOOK.get()).func_190903_i();
        ILinkData linkData = (ILinkData)resultItem.getCapability(LinkData.LINK_DATA).orElse(null);
        if (linkData == null) {
            return ItemStack.field_190927_a;
        }
        linkData.setDimension(player.func_130014_f_().func_234923_W_().func_240901_a_());
        linkData.setPosition(player.func_233580_cy_());
        linkData.setRotation(player.field_70177_z);
        IColorCapability originColor = (IColorCapability)originItem.getCapability(ColorCapability.COLOR).orElse(null);
        IColorCapability resultColor = (IColorCapability)resultItem.getCapability(ColorCapability.COLOR).orElse(null);
        if (originColor == null || resultColor == null) {
            return ItemStack.field_190927_a;
        }
        resultColor.setColor(originColor.getColor());
        ModNetworkHandler.sendToPlayer(new TakeScreenshotForLinkingBookMessage(linkData.getUUID()), (ServerPlayerEntity)player);
        return resultItem;
    }

    public static boolean linkEntity(Entity entity, ILinkData linkData, boolean holdingBook) {
        World world = entity.func_130014_f_();
        if (world.func_201670_d()) {
            LOGGER.info("An attempt has been made to directly link an entity from the client. Only do this from the server.");
        } else if (linkData == null) {
            LOGGER.info("An null ILinkInfo has been supplied. Link failed.");
        } else if (linkData.getDimension() == null) {
            LOGGER.info("ILinkInfo::getDimension returned null. Link failed.");
        } else if (linkData.getPosition() == null) {
            LOGGER.info("ILinkInfo::getPosition returned null. Link failed.");
        } else if (!linkData.getLinkEffects().contains(LinkEffects.INTRAAGE_LINKING.get()) && world.func_234923_W_().func_240901_a_().equals((Object)linkData.getDimension())) {
            if (entity instanceof PlayerEntity) {
                ServerPlayerEntity player = (ServerPlayerEntity)entity;
                player.func_71053_j();
                player.func_71128_l();
                player.func_146105_b((ITextComponent)new TranslationTextComponent("message.linkingbooks.no_intraage_linking"), true);
            }
        } else {
            ServerWorld serverWorld = world.func_73046_m().func_71218_a(RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)linkData.getDimension()));
            if (serverWorld == null) {
                LOGGER.info("Cannot find dimension \"" + linkData.getDimension().toString() + "\". Link failed.");
                return false;
            }
            for (LinkEffect effect : linkData.getLinkEffects()) {
                effect.onLinkStart(entity, linkData);
            }
            BlockPos pos = linkData.getPosition();
            double x = (double)pos.func_177958_n() + 0.5;
            double y = pos.func_177956_o();
            double z = (double)pos.func_177952_p() + 0.5;
            float rotation = linkData.getRotation();
            ServerPlayerEntity player = (ServerPlayerEntity)entity;
            if (entity instanceof ServerPlayerEntity) {
                if (holdingBook) {
                    LinkingBookEntity book = new LinkingBookEntity(world, player.func_184614_ca().func_77946_l());
                    Vector3d lookVec = player.func_70040_Z();
                    book.func_70107_b(player.func_226277_ct_() + lookVec.func_82615_a() / 4.0, player.func_226278_cu_() + 1.0, player.func_226281_cx_() + lookVec.func_82616_c() / 4.0);
                    book.field_70177_z = player.field_70759_as;
                    world.func_217376_c((Entity)book);
                    player.func_184614_ca().func_190918_g(1);
                }
                player.func_71128_l();
                player.func_71053_j();
                player.func_200619_a(serverWorld, x, y, z, rotation, player.field_70125_A);
                player.func_195068_e((Integer)ModConfig.COMMON.linkingCostExperiencePoints.get() * -1);
                player.func_82242_a((Integer)ModConfig.COMMON.linkingCostExperienceLevels.get() * -1);
                if (player.field_71068_ca < 0) {
                    player.func_82242_a(((Integer)ModConfig.COMMON.linkingCostExperienceLevels.get()).intValue());
                    player.func_195068_e(((Integer)ModConfig.COMMON.linkingCostExperiencePoints.get()).intValue());
                    player.func_71053_j();
                    player.func_71128_l();
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("message.linkingbooks.insufficient_experience"), true);
                    return false;
                }
            } else {
                entity.func_70029_a((World)serverWorld);
                entity.func_223102_j(x, y, z);
            }
            for (LinkEffect effect : linkData.getLinkEffects()) {
                effect.onLinkEnd(entity, linkData);
            }
            return true;
        }
        return false;
    }

    public static int linkEntities(List<Entity> entities, ILinkData linkInfo, boolean holdingBook) {
        int linked = 0;
        for (Entity entity : entities) {
            linked += LinkingUtils.linkEntity(entity, linkInfo, holdingBook) ? 1 : 0;
        }
        return linked;
    }

    public static void openLinkingBookGui(ServerPlayerEntity player, boolean holdingBook, int color, ILinkData linkData, ResourceLocation currentDimension) {
        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)new SimpleNamedContainerProvider((id, playerInventory, playerEntity) -> new LinkingBookContainer(id, playerInventory), (ITextComponent)new StringTextComponent("")), extraData -> {
            extraData.writeBoolean(holdingBook);
            extraData.writeInt(color);
            linkData.write((PacketBuffer)extraData);
            boolean canLink = !currentDimension.equals((Object)linkData.getDimension()) || linkData.getLinkEffects().contains(LinkEffects.INTRAAGE_LINKING.get());
            extraData.writeBoolean(canLink);
            LinkingBooksGlobalSavedData savedData = (LinkingBooksGlobalSavedData)player.func_184102_h().func_71218_a(World.field_234918_g_).func_217481_x().func_215752_a(LinkingBooksGlobalSavedData::new, "linkingbooks");
            CompoundNBT image = savedData.getLinkingPanelImage(linkData.getUUID());
            extraData.func_150786_a(image);
        });
    }
}

