/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.capability;

import javax.annotation.Nullable;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import thefloydman.linkingbooks.api.capability.IColorCapability;

public class ColorCapability {
    @CapabilityInject(value=IColorCapability.class)
    public static final Capability<IColorCapability> COLOR = null;

    public static void register() {
        CapabilityManager.INSTANCE.register(IColorCapability.class, (Capability.IStorage)new Storage(), Default::new);
    }

    public static class Provider
    implements ICapabilitySerializable<INBT> {
        private LazyOptional<IColorCapability> instance = LazyOptional.of(() -> (IColorCapability)COLOR.getDefaultInstance());

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            if (cap.equals(COLOR) && COLOR != null) {
                return this.instance.cast();
            }
            return LazyOptional.empty();
        }

        public INBT serializeNBT() {
            return COLOR.getStorage().writeNBT(COLOR, this.instance.orElse(COLOR.getDefaultInstance()), null);
        }

        public void deserializeNBT(INBT nbt) {
            COLOR.getStorage().readNBT(COLOR, this.instance.orElse(COLOR.getDefaultInstance()), null, nbt);
        }
    }

    public static class Storage
    implements Capability.IStorage<IColorCapability> {
        @Nullable
        public INBT writeNBT(Capability<IColorCapability> capability, IColorCapability instance, Direction side) {
            return IntNBT.func_229692_a_((int)instance.getColor());
        }

        public void readNBT(Capability<IColorCapability> capability, IColorCapability instance, Direction side, INBT nbt) {
            if (nbt instanceof IntNBT) {
                instance.setColor(((IntNBT)nbt).func_150287_d());
            }
        }
    }

    public static class Default
    implements IColorCapability {
        private int color = DyeColor.GREEN.getColorValue();

        @Override
        public void setColor(int color) {
            this.color = color;
        }

        @Override
        public int getColor() {
            return this.color;
        }

        @Override
        public CompoundNBT writeToShareTag(CompoundNBT nbt) {
            CompoundNBT tag = new CompoundNBT();
            if (nbt != null) {
                tag = nbt.func_74737_b();
            }
            tag.func_218657_a("color", COLOR.writeNBT((Object)this, null));
            return tag;
        }

        @Override
        public void readFromShareTag(CompoundNBT nbt) {
            if (nbt != null && nbt.func_150297_b("color", 3)) {
                COLOR.readNBT((Object)this, null, nbt.func_74781_a("color"));
            }
        }
    }
}

