/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.capability;

import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import thefloydman.linkingbooks.api.capability.IColorCapability;
import thefloydman.linkingbooks.api.capability.ILinkData;
import thefloydman.linkingbooks.capability.ColorCapability;
import thefloydman.linkingbooks.capability.LinkData;

public class LinkingBookCapabilityProvider
implements ICapabilitySerializable<INBT> {
    private LazyOptional<IColorCapability> bookColor = LazyOptional.of(() -> (IColorCapability)ColorCapability.COLOR.getDefaultInstance());
    private LazyOptional<ILinkData> linkData = LazyOptional.of(() -> (ILinkData)LinkData.LINK_DATA.getDefaultInstance());

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap.equals(LinkData.LINK_DATA) && LinkData.LINK_DATA != null) {
            return this.linkData.cast();
        }
        if (cap.equals(ColorCapability.COLOR) && ColorCapability.COLOR != null) {
            return this.bookColor.cast();
        }
        return LazyOptional.empty();
    }

    public INBT serializeNBT() {
        INBT colorNBT = ColorCapability.COLOR.getStorage().writeNBT(ColorCapability.COLOR, this.bookColor.orElse(ColorCapability.COLOR.getDefaultInstance()), null);
        INBT linkNBT = LinkData.LINK_DATA.getStorage().writeNBT(LinkData.LINK_DATA, this.linkData.orElse(LinkData.LINK_DATA.getDefaultInstance()), null);
        CompoundNBT compound = new CompoundNBT();
        compound.func_218657_a("color", colorNBT);
        compound.func_218657_a("link_data", linkNBT);
        return compound;
    }

    public void deserializeNBT(INBT nbt) {
        if (nbt.func_225647_b_().equals(CompoundNBT.field_229675_a_)) {
            CompoundNBT compound = (CompoundNBT)nbt;
            if (compound.func_150297_b("color", 3)) {
                ColorCapability.COLOR.getStorage().readNBT(ColorCapability.COLOR, this.bookColor.orElse(ColorCapability.COLOR.getDefaultInstance()), null, compound.func_74781_a("color"));
            }
            if (compound.func_150297_b("link_data", 10)) {
                LinkData.LINK_DATA.getStorage().readNBT(LinkData.LINK_DATA, this.linkData.orElse(LinkData.LINK_DATA.getDefaultInstance()), null, compound.func_74781_a("link_data"));
            }
        }
    }
}

