/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.client.gui.widget;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.FloatBuffer;
import java.util.List;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class NestedWidget
extends Widget {
    public float zLevel = 0.0f;
    protected final List<NestedWidget> children = Lists.newArrayList();
    protected final List<IGuiEventListener> listeners = Lists.newArrayList();

    public NestedWidget(int x, int y, int width, int height, ITextComponent narration) {
        super(x, y, width, height, narration);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.renderChildren(matrixStack, mouseX, mouseY, partialTicks);
    }

    public void renderChildren(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        for (NestedWidget widget : this.children) {
            widget.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        return this.onMouseClickChildren(mouseX, mouseY, button);
    }

    public boolean onMouseClickChildren(double mouseX, double mouseY, int button) {
        boolean eatenGeneral = false;
        for (NestedWidget widget : this.children) {
            boolean eatenChild = widget.func_231044_a_(mouseX, mouseY, button);
            eatenGeneral = eatenChild ? eatenChild : eatenGeneral;
        }
        return eatenGeneral;
    }

    public boolean isInside(double x, double y) {
        return x >= (double)this.field_230690_l_ && x < (double)(this.field_230690_l_ + this.field_230688_j_) && y >= (double)this.field_230691_m_ && y < (double)(this.field_230691_m_ + this.field_230689_k_);
    }

    public <T extends NestedWidget> T addChild(T widget) {
        this.children.add(widget);
        return widget;
    }

    public void addListener(IGuiEventListener listener) {
        this.listeners.add(listener);
    }

    public void zFill(MatrixStack matrixStack, int xStart, int yStart, int xEnd, int yEnd, int color) {
        int endUpdated;
        if (xStart < xEnd) {
            endUpdated = xStart;
            xStart = xEnd;
            xEnd = endUpdated;
        }
        if (yStart < yEnd) {
            endUpdated = yStart;
            yStart = yEnd;
            yEnd = endUpdated;
        }
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        BufferBuilder bufferBuilder = Tessellator.func_178181_a().func_178180_c();
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.defaultBlendFunc();
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferBuilder.func_227888_a_(matrix, (float)xStart, (float)yEnd, this.zLevel).func_227885_a_(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_227888_a_(matrix, (float)xEnd, (float)yEnd, this.zLevel).func_227885_a_(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_227888_a_(matrix, (float)xEnd, (float)yStart, this.zLevel).func_227885_a_(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_227888_a_(matrix, (float)xStart, (float)yStart, this.zLevel).func_227885_a_(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferBuilder);
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    public void point(MatrixStack matrixStack, int x, int y, int color) {
        this.zFill(matrixStack, x, y, x + 1, y + 1, color);
    }

    public static float zDifference(MatrixStack matrixStack, float zLevel) {
        FloatBuffer floatBuffer = FloatBuffer.allocate(16);
        matrixStack.func_227866_c_().func_227870_a_().func_195879_b(floatBuffer);
        float currentZ = floatBuffer.get(10);
        return zLevel - currentZ < 0.0f ? zLevel - MathHelper.func_76135_e((float)currentZ) : zLevel + MathHelper.func_76135_e((float)currentZ);
    }
}

