/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.client.renderer.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.awt.Color;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import thefloydman.linkingbooks.api.capability.IColorCapability;
import thefloydman.linkingbooks.capability.ColorCapability;
import thefloydman.linkingbooks.client.renderer.entity.model.LinkingBookCoverModel;
import thefloydman.linkingbooks.client.renderer.entity.model.LinkingBookPagesModel;
import thefloydman.linkingbooks.entity.LinkingBookEntity;
import thefloydman.linkingbooks.item.WrittenLinkingBookItem;
import thefloydman.linkingbooks.util.Reference;

public class LinkingBookRenderer
extends EntityRenderer<LinkingBookEntity> {
    private LinkingBookCoverModel coverModel = new LinkingBookCoverModel();
    private LinkingBookPagesModel pagesModel = new LinkingBookPagesModel();
    private float[] color = new float[]{0.0f, 1.0f, 0.0f};

    public LinkingBookRenderer(EntityRendererManager renderManager) {
        super(renderManager);
        this.coverModel.setBookState(0.9f);
        this.pagesModel.setBookState(0.9f);
    }

    public void render(LinkingBookEntity entity, float yaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight) {
        IColorCapability color;
        Item item;
        ItemStack bookStack = entity.getItem();
        if (bookStack != null && !bookStack.func_190926_b() && (item = bookStack.func_77973_b()) != null && item instanceof WrittenLinkingBookItem && (color = (IColorCapability)bookStack.getCapability(ColorCapability.COLOR).orElse(null)) != null) {
            this.color = new Color(color.getColor()).getRGBColorComponents(this.color);
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(0.75f, 0.75f, 0.75f);
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229193_c_((float)Math.PI));
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(yaw / 360.0f * (float)Math.PI * 2.0f - 1.5707964f));
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229193_c_(4.712389f));
        IVertexBuilder vertexBuilder = buffer.getBuffer(this.coverModel.func_228282_a_(Reference.Resources.LINKING_BOOK_TEXTURE));
        if (entity.hurtTime > 0) {
            this.coverModel.func_225598_a_(matrixStack, vertexBuilder, packedLight, OverlayTexture.field_229196_a_, 0.7f, 0.0f, 0.0f, 0.4f);
            this.pagesModel.func_225598_a_(matrixStack, vertexBuilder, packedLight, OverlayTexture.field_229196_a_, 0.7f, 0.0f, 0.0f, 0.4f);
        } else {
            this.coverModel.func_225598_a_(matrixStack, vertexBuilder, packedLight, OverlayTexture.field_229196_a_, this.color[0], this.color[1], this.color[2], 1.0f);
            this.pagesModel.func_225598_a_(matrixStack, vertexBuilder, packedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        matrixStack.func_227865_b_();
    }

    public ResourceLocation getEntityTexture(LinkingBookEntity entity) {
        return Reference.getAsResourceLocation("textures/entity/linking_book.png");
    }

    protected boolean canRenderName(LinkingBookEntity entity) {
        return super.func_177070_b((Entity)entity) && (entity.func_94059_bO() || entity.func_145818_k_() && entity == this.field_76990_c.field_147941_i);
    }
}

