/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.client.gui.widget;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.FloatBuffer;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1159;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4587;

@Environment(value=EnvType.CLIENT)
public abstract class NestedWidget
extends class_339 {
    public float zLevel = 0.0f;
    protected final List<NestedWidget> children = Lists.newArrayList();
    protected final List<class_364> listeners = Lists.newArrayList();

    public NestedWidget(int x, int y, int width, int height, class_2561 narration) {
        super(x, y, width, height, narration);
    }

    public void method_25394(class_4587 matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.renderChildren(matrixStack, mouseX, mouseY, partialTicks);
    }

    public void renderChildren(class_4587 matrixStack, int mouseX, int mouseY, float partialTicks) {
        for (NestedWidget widget : this.children) {
            widget.method_25394(matrixStack, mouseX, mouseY, partialTicks);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        return this.onMouseClickChildren(mouseX, mouseY, button);
    }

    public boolean onMouseClickChildren(double mouseX, double mouseY, int button) {
        boolean eatenGeneral = false;
        for (NestedWidget widget : this.children) {
            boolean eatenChild = widget.method_25402(mouseX, mouseY, button);
            eatenGeneral = eatenChild ? eatenChild : eatenGeneral;
        }
        return eatenGeneral;
    }

    public boolean isInside(double x, double y) {
        return x >= (double)this.field_22760 && x < (double)(this.field_22760 + this.field_22758) && y >= (double)this.field_22761 && y < (double)(this.field_22761 + this.field_22759);
    }

    public <T extends NestedWidget> T addChild(T widget) {
        this.children.add(widget);
        return widget;
    }

    public void addListener(class_364 listener) {
        this.listeners.add(listener);
    }

    public void zFill(class_4587 matrixStack, int xStart, int yStart, int xEnd, int yEnd, int color) {
        int endUpdated;
        if (xStart < xEnd) {
            endUpdated = xStart;
            xStart = xEnd;
            xEnd = endUpdated;
        }
        if (yStart < yEnd) {
            endUpdated = yStart;
            yStart = yEnd;
            yEnd = endUpdated;
        }
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.defaultBlendFunc();
        class_1159 matrix = matrixStack.method_23760().method_23761();
        bufferBuilder.method_1328(7, class_290.field_1576);
        bufferBuilder.method_22918(matrix, (float)xStart, (float)yEnd, this.zLevel).method_22915(red, green, blue, alpha).method_1344();
        bufferBuilder.method_22918(matrix, (float)xEnd, (float)yEnd, this.zLevel).method_22915(red, green, blue, alpha).method_1344();
        bufferBuilder.method_22918(matrix, (float)xEnd, (float)yStart, this.zLevel).method_22915(red, green, blue, alpha).method_1344();
        bufferBuilder.method_22918(matrix, (float)xStart, (float)yStart, this.zLevel).method_22915(red, green, blue, alpha).method_1344();
        bufferBuilder.method_1326();
        class_286.method_1309((class_287)bufferBuilder);
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    public void point(class_4587 matrixStack, int x, int y, int color) {
        this.zFill(matrixStack, x, y, x + 1, y + 1, color);
    }

    public static float zDifference(class_4587 matrixStack, float zLevel) {
        FloatBuffer floatBuffer = FloatBuffer.allocate(16);
        matrixStack.method_23760().method_23761().method_4932(floatBuffer);
        float currentZ = floatBuffer.get(10);
        return zLevel - currentZ < 0.0f ? zLevel - class_3532.method_15379((float)currentZ) : zLevel + class_3532.method_15379((float)currentZ);
    }
}

