/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.network.packets.s2c;

import com.mojang.blaze3d.systems.RenderSystem;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1011;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_156;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_276;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_634;
import thefloydman.linkingbooks.mixin.EntityInvoker;
import thefloydman.linkingbooks.network.packets.c2s.SaveLinkingPanelImagePacket;
import thefloydman.linkingbooks.network.packets.s2c.SpawnEntityPacket;
import thefloydman.linkingbooks.network.packets.s2c.TakeScreenshotForLinkingBookPacket;
import thefloydman.linkingbooks.util.ImageUtils;
import thefloydman.linkingbooks.world.LinkingBooksGlobalPersistentState;

public class ClientPacketHandlers {
    @Environment(value=EnvType.CLIENT)
    public static void handleEntitySpawnPacket(class_310 client, class_634 handler, class_2540 buffer, PacketSender responseSender) {
        SpawnEntityPacket packet = SpawnEntityPacket.fromData(buffer);
        client.execute(() -> {
            class_1299 type = (class_1299)class_2378.field_11145.method_10200(packet.typeId);
            if (type == null) {
                return;
            }
            class_1297 entity = type.method_5883((class_1937)client.field_1687);
            if (entity == null) {
                return;
            }
            entity.method_18003(packet.posX, packet.posY, packet.posZ);
            entity.method_24203(packet.posX, packet.posY, packet.posZ);
            entity.field_5965 = (float)(packet.pitch * 360) / 256.0f;
            entity.field_6031 = (float)(packet.yaw * 360) / 256.0f;
            entity.method_5838(packet.entityId);
            entity.method_5826(packet.uuid);
            entity.method_18800((double)packet.velX / 8000.0, (double)packet.velY / 8000.0, (double)packet.velZ / 8000.0);
            ((EntityInvoker)entity).invokeReadCustomDataFromTag(packet.extraData);
            client.field_1687.method_2942(packet.entityId, entity);
        });
    }

    @Environment(value=EnvType.CLIENT)
    public static void handleTakeScreenshotPacket(class_310 client, class_634 handler, class_2540 buffer, PacketSender responseSender) {
        TakeScreenshotForLinkingBookPacket packet = TakeScreenshotForLinkingBookPacket.fromData(buffer);
        client.execute(() -> {
            if (RenderSystem.isOnRenderThread()) {
                ClientPacketHandlers.getScreenshot(packet.uuid);
            } else {
                RenderSystem.recordRenderCall(() -> ClientPacketHandlers.getScreenshot(packet.uuid));
            }
        });
    }

    @Environment(value=EnvType.CLIENT)
    static void getScreenshot(UUID uuid) {
        class_310 mc = class_310.method_1551();
        class_276 buffer = mc.method_1522();
        float largeWidth = buffer.field_1480;
        float largeHeight = buffer.field_1477;
        float smallWidth = 64.0f;
        float smallHeight = 42.0f;
        if (largeWidth / largeHeight > smallWidth / smallHeight) {
            while (largeHeight % 42.0f != 0.0f) {
                largeHeight -= 1.0f;
            }
            while (largeWidth / largeHeight != smallWidth / smallHeight) {
                largeWidth -= 1.0f;
            }
        } else if (largeWidth / largeHeight < smallWidth / smallHeight) {
            while (largeWidth % 64.0f != 0.0f) {
                largeWidth -= 1.0f;
            }
            while (largeWidth / largeHeight != smallWidth / smallHeight) {
                largeHeight -= 1.0f;
            }
        }
        class_1011 fullImage = new class_1011(buffer.field_1482, buffer.field_1481, false);
        buffer.method_1235(true);
        boolean hide = mc.field_1690.field_1842;
        mc.field_1690.field_1842 = true;
        mc.field_1773.method_3188(mc.method_1488(), class_156.method_648(), new class_4587());
        mc.field_1690.field_1842 = hide;
        buffer.method_1241();
        fullImage.method_4327(0, true);
        mc.method_1522().method_1240();
        fullImage.method_4319();
        class_1011 largeImage = new class_1011((int)largeWidth, (int)largeHeight, false);
        int initialX = (int)(((float)buffer.field_1480 - largeWidth) / 2.0f);
        int initialY = (int)(((float)buffer.field_1477 - largeHeight) / 2.0f);
        int largeY = 0;
        int fullY = initialY;
        while ((float)largeY < largeHeight) {
            int largeX = 0;
            int fullX = initialX;
            while ((float)largeX < largeWidth) {
                largeImage.method_4305(largeX, largeY, fullImage.method_4315(fullX, fullY));
                ++largeX;
                ++fullX;
            }
            ++largeY;
            ++fullY;
        }
        class_1011 smallImage = new class_1011((int)smallWidth, (int)smallHeight, false);
        largeImage.method_4300(0, 0, (int)largeWidth, (int)largeHeight, smallImage);
        largeImage.close();
        fullImage.close();
        class_2487 imageTag = ImageUtils.imageToNBT(smallImage);
        if (class_310.method_1551().method_1496()) {
            LinkingBooksGlobalPersistentState persistentState = (LinkingBooksGlobalPersistentState)class_310.method_1551().method_1576().method_3847(class_1937.field_25179).method_17983().method_17924(LinkingBooksGlobalPersistentState::new, "linkingbooks");
            persistentState.addLinkingPanelImage(uuid, imageTag);
        } else {
            ClientPlayNetworking.send((class_2960)SaveLinkingPanelImagePacket.CHANNEL, (class_2540)new SaveLinkingPanelImagePacket(imageTag, uuid).toData(new class_2540(Unpooled.buffer())));
        }
    }
}

