/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.awt.Color;
import java.util.stream.Stream;
import net.minecraft.class_1662;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3955;
import thefloydman.linkingbooks.api.component.ColorComponent;
import thefloydman.linkingbooks.component.ModComponents;
import thefloydman.linkingbooks.item.ModItems;
import thefloydman.linkingbooks.mixin.IngredientMixin;
import thefloydman.linkingbooks.recipe.ModRecipeSerializers;

public class BlankLinkingBookRecipe
implements class_3955 {
    private final class_2960 id;
    private final class_1799 recipeOutput;
    private final class_2371<class_1856> recipeInputs;

    public BlankLinkingBookRecipe(class_2960 id, class_1799 recipeOutput, class_2371<class_1856> recipeInput) {
        this.recipeOutput = recipeOutput;
        this.recipeInputs = recipeInput;
        this.id = id;
    }

    private static class_2371<class_1856> readIngredients(JsonArray array) {
        class_2371 ingredients = class_2371.method_10211();
        for (int i = 0; i < array.size(); ++i) {
            class_1856 ingredient = class_1856.method_8102((JsonElement)array.get(i));
            if (ingredient.method_8103()) continue;
            ingredients.add((Object)ingredient);
        }
        return ingredients;
    }

    public boolean matches(class_1715 inventory, class_1937 world) {
        class_1662 recipeFinder = new class_1662();
        int i = 0;
        class_2371 craftingInputs = class_2371.method_10211();
        for (int j = 0; j < inventory.method_5439(); ++j) {
            class_1799 itemStack = inventory.method_5438(j);
            if (itemStack.method_7960()) continue;
            ++i;
            recipeFinder.method_20478(itemStack, 1);
            craftingInputs.add((Object)class_1856.method_26964(Stream.of(inventory.method_5438(j))));
        }
        boolean matches = true;
        for (int j = 0; j < craftingInputs.size(); ++j) {
            boolean foundMatch = false;
            block2: for (int k = 0; k < this.recipeInputs.size(); ++k) {
                class_1799[] stacks;
                ((IngredientMixin)this.recipeInputs.get(k)).invokeCacheMatchingStacks();
                for (class_1799 stack : stacks = ((IngredientMixin)this.recipeInputs.get(k)).getMatchingStacks()) {
                    ((IngredientMixin)craftingInputs.get(j)).invokeCacheMatchingStacks();
                    class_1799[] matchingStacks = ((IngredientMixin)craftingInputs.get(j)).getMatchingStacks();
                    if (matchingStacks == null || stack.method_7909() != matchingStacks[0].method_7909()) continue;
                    foundMatch = true;
                    continue block2;
                }
            }
            if (foundMatch) continue;
            matches = false;
            break;
        }
        return i == this.recipeInputs.size() && matches;
    }

    public class_1799 craft(class_1715 inv) {
        return this.recipeOutput.method_7972();
    }

    public boolean method_8113(int width, int height) {
        return width * height >= this.recipeInputs.size();
    }

    public class_1799 method_8110() {
        return this.recipeOutput;
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public class_1865<?> method_8119() {
        return ModRecipeSerializers.BLANK_LINKING_BOOK;
    }

    public static class Serializer
    implements class_1865<BlankLinkingBookRecipe> {
        public BlankLinkingBookRecipe read(class_2960 id, JsonObject json) {
            class_2371 ingredients = BlankLinkingBookRecipe.readIngredients(class_3518.method_15261((JsonObject)json, (String)"ingredients"));
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for blank linking book recipe");
            }
            if (ingredients.size() > 9) {
                throw new JsonParseException("Too many ingredients for blank linking book recipe the max is 9");
            }
            float red = 0.0f;
            float green = 0.0f;
            float blue = 0.0f;
            if (json.has("color") && json.get("color").isJsonObject()) {
                JsonObject color = json.getAsJsonObject("color");
                if (color.has("red") && color.get("red").isJsonPrimitive()) {
                    red = color.get("red").getAsFloat();
                }
                if (color.has("green") && color.get("green").isJsonPrimitive()) {
                    green = color.get("green").getAsFloat();
                }
                if (color.has("blue") && color.get("blue").isJsonPrimitive()) {
                    blue = color.get("blue").getAsFloat();
                }
            }
            class_1799 stack = ModItems.BLANK_LINKING_BOOK.method_7854();
            ColorComponent color = (ColorComponent)ModComponents.ITEM_COLOR.get((Object)stack);
            color.setColor(new Color(red, green, blue).getRGB());
            return new BlankLinkingBookRecipe(id, stack, (class_2371<class_1856>)ingredients);
        }

        public BlankLinkingBookRecipe read(class_2960 id, class_2540 buffer) {
            int i = buffer.method_10816();
            class_2371 ingredients = class_2371.method_10213((int)i, (Object)class_1856.field_9017);
            for (int j = 0; j < ingredients.size(); ++j) {
                ingredients.set(j, (Object)class_1856.method_8086((class_2540)buffer));
            }
            class_1799 stack = buffer.method_10819();
            return new BlankLinkingBookRecipe(id, stack, (class_2371<class_1856>)ingredients);
        }

        public void write(class_2540 buffer, BlankLinkingBookRecipe recipe) {
            buffer.method_10804(recipe.recipeInputs.size());
            for (class_1856 ingredient : recipe.recipeInputs) {
                ingredient.method_8088(buffer);
            }
            buffer.method_10793(recipe.recipeOutput);
        }
    }
}

