/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.neoforged.fml.ModList;
import thefloydman.linkingbooks.world.generation.AgeInfo;

public class Reference {
    public static final String MODID = "linkingbooks";
    public static MinecraftServer server = null;
    public static final Map<UUID, String> PLAYER_DISPLAY_NAMES = new HashMap<UUID, String>();
    public static final Map<ResourceLocation, AgeInfo> AGE_INFO_MAP = new HashMap<ResourceLocation, AgeInfo>();

    public static ResourceLocation getAsResourceLocation(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    public static boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    public static boolean isImmersivePortalsLoaded() {
        return Reference.isModLoaded("immersive_portals_core");
    }

    public static class Resources {
        public static final ResourceLocation INK_TEXTURE = Reference.getAsResourceLocation("block/ink_still");
        public static final ResourceLocation FLOWING_INK_TEXTURE = Reference.getAsResourceLocation("block/ink_flow");
        public static final ResourceLocation LINKING_BOOK_TEXTURE = Reference.getAsResourceLocation("textures/entity/linking_book.png");
    }

    public static class CreativeModeTabNames {
        public static final String MAIN = "main";
    }

    public static class CelestialObjectNames {
        public static final String SUN = "sun";
    }

    public static class RegistryKeyNames {
        public static final String LINK_EFFECT_TYPE = "linkeffecttype";
        public static final String LINK_EFFECT = "linkeffect";
        public static final String SKY_OBJECT_TYPE = "skyobjecttype";
    }

    public static class SoundNames {
        public static final String PAGEFLIP_FORWARD = "pageflip_forward";
        public static final String PAGEFLIP_BACK = "pageflip_back";
        public static final String BOOK_OPEN = "book_open";
        public static final String BOOK_CLOSE = "book_close";
        public static final String LINK = "link";
    }

    public static class LinkEffectTypeNames {
        public static final String MOB_EFFECT = "mob_effect";
        public static final String BASIC = "basic";
    }

    public static class RecipeSerializerNames {
        public static final String LINK_EFFECT = "link_effect";
    }

    public static class DataComponentNames {
        public static final String LINK_DATA = "link_data";
    }

    public static class CapabilityNames {
        public static final ResourceLocation LINK_DATA = Reference.getAsResourceLocation("link_data");
    }

    public static class ContainerNames {
        public static final String LINKING_BOOK = "linking_book";
        public static final String RELTO_BOOK = "relto_book";
        public static final String GUIDEBOOK = "guidebook";
    }

    public static class TileEntityNames {
        public static final String LINKING_LECTERN = "linking_lectern";
        public static final String LINK_TRANSLATOR = "link_translator";
        public static final String MARKER_SWITCH = "marker_switch";
    }

    public static class EntityNames {
        public static final String LINKING_BOOK = "linking_book";
        public static final String LINKING_PORTAL = "linking_portal";
    }

    public static class ItemNames {
        public static final String GUIDEBOOK = "guidebook";
        public static final String BLANK_LINKING_BOOK = "blank_linking_book";
        public static final String WRITTEN_LINKING_BOOK = "written_linking_book";
        public static final String RELTO_BOOK = "relto_book";
        public static final String LINKING_PANEL = "linking_panel";
    }

    public static class BlockNames {
        public static final String LINKING_LECTERN = "linking_lectern";
        public static final String MARKER_SWITCH = "marker_switch";
        public static final String NARA = "nara";
        public static final String LINK_TRANSLATOR = "link_translator";
        public static final String LINKING_PORTAL = "linking_portal";
        public static final String BOOKSHELF_STAIRS = "bookshelf_stairs";
    }
}

