/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.blockentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import thefloydman.linkingbooks.item.ReltoBookItem;
import thefloydman.linkingbooks.item.WrittenLinkingBookItem;

public class LinkingBookHolderBlockEntity
extends BlockEntity
implements IItemHandler {
    @Nonnull
    private ItemStack book = ItemStack.EMPTY;

    public LinkingBookHolderBlockEntity(BlockEntityType<? extends LinkingBookHolderBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Nullable
    public LinkingBookHolderBlockEntity getItemHandler(LinkingBookHolderBlockEntity linkingLecternBlockEntity, @Nullable Direction side) {
        return side == null ? null : this;
    }

    @Nonnull
    public ItemStack getBook() {
        return this.book;
    }

    public boolean hasBook() {
        return !this.getStackInSlot(0).isEmpty();
    }

    public void setChanged() {
        super.setChanged();
        Level level = this.getLevel();
        if (level != null) {
            level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public void loadAdditional(@Nonnull CompoundTag nbt, @Nonnull HolderLookup.Provider registryAccess) {
        super.loadAdditional(nbt, registryAccess);
        if (nbt.contains("book", 10)) {
            this.book = ItemStack.parseOptional((HolderLookup.Provider)registryAccess, (CompoundTag)nbt.getCompound("book"));
        }
    }

    protected void saveAdditional(@Nonnull CompoundTag nbt, @Nonnull HolderLookup.Provider registryAccess) {
        super.saveAdditional(nbt, registryAccess);
        nbt.put("book", this.book.saveOptional(registryAccess));
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @Nonnull
    public CompoundTag getUpdateTag(@Nonnull HolderLookup.Provider registryAccess) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, registryAccess);
        return tag;
    }

    public void handleUpdateTag(@Nonnull CompoundTag nbt, @Nonnull HolderLookup.Provider registryAccess) {
        super.handleUpdateTag(nbt, registryAccess);
        this.loadAdditional(nbt, registryAccess);
    }

    public void onDataPacket(@Nonnull Connection net, @Nonnull ClientboundBlockEntityDataPacket packet, @Nonnull HolderLookup.Provider registryAccess) {
        super.onDataPacket(net, packet, registryAccess);
        this.loadAdditional(packet.getTag(), registryAccess);
    }

    public int getSlots() {
        return 1;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.book;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack itemStack, boolean simulate) {
        if (this.isItemValid(0, itemStack)) {
            int slotLimit = this.getSlotLimit(slot);
            if (!simulate) {
                this.book = itemStack.copyWithCount(slotLimit);
                this.setChanged();
            }
            ItemStack returnStack = itemStack.copy();
            returnStack.shrink(slotLimit);
            return returnStack;
        }
        return itemStack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (simulate) {
            return this.book.copyWithCount(Math.min(amount, this.book.getCount()));
        }
        ItemStack stack = this.book.split(amount);
        this.setChanged();
        return stack;
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack itemStack) {
        return itemStack.getItem() instanceof WrittenLinkingBookItem || itemStack.getItem() instanceof ReltoBookItem;
    }
}

