/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.blockentity;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import thefloydman.linkingbooks.blockentity.ModBlockEntityTypes;

public class MarkerSwitchBlockEntity
extends BlockEntity
implements IItemHandler {
    @Nonnull
    private ItemStack item = ItemStack.EMPTY;

    public MarkerSwitchBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntityTypes.MARKER_SWITCH.get(), pos, state);
    }

    public boolean hasItem() {
        return !this.getStackInSlot(0).isEmpty();
    }

    public void setChanged() {
        super.setChanged();
        Level level = this.getLevel();
        if (level != null) {
            level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public void loadAdditional(@Nonnull CompoundTag nbt, @Nonnull HolderLookup.Provider registryAccess) {
        super.loadAdditional(nbt, registryAccess);
        this.item = ItemStack.parseOptional((HolderLookup.Provider)registryAccess, (CompoundTag)nbt.getCompound("item"));
    }

    protected void saveAdditional(@Nonnull CompoundTag nbt, @Nonnull HolderLookup.Provider registryAccess) {
        super.saveAdditional(nbt, registryAccess);
        nbt.put("item", this.item.saveOptional(registryAccess));
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @Nonnull
    public CompoundTag getUpdateTag(@Nonnull HolderLookup.Provider registryAccess) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, registryAccess);
        return tag;
    }

    public void handleUpdateTag(@Nonnull CompoundTag nbt, @Nonnull HolderLookup.Provider registryAccess) {
        super.handleUpdateTag(nbt, registryAccess);
        this.loadAdditional(nbt, registryAccess);
    }

    public void onDataPacket(@Nonnull Connection net, @Nonnull ClientboundBlockEntityDataPacket packet, @Nonnull HolderLookup.Provider registryAccess) {
        super.onDataPacket(net, packet, registryAccess);
        this.loadAdditional(packet.getTag(), registryAccess);
    }

    public int getSlots() {
        return 1;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.item;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        int slotLimit = this.getSlotLimit(slot);
        this.item = stack.copyWithCount(slotLimit);
        this.setChanged();
        ItemStack returnStack = stack.copy();
        returnStack.shrink(slotLimit);
        return returnStack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int count, boolean simulate) {
        ItemStack stack = this.item.split(count);
        this.setChanged();
        return stack;
    }

    public int getSlotLimit(int slot) {
        return Integer.MAX_VALUE;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack itemStack) {
        return true;
    }
}

