/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.blockentity;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.registries.DeferredRegister;
import thefloydman.linkingbooks.block.ModBlocks;
import thefloydman.linkingbooks.blockentity.LinkTranslatorBlockEntity;
import thefloydman.linkingbooks.blockentity.LinkingLecternBlockEntity;
import thefloydman.linkingbooks.blockentity.MarkerSwitchBlockEntity;

public class ModBlockEntityTypes {
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (String)"linkingbooks");
    public static final Supplier<BlockEntityType<LinkingLecternBlockEntity>> LINKING_LECTERN = BLOCK_ENTITIES.register("linking_lectern", ModBlockEntityTypes.make(LinkingLecternBlockEntity::new, ModBlocks.LINKING_LECTERN));
    public static final Supplier<BlockEntityType<LinkTranslatorBlockEntity>> LINK_TRANSLATOR = BLOCK_ENTITIES.register("link_translator", ModBlockEntityTypes.make(LinkTranslatorBlockEntity::new, ModBlocks.LINK_TRANSLATOR));
    public static final Supplier<BlockEntityType<MarkerSwitchBlockEntity>> MARKER_SWITCH = BLOCK_ENTITIES.register("marker_switch", ModBlockEntityTypes.make(MarkerSwitchBlockEntity::new, ModBlocks.MARKER_SWITCH));

    public static <T extends BlockEntity> Supplier<BlockEntityType<T>> make(BlockEntityType.BlockEntitySupplier<T> create, Supplier<? extends Block> valid) {
        return ModBlockEntityTypes.makeMultipleBlocks(create, (Collection<? extends Supplier<? extends Block>>)ImmutableSet.of(valid));
    }

    public static <T extends BlockEntity> Supplier<BlockEntityType<T>> makeMultipleBlocks(BlockEntityType.BlockEntitySupplier<T> create, Collection<? extends Supplier<? extends Block>> valid) {
        return () -> new BlockEntityType(create, (Set)ImmutableSet.copyOf((Collection)valid.stream().map(Supplier::get).collect(Collectors.toList())), null);
    }
}

