/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.compress.utils.Lists;
import thefloydman.linkingbooks.Reference;
import thefloydman.linkingbooks.client.gui.widget.GuiBookPageWidget;
import thefloydman.linkingbooks.client.gui.widget.NestedWidget;
import thefloydman.linkingbooks.client.gui.widget.PageChangeWidget;
import thefloydman.linkingbooks.client.sound.ModSounds;

@OnlyIn(value=Dist.CLIENT)
public class BookWidget
extends NestedWidget {
    private static final ResourceLocation COVER_TEXTURE = Reference.getAsResourceLocation("textures/gui/book/book_cover_regular.png");
    private static final ResourceLocation PAPER_TEXTURE = Reference.getAsResourceLocation("textures/gui/book/book_paper_regular.png");
    private final List<GuiBookPageWidget> pages = Lists.newArrayList();
    private final PageChangeWidget previousArrow;
    private final PageChangeWidget nextArrow;
    private int currentSpread = 0;
    private final int color;

    public BookWidget(String id, int x, int y, float z, int width, int height, int color, Component narration, Screen parentScreen, float scale, Font font, List<List<Object>> pages) {
        super(id, x, y, z, width, height, narration, parentScreen, scale);
        this.color = color;
        int marginLeftX = 20;
        int marginRightX = 10;
        int marginY = 14;
        float iteratedZ = z;
        for (int i = 0; i < pages.size(); ++i) {
            List<Object> page = pages.get(i);
            int localX = i % 2 == 0 ? x + marginLeftX : x + width / 2 + marginRightX;
            float f = iteratedZ;
            iteratedZ = f + 1.0f;
            GuiBookPageWidget child = this.addChild(new GuiBookPageWidget("guidebook page " + i, localX, y + marginY, f, width / 2 - marginLeftX - marginRightX, height / 2 - marginY * 2, (Component)Component.literal((String)("Page " + i)), parentScreen, Float.valueOf(1.0f), font, page));
            child.setVisible(false);
            this.pages.add(child);
        }
        float f = iteratedZ += 100.0f;
        iteratedZ = f + 1.0f;
        this.previousArrow = this.addChild(new PageChangeWidget("back arrow", this.getX() + 12, this.getY() + this.getHeight() - 21, f, (Component)Component.literal((String)"Previous Page"), parentScreen, 1.0f, PageChangeWidget.Type.BACKWARD));
        float f2 = iteratedZ;
        iteratedZ = f2 + 1.0f;
        this.nextArrow = this.addChild(new PageChangeWidget("forward arrow", this.getX() + this.getWidth() - 18 - 18, this.getY() + this.getHeight() - 21, f2, (Component)Component.literal((String)"Next Page"), parentScreen, 1.0f, PageChangeWidget.Type.FORWARD));
        this.previousArrow.addListener((GuiEventListener)this);
        this.nextArrow.addListener((GuiEventListener)this);
        this.updateVisible();
    }

    @Override
    public void renderWidget(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.getVisible()) {
            guiGraphics.pose().pushPose();
            float[] color = new Color(this.color).getRGBColorComponents(null);
            RenderSystem.setShaderColor((float)Mth.clamp((float)color[0], (float)0.1f, (float)1.0f), (float)Mth.clamp((float)color[1], (float)0.1f, (float)1.0f), (float)Mth.clamp((float)color[2], (float)0.1f, (float)1.0f), (float)1.0f);
            guiGraphics.blit(COVER_TEXTURE, this.getX(), this.getY(), 0, 0, this.width, this.height);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.blit(PAPER_TEXTURE, this.getX(), this.getY(), 0, 0, this.width, this.height);
            this.renderChildren(guiGraphics, mouseX, mouseY, partialTicks);
            guiGraphics.pose().popPose();
        }
    }

    public void previousPage() {
        --this.currentSpread;
        if (this.currentSpread < 0) {
            this.currentSpread = 0;
        }
        this.updateVisible();
        if (this.minecraft != null && this.minecraft.player != null) {
            this.minecraft.player.playSound(ModSounds.PAGEFLIP_BACK.get());
        }
    }

    public void nextPage() {
        ++this.currentSpread;
        if (this.currentSpread * 2 >= this.pages.size()) {
            this.currentSpread = Mth.floor((float)((float)this.pages.size() / 2.0f)) - 1;
        }
        this.updateVisible();
        if (this.minecraft != null && this.minecraft.player != null) {
            this.minecraft.player.playSound(ModSounds.PAGEFLIP_FORWARD.get());
        }
    }

    private void updateVisible() {
        for (int i = 0; i < this.pages.size(); ++i) {
            this.pages.get(i).setVisible(i == this.currentSpread * 2 || i == this.currentSpread * 2 + 1);
        }
        this.previousArrow.setVisible(this.currentSpread > 0);
        this.nextArrow.setVisible(this.currentSpread * 2 + 1 < this.pages.size() - 1);
    }

    @Override
    public void restore(NestedWidget backup) {
        BookWidget old = (BookWidget)backup;
        if (old != null) {
            this.currentSpread = old.currentSpread;
            this.updateVisible();
        }
    }
}

