/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.client.gui.widget;

import java.awt.Color;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import thefloydman.linkingbooks.client.gui.widget.NestedWidget;

@OnlyIn(value=Dist.CLIENT)
public class ItemStackWidget
extends NestedWidget {
    public long creationTime;
    public final long changeTime = 2000L;
    protected final List<ItemStack> itemStacks;

    public ItemStackWidget(String id, int x, int y, float z, int width, int height, Component narration, Screen parentScreen, float scale, List<ItemStack> itemStacks) {
        super(id, x, y, z, width, height, narration, parentScreen, scale);
        this.itemStacks = itemStacks;
        this.creationTime = System.currentTimeMillis();
    }

    @Override
    public void renderWidget(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.getVisible() && !this.itemStacks.isEmpty()) {
            float f = System.currentTimeMillis() - this.creationTime;
            Objects.requireNonNull(this);
            int changeIndex = Mth.floor((float)(f / 2000.0f));
            ItemStack stack = this.itemStacks.get(changeIndex % this.itemStacks.size());
            if (stack.isEmpty()) {
                return;
            }
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((double)this.getX() + (double)this.scale * 2.0, (double)this.getY() + (double)this.scale * 2.0, (double)(150.0f + this.zLevel));
            guiGraphics.renderItem(stack, this.getX(), this.getY());
            if (stack.getCount() > 1) {
                guiGraphics.pose().pushPose();
                guiGraphics.pose().translate(0.0, 0.0, 10.0);
                int xOff = 9;
                int yOff = 6;
                guiGraphics.drawString(this.minecraft.font, String.valueOf(stack.getCount()), (float)(this.getX() + xOff) / this.scale, (float)(this.getY() + yOff) / this.scale, Color.BLACK.getRGB(), false);
                guiGraphics.pose().popPose();
            }
            if (this.isInside(mouseX, mouseY)) {
                guiGraphics.renderTooltip(this.minecraft.font, stack, mouseX, mouseY);
            }
            guiGraphics.pose().popPose();
        }
    }

    @Override
    public void restore(NestedWidget backup) {
        if (backup instanceof ItemStackWidget) {
            ItemStackWidget old = (ItemStackWidget)backup;
            this.creationTime = old.creationTime;
        }
    }
}

