/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.client.gui.widget;

import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import thefloydman.linkingbooks.Reference;
import thefloydman.linkingbooks.client.gui.widget.NestedWidget;
import thefloydman.linkingbooks.client.gui.widget.RecipeWidget;

@OnlyIn(value=Dist.CLIENT)
public class RecipeCarouselWidget
extends NestedWidget {
    protected static final ResourceLocation CRAFTING_TEXTURE = Reference.getAsResourceLocation("textures/gui/guidebook/crafting.png");
    public long creationTime;
    public long changeTime = 2000L;
    public int totalVariations = 0;
    Map<Integer, NestedWidget> renderMap = Maps.newHashMap();

    public RecipeCarouselWidget(String id, int x, int y, float z, int width, int height, Component narration, Screen parentScreen, float scale, List<List<List<ItemStack>>> recipes) {
        super(id, x, y, z, width, height, narration, parentScreen, scale);
        for (int i = 0; i < recipes.size(); ++i) {
            List<List<ItemStack>> ingredients = recipes.get(i);
            RecipeWidget recipeWidget = new RecipeWidget(this.id + "recipe" + i, this.getX(), this.getY(), z + 1.0f, this.width, this.height, (Component)Component.literal((String)"Recipe"), parentScreen, 0.5f, ingredients);
            this.addChild(recipeWidget);
            Optional<List> optionalItemStackList = ingredients.stream().max(Comparator.comparing(List::size));
            if (!optionalItemStackList.isPresent()) continue;
            int size = optionalItemStackList.get().size();
            this.totalVariations += size;
            for (int j = 0; j < size; ++j) {
                this.renderMap.put(this.renderMap.size(), recipeWidget);
            }
        }
        this.creationTime = System.currentTimeMillis();
    }

    @Override
    public void renderWidget(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int generalIndex;
        NestedWidget recipeWidget;
        if (this.getVisible() && (recipeWidget = this.renderMap.get(generalIndex = Mth.floor((float)((float)(System.currentTimeMillis() - this.creationTime) / (float)this.changeTime)) % this.totalVariations)) != null) {
            recipeWidget.renderWidget(guiGraphics, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public void restore(NestedWidget backup) {
        if (backup instanceof RecipeCarouselWidget) {
            RecipeCarouselWidget old = (RecipeCarouselWidget)backup;
            this.creationTime = old.creationTime;
        }
    }
}

