/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.awt.Color;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;
import thefloydman.linkingbooks.Reference;
import thefloydman.linkingbooks.block.LinkingLecternBlock;
import thefloydman.linkingbooks.blockentity.LinkingLecternBlockEntity;
import thefloydman.linkingbooks.client.renderer.entity.model.LinkingBookCoverModel;
import thefloydman.linkingbooks.client.renderer.entity.model.LinkingBookPagesModel;
import thefloydman.linkingbooks.client.renderer.entity.model.ModModelLayers;
import thefloydman.linkingbooks.linking.LinkingUtils;

public class LinkingLecternRenderer
implements BlockEntityRenderer<LinkingLecternBlockEntity> {
    private final LinkingBookCoverModel coverModel;
    private final LinkingBookPagesModel pagesModel;

    public LinkingLecternRenderer(BlockEntityRendererProvider.Context context) {
        this.coverModel = new LinkingBookCoverModel(context.bakeLayer(ModModelLayers.COVER));
        this.coverModel.setBookState(0.95f);
        this.pagesModel = new LinkingBookPagesModel(context.bakeLayer(ModModelLayers.PAGES));
        this.pagesModel.setBookState(0.95f);
    }

    public void render(LinkingLecternBlockEntity tileEntity, float arg1, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (tileEntity.hasBook()) {
            ItemStack bookStack = tileEntity.getBook();
            int coverColor = LinkingUtils.getLinkingBookColor(bookStack, 0);
            matrixStack.pushPose();
            float rotation = 0.0f;
            double[] translate = new double[]{0.0, 0.0, 0.0};
            switch ((Direction)tileEntity.getBlockState().getValue((Property)LinkingLecternBlock.FACING)) {
                case NORTH: {
                    rotation = 1.0f;
                    translate[0] = 0.5;
                    translate[1] = 1.0;
                    translate[2] = 0.4;
                    break;
                }
                case WEST: {
                    rotation = 2.0f;
                    translate[0] = 0.4;
                    translate[1] = 1.0;
                    translate[2] = 0.5;
                    break;
                }
                case SOUTH: {
                    rotation = 3.0f;
                    translate[0] = 0.5;
                    translate[1] = 1.0;
                    translate[2] = 0.6;
                    break;
                }
                case EAST: {
                    rotation = 0.0f;
                    translate[0] = 0.6;
                    translate[1] = 1.0;
                    translate[2] = 0.5;
                    break;
                }
                default: {
                    rotation = 1.0f;
                    translate[0] = 0.5;
                    translate[1] = 1.0;
                    translate[2] = 0.4;
                }
            }
            matrixStack.translate(translate[0], translate[1], translate[2]);
            matrixStack.mulPose(Axis.YP.rotation((float)Math.PI * rotation / 2.0f));
            matrixStack.mulPose(Axis.XP.rotation((float)Math.PI));
            matrixStack.mulPose(Axis.ZP.rotation(-1.1766264f));
            matrixStack.scale(0.75f, 0.75f, 0.75f);
            VertexConsumer vertexBuilder = buffer.getBuffer(this.coverModel.renderType(Reference.Resources.LINKING_BOOK_TEXTURE));
            this.coverModel.renderToBuffer(matrixStack, vertexBuilder, combinedLight, combinedOverlay, coverColor);
            this.pagesModel.renderToBuffer(matrixStack, vertexBuilder, combinedLight, combinedOverlay, Color.WHITE.getRGB());
            matrixStack.popPose();
        }
    }
}

