/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionf;
import thefloydman.linkingbooks.block.MarkerSwitchBlock;
import thefloydman.linkingbooks.blockentity.MarkerSwitchBlockEntity;

public class MarkerSwitchRenderer
implements BlockEntityRenderer<MarkerSwitchBlockEntity> {
    private final ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();

    public MarkerSwitchRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(MarkerSwitchBlockEntity tileEntity, float partialTicks, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        BlockState blockState = tileEntity.getLevel().getBlockState(tileEntity.getBlockPos());
        if (blockState.getBlock() instanceof MarkerSwitchBlock && ((Boolean)blockState.getValue((Property)MarkerSwitchBlock.OPEN)).booleanValue() && tileEntity.getLevel().getBlockState(tileEntity.getBlockPos()).getValue(MarkerSwitchBlock.HALF) == DoubleBlockHalf.LOWER && tileEntity.hasItem()) {
            ItemStack itemStack = tileEntity.getStackInSlot(0);
            poseStack.pushPose();
            double y = (double)Mth.sin((float)((float)(tileEntity.getLevel().getGameTime() % 80L) / 80.0f * (float)Math.PI * 2.0f)) / 20.0 + 0.8;
            poseStack.translate(0.5, y, 0.5);
            poseStack.scale(0.5f, 0.5f, 0.5f);
            poseStack.rotateAround(new Quaternionf().rotationY((float)(tileEntity.getLevel().getGameTime() % 160L) / 160.0f * (float)Math.PI * 2.0f), 0.0f, 0.0f, 0.0f);
            Direction facing = (Direction)tileEntity.getBlockState().getValue((Property)MarkerSwitchBlock.FACING);
            float rotation = facing == Direction.EAST || facing == Direction.WEST ? facing.toYRot() + 45.0f : facing.toYRot() - 135.0f;
            poseStack.mulPose(Axis.YP.rotationDegrees(rotation));
            int lightAbove = LevelRenderer.getLightColor((BlockAndTintGetter)tileEntity.getLevel(), (BlockPos)tileEntity.getBlockPos().above());
            this.itemRenderer.renderStatic(itemStack, ItemDisplayContext.FIXED, lightAbove, OverlayTexture.NO_OVERLAY, poseStack, bufferSource, tileEntity.getLevel(), 0);
            poseStack.popPose();
        }
    }
}

