/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.awt.Color;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import thefloydman.linkingbooks.Reference;
import thefloydman.linkingbooks.client.renderer.entity.model.LinkingBookCoverModel;
import thefloydman.linkingbooks.client.renderer.entity.model.LinkingBookPagesModel;
import thefloydman.linkingbooks.client.renderer.entity.model.ModModelLayers;
import thefloydman.linkingbooks.entity.LinkingBookEntity;
import thefloydman.linkingbooks.item.ReltoBookItem;
import thefloydman.linkingbooks.item.WrittenLinkingBookItem;
import thefloydman.linkingbooks.linking.LinkingUtils;

public class LinkingBookRenderer
extends EntityRenderer<LinkingBookEntity> {
    private final LinkingBookCoverModel coverModel;
    private final LinkingBookPagesModel pagesModel;
    private int color = new Color(0.0f, 1.0f, 0.0f, 1.0f).getRGB();

    public LinkingBookRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.coverModel = new LinkingBookCoverModel(context.bakeLayer(ModModelLayers.COVER));
        this.coverModel.setBookState(0.9f);
        this.pagesModel = new LinkingBookPagesModel(context.bakeLayer(ModModelLayers.PAGES));
        this.pagesModel.setBookState(0.9f);
    }

    public void render(LinkingBookEntity entity, float yaw, float partialTicks, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int packedLight) {
        Item item;
        ItemStack bookStack = entity.getItem();
        if (bookStack != null && !bookStack.isEmpty() && ((item = bookStack.getItem()) instanceof WrittenLinkingBookItem || item instanceof ReltoBookItem)) {
            this.color = LinkingUtils.getLinkingBookColor(bookStack, 0);
        }
        matrixStack.pushPose();
        matrixStack.scale(0.75f, 0.75f, 0.75f);
        matrixStack.mulPose(Axis.XP.rotation((float)Math.PI));
        matrixStack.mulPose(Axis.YP.rotation(yaw / 360.0f * (float)Math.PI * 2.0f - 1.5707964f));
        matrixStack.mulPose(Axis.ZP.rotation(4.712389f));
        VertexConsumer vertexBuilder = buffer.getBuffer(this.coverModel.renderType(Reference.Resources.LINKING_BOOK_TEXTURE));
        if (entity.hurtTime > 0) {
            this.coverModel.renderToBuffer(matrixStack, vertexBuilder, packedLight, OverlayTexture.NO_OVERLAY, new Color(0.7f, 0.0f, 0.0f, 0.4f).getRGB());
            this.pagesModel.renderToBuffer(matrixStack, vertexBuilder, packedLight, OverlayTexture.NO_OVERLAY, new Color(0.7f, 0.0f, 0.0f, 0.4f).getRGB());
        } else {
            this.coverModel.renderToBuffer(matrixStack, vertexBuilder, packedLight, OverlayTexture.NO_OVERLAY, this.color);
            this.pagesModel.renderToBuffer(matrixStack, vertexBuilder, packedLight, OverlayTexture.NO_OVERLAY);
        }
        matrixStack.popPose();
    }

    @Nonnull
    public ResourceLocation getTextureLocation(@Nonnull LinkingBookEntity entity) {
        return Reference.getAsResourceLocation("textures/entity/linking_book.png");
    }

    protected boolean shouldShowName(@Nonnull LinkingBookEntity entity) {
        return super.shouldShowName((Entity)entity) && (entity.shouldShowName() || entity.hasCustomName() && entity == this.entityRenderDispatcher.crosshairPickEntity);
    }
}

